/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import cz.autel.dmi.HIGLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sf.freecol.client.control.InGameController;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.Unit;

public final class DumpCargoDialog
extends FreeColDialog
implements ActionListener {
    private static final Logger logger = Logger.getLogger(DumpCargoDialog.class.getName());
    private static final int OK = 0;
    private static final int CANCEL = 1;
    private final Canvas parent;
    private final JLabel header;
    private final JButton okButton;
    private final JButton cancelButton;
    private List<Goods> goodsList;
    private List<JCheckBox> checkBoxes;

    public DumpCargoDialog(Canvas parent) {
        this.parent = parent;
        this.header = new JLabel("", 0);
        this.header.setFont(mediumHeaderFont);
        this.header.setText(Messages.message("dumpGoods", new String[0]));
        this.header.setAlignmentX(0.5f);
        this.okButton = new JButton(Messages.message("ok", new String[0]));
        this.okButton.setActionCommand(String.valueOf(0));
        this.okButton.addActionListener(this);
        this.okButton.setAlignmentX(0.5f);
        this.cancelButton = new JButton("cancel");
        this.cancelButton.setActionCommand(String.valueOf(1));
        this.cancelButton.addActionListener(this);
        this.cancelButton.setAlignmentX(0.5f);
    }

    public void requestFocus() {
        this.okButton.requestFocus();
    }

    public void initialize(Unit unit) {
        this.removeAll();
        this.goodsList = unit.getGoodsList();
        this.checkBoxes = new ArrayList<JCheckBox>(this.goodsList.size());
        int[] widths = new int[]{0};
        int[] heights = new int[2 * this.goodsList.size() + 1];
        for (int index = 1; index < heights.length; index += 2) {
            heights[index] = 3;
        }
        this.setLayout(new HIGLayout(widths, heights));
        int row = 1;
        ImageLibrary library = this.parent.getGUI().getImageLibrary();
        for (Goods goods : this.goodsList) {
            JCheckBox checkBox = new JCheckBox(goods.toString(), true);
            this.checkBoxes.add(checkBox);
            this.add((Component)checkBox, higConst.rc(row, 1));
            row += 2;
        }
        JPanel buttonPanel = new JPanel();
        buttonPanel.setOpaque(false);
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        this.add((Component)buttonPanel, higConst.rc(row, 1));
        this.setSize(this.getPreferredSize());
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        try {
            switch (Integer.valueOf(command)) {
                case 0: {
                    InGameController inGameController = this.parent.getClient().getInGameController();
                    for (int index = 0; index < this.checkBoxes.size(); ++index) {
                        if (!this.checkBoxes.get(index).isSelected()) continue;
                        inGameController.unloadCargo(this.goodsList.get(index));
                    }
                    this.setResponse(new Boolean(true));
                    break;
                }
                case 1: {
                    this.setResponse(new Boolean(false));
                    break;
                }
                default: {
                    logger.warning("Invalid Actioncommand: invalid number.");
                    break;
                }
            }
        }
        catch (NumberFormatException e) {
            logger.warning("Invalid Actioncommand: not a number.");
        }
    }
}

