/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import cz.autel.dmi.HIGLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JTextArea;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.UnitType;

public final class EmigrationPanel
extends FreeColDialog
implements ActionListener {
    private static final Logger logger = Logger.getLogger(EmigrationPanel.class.getName());
    private static final int NUMBER_OF_PERSONS = 3;
    private static final JButton[] person = new JButton[3];
    private JTextArea question = EmigrationPanel.getDefaultTextArea(Messages.message("chooseImmigrant", new String[0]));

    public EmigrationPanel(Canvas parent) {
        super(parent);
        for (int index = 0; index < 3; ++index) {
            EmigrationPanel.person[index] = new JButton();
            person[index].setActionCommand(String.valueOf(index));
            person[index].addActionListener(this);
            EmigrationPanel.enterPressesWhenFocused(person[index]);
        }
    }

    public void requestFocus() {
        person[0].requestFocus();
    }

    public void initialize(Europe europe, boolean fountainOfYouth) {
        if (fountainOfYouth) {
            this.question.insert(Messages.message("lostCityRumour.FountainOfYouth", new String[0]) + "\n\n", 0);
        }
        ImageLibrary library = this.getCanvas().getGUI().getImageLibrary();
        int[] widths = new int[]{0};
        int[] heights = new int[]{0, 3, 0, 3, 0, 3, 0};
        int column = 1;
        this.setLayout(new HIGLayout(widths, heights));
        int row = 1;
        this.add((Component)this.question, higConst.rc(row, column));
        row += 2;
        for (int index = 0; index < 3; ++index) {
            UnitType unitType = europe.getRecruitable(index);
            ImageIcon unitIcon = library.getUnitImageIcon(unitType);
            person[index].setText(unitType.getName());
            person[index].setIcon(library.getScaledImageIcon(unitIcon, 0.66f));
            this.add((Component)person[index], higConst.rc(row, column));
            row += 2;
        }
        this.setSize(this.getPreferredSize());
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        try {
            int action = Integer.valueOf(command);
            if (action >= 0 && action < 3) {
                this.setResponse(new Integer(action));
            } else {
                logger.warning("Invalid Actioncommand: invalid number.");
            }
        }
        catch (NumberFormatException e) {
            logger.warning("Invalid Actioncommand: not a number.");
        }
    }
}

