/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import cz.autel.dmi.HIGLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseListener;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ComponentInputMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.ClientOptions;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.InGameController;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.CargoPanel;
import net.sf.freecol.client.gui.panel.DefaultTransferHandler;
import net.sf.freecol.client.gui.panel.DragListener;
import net.sf.freecol.client.gui.panel.DropListener;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.GoodsLabel;
import net.sf.freecol.client.gui.panel.MarketLabel;
import net.sf.freecol.client.gui.panel.UnitLabel;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.TransactionListener;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.resources.ResourceManager;

public final class EuropePanel
extends FreeColPanel
implements ActionListener {
    private static Logger logger = Logger.getLogger(EuropePanel.class.getName());
    private final Canvas parent;
    private final FreeColClient freeColClient;
    private InGameController inGameController;
    private final ToAmericaPanel toAmericaPanel;
    private final ToEuropePanel toEuropePanel;
    private final InPortPanel inPortPanel;
    private final DocksPanel docksPanel;
    private final EuropeCargoPanel cargoPanel;
    private final MarketPanel marketPanel;
    private final TransactionLog log;
    private final DefaultTransferHandler defaultTransferHandler;
    private final MouseListener pressListener;
    private Europe europe;
    private Game game;
    private UnitLabel selectedUnit;
    private JButton exitButton;

    public EuropePanel(Canvas parent, FreeColClient freeColClient, InGameController inGameController) {
        this.parent = parent;
        this.freeColClient = freeColClient;
        this.inGameController = inGameController;
        this.setFocusCycleRoot(true);
        this.exitButton = new JButton(Messages.message("close", new String[0]));
        this.exitButton.setActionCommand(EuropeAction.EXIT.toString());
        this.exitButton.addActionListener(this);
        ComponentInputMap closeInputMap = new ComponentInputMap(this.exitButton);
        ((InputMap)closeInputMap).put(KeyStroke.getKeyStroke(27, 0, false), "pressed");
        ((InputMap)closeInputMap).put(KeyStroke.getKeyStroke(27, 0, true), "released");
        SwingUtilities.replaceUIInputMap(this.exitButton, 2, closeInputMap);
        EuropePanel.enterPressesWhenFocused(this.exitButton);
        JButton trainButton = new JButton(Messages.message("train", new String[0]));
        trainButton.setActionCommand(EuropeAction.TRAIN.toString());
        trainButton.addActionListener(this);
        ComponentInputMap trainInputMap = new ComponentInputMap(trainButton);
        ((InputMap)trainInputMap).put(KeyStroke.getKeyStroke(84, 0, false), "pressed");
        ((InputMap)trainInputMap).put(KeyStroke.getKeyStroke(84, 0, true), "released");
        SwingUtilities.replaceUIInputMap(trainButton, 2, trainInputMap);
        EuropePanel.enterPressesWhenFocused(trainButton);
        JButton purchaseButton = new JButton(Messages.message("purchase", new String[0]));
        purchaseButton.setActionCommand(EuropeAction.PURCHASE.toString());
        purchaseButton.addActionListener(this);
        ComponentInputMap purchaseInputMap = new ComponentInputMap(purchaseButton);
        ((InputMap)purchaseInputMap).put(KeyStroke.getKeyStroke(80, 0, false), "pressed");
        ((InputMap)purchaseInputMap).put(KeyStroke.getKeyStroke(80, 0, true), "released");
        SwingUtilities.replaceUIInputMap(purchaseButton, 2, purchaseInputMap);
        EuropePanel.enterPressesWhenFocused(purchaseButton);
        JButton recruitButton = new JButton(Messages.message("recruit", new String[0]));
        recruitButton.setActionCommand(EuropeAction.RECRUIT.toString());
        recruitButton.addActionListener(this);
        ComponentInputMap recruitInputMap = new ComponentInputMap(recruitButton);
        ((InputMap)recruitInputMap).put(KeyStroke.getKeyStroke(82, 0, false), "pressed");
        ((InputMap)recruitInputMap).put(KeyStroke.getKeyStroke(82, 0, true), "released");
        SwingUtilities.replaceUIInputMap(recruitButton, 2, recruitInputMap);
        EuropePanel.enterPressesWhenFocused(recruitButton);
        JButton unloadButton = new JButton(Messages.message("unload", new String[0]));
        unloadButton.setActionCommand(EuropeAction.UNLOAD.toString());
        unloadButton.addActionListener(this);
        ComponentInputMap unloadInputMap = new ComponentInputMap(unloadButton);
        ((InputMap)unloadInputMap).put(KeyStroke.getKeyStroke(85, 0, false), "pressed");
        ((InputMap)unloadInputMap).put(KeyStroke.getKeyStroke(85, 0, true), "released");
        SwingUtilities.replaceUIInputMap(unloadButton, 2, unloadInputMap);
        EuropePanel.enterPressesWhenFocused(unloadButton);
        JButton sailButton = new JButton(Messages.message("sail", new String[0]));
        sailButton.setActionCommand(EuropeAction.SAIL.toString());
        sailButton.addActionListener(this);
        ComponentInputMap sailInputMap = new ComponentInputMap(sailButton);
        ((InputMap)sailInputMap).put(KeyStroke.getKeyStroke(83, 0, false), "pressed");
        ((InputMap)sailInputMap).put(KeyStroke.getKeyStroke(83, 0, true), "released");
        SwingUtilities.replaceUIInputMap(sailButton, 2, sailInputMap);
        EuropePanel.enterPressesWhenFocused(sailButton);
        this.toAmericaPanel = new ToAmericaPanel(this);
        this.toEuropePanel = new ToEuropePanel(this);
        this.inPortPanel = new InPortPanel();
        this.docksPanel = new DocksPanel(this);
        this.cargoPanel = new EuropeCargoPanel(parent);
        this.cargoPanel.setParentPanel(this);
        this.marketPanel = new MarketPanel(this);
        this.log = new TransactionLog();
        SimpleAttributeSet attributes = new SimpleAttributeSet();
        StyleConstants.setAlignment(attributes, 2);
        StyleConstants.setForeground(attributes, Color.WHITE);
        StyleConstants.setBold(attributes, true);
        this.log.setParagraphAttributes(attributes, true);
        this.toAmericaPanel.setBackground(Color.WHITE);
        this.toEuropePanel.setBackground(Color.WHITE);
        this.inPortPanel.setBackground(Color.WHITE);
        this.docksPanel.setBackground(Color.WHITE);
        this.cargoPanel.setBackground(Color.WHITE);
        this.exitButton.setForeground(Color.WHITE);
        this.defaultTransferHandler = new DefaultTransferHandler(parent, this);
        this.toAmericaPanel.setTransferHandler(this.defaultTransferHandler);
        this.toEuropePanel.setTransferHandler(this.defaultTransferHandler);
        this.inPortPanel.setTransferHandler(this.defaultTransferHandler);
        this.docksPanel.setTransferHandler(this.defaultTransferHandler);
        this.cargoPanel.setTransferHandler(this.defaultTransferHandler);
        this.marketPanel.setTransferHandler(this.defaultTransferHandler);
        this.pressListener = new DragListener(this);
        DropListener releaseListener = new DropListener();
        this.toAmericaPanel.addMouseListener(releaseListener);
        this.toEuropePanel.addMouseListener(releaseListener);
        this.inPortPanel.addMouseListener(releaseListener);
        this.docksPanel.addMouseListener(releaseListener);
        this.marketPanel.addMouseListener(releaseListener);
        this.cargoPanel.addMouseListener(releaseListener);
        this.toAmericaPanel.setLayout(new GridLayout(0, 2));
        this.toEuropePanel.setLayout(new GridLayout(0, 2));
        this.inPortPanel.setLayout(new GridLayout(0, 2));
        this.docksPanel.setLayout(new GridLayout(0, 2));
        this.cargoPanel.setLayout(new GridLayout(1, 0));
        JScrollPane toAmericaScroll = new JScrollPane(this.toAmericaPanel, 20, 31);
        toAmericaScroll.getVerticalScrollBar().setUnitIncrement(16);
        JScrollPane toEuropeScroll = new JScrollPane(this.toEuropePanel, 20, 31);
        toEuropeScroll.getVerticalScrollBar().setUnitIncrement(16);
        JScrollPane inPortScroll = new JScrollPane(this.inPortPanel, 20, 31);
        inPortScroll.getVerticalScrollBar().setUnitIncrement(16);
        JScrollPane docksScroll = new JScrollPane(this.docksPanel, 20, 31);
        docksScroll.getVerticalScrollBar().setUnitIncrement(16);
        JScrollPane cargoScroll = new JScrollPane(this.cargoPanel, 21, 30);
        JScrollPane marketScroll = new JScrollPane(this.marketPanel, 21, 30);
        JScrollPane logScroll = new JScrollPane(this.log, 20, 31);
        logScroll.getVerticalScrollBar().setUnitIncrement(16);
        this.toAmericaPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), Messages.message("goingToAmerica", new String[0])));
        this.toEuropePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), Messages.message("goingToEurope", new String[0])));
        this.docksPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), Messages.message("docks", new String[0])));
        this.inPortPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), Messages.message("inPort", new String[0])));
        logScroll.setBorder(BorderFactory.createEmptyBorder());
        marketScroll.getViewport().setOpaque(false);
        this.marketPanel.setOpaque(false);
        cargoScroll.getViewport().setOpaque(false);
        this.cargoPanel.setOpaque(false);
        toAmericaScroll.getViewport().setOpaque(false);
        this.toAmericaPanel.setOpaque(false);
        toEuropeScroll.getViewport().setOpaque(false);
        this.toEuropePanel.setOpaque(false);
        docksScroll.getViewport().setOpaque(false);
        this.docksPanel.setOpaque(false);
        inPortScroll.getViewport().setOpaque(false);
        this.inPortPanel.setOpaque(false);
        logScroll.getViewport().setOpaque(false);
        this.log.setOpaque(false);
        recruitButton.setOpaque(false);
        purchaseButton.setOpaque(false);
        trainButton.setOpaque(false);
        this.exitButton.setOpaque(false);
        unloadButton.setOpaque(false);
        int[] widths = new int[]{0, 315, 3, 103, 3, 198, 3, 0, 0};
        int[] heights = new int[]{30, 39, 3, 39, 3, 39, 3, 39, 3, 116, 3, 75, 39, 3, 75, 39, 3, 120, 3};
        HIGLayout layout = new HIGLayout(widths, heights);
        layout.setRowWeight(1, 1);
        layout.setRowWeight(heights.length, 1);
        layout.setColumnWeight(1, 1);
        layout.setColumnWeight(widths.length, 1);
        this.setLayout(layout);
        int row = 2;
        this.add((Component)toAmericaScroll, higConst.rcwh(row, 2, 1, 7));
        this.add((Component)toEuropeScroll, higConst.rcwh(row, 4, 3, 7));
        this.add((Component)recruitButton, higConst.rc(row, 8));
        this.add((Component)purchaseButton, higConst.rc(row += 2, 8));
        this.add((Component)trainButton, higConst.rc(row += 2, 8));
        this.add((Component)unloadButton, higConst.rc(row += 2, 8));
        this.add((Component)inPortScroll, higConst.rcwh(row += 2, 2, 3, 1));
        this.add((Component)docksScroll, higConst.rcwh(row, 6, 1, 4));
        this.add((Component)cargoScroll, higConst.rcwh(row += 2, 2, 3, 2));
        this.add((Component)sailButton, higConst.rc(++row, 8));
        this.add((Component)marketScroll, higConst.rcwh(row += 2, 2, 5, 2));
        this.add((Component)this.exitButton, higConst.rc(++row, 8));
        this.add((Component)logScroll, higConst.rcwh(row += 2, 2, 6, 1));
        this.setBorder(null);
        this.selectedUnit = null;
        this.addMouseListener(new MouseAdapter(){});
        this.setSize(parent.getWidth(), parent.getHeight() - parent.getMenuBarHeight());
    }

    public void requestFocus() {
        this.exitButton.requestFocus();
    }

    public void refresh() {
        this.repaint(0, 0, this.getWidth(), this.getHeight());
    }

    public void paintComponent(Graphics g) {
        int width = this.getWidth();
        int height = this.getHeight();
        Image bgImage = ResourceManager.getImage("EuropeBackgroundImage", this.parent.getSize());
        if (bgImage != null) {
            g.drawImage(bgImage, 0, 0, this);
        } else {
            Image tempImage = ResourceManager.getImage("BackgroundImage");
            if (tempImage != null) {
                for (int x = 0; x < width; x += tempImage.getWidth(null)) {
                    for (int y = 0; y < height; y += tempImage.getHeight(null)) {
                        g.drawImage(tempImage, x, y, null);
                    }
                }
            } else {
                g.setColor(this.getBackground());
                g.fillRect(0, 0, width, height);
            }
        }
    }

    public void refreshDocks() {
        this.docksPanel.removeAll();
        Iterator<Unit> unitIterator = this.europe.getUnitIterator();
        while (unitIterator.hasNext()) {
            Unit unit = unitIterator.next();
            if (unit.getState() != Unit.UnitState.ACTIVE && unit.getState() != Unit.UnitState.SENTRY || unit.isNaval()) continue;
            UnitLabel unitLabel = new UnitLabel(unit, this.parent);
            unitLabel.setTransferHandler(this.defaultTransferHandler);
            unitLabel.addMouseListener(this.pressListener);
            this.docksPanel.add((Component)unitLabel, false);
        }
        this.docksPanel.repaint(0, 0, this.docksPanel.getWidth(), this.docksPanel.getHeight());
    }

    public void refreshInPort() {
        this.inPortPanel.removeAll();
        List<Unit> units = this.europe.getUnitList();
        for (Unit unit : units) {
            if (unit.getState() != Unit.UnitState.ACTIVE || !unit.isNaval()) continue;
            UnitLabel unitLabel = new UnitLabel(unit, this.parent);
            unitLabel.setTransferHandler(this.defaultTransferHandler);
            unitLabel.addMouseListener(this.pressListener);
            this.inPortPanel.add(unitLabel);
        }
        this.inPortPanel.repaint(0, 0, this.inPortPanel.getWidth(), this.inPortPanel.getHeight());
        if (!units.isEmpty()) {
            this.setSelectedUnit(units.get(units.size() - 1));
        }
    }

    public void initialize(Europe europe, Game game) {
        this.europe = europe;
        this.game = game;
        this.freeColClient.getMyPlayer().getMarket().addTransactionListener(this.log);
        this.toAmericaPanel.removeAll();
        this.toEuropePanel.removeAll();
        this.inPortPanel.removeAll();
        this.cargoPanel.removeAll();
        this.marketPanel.removeAll();
        this.docksPanel.removeAll();
        this.log.setText("");
        UnitLabel lastCarrier = null;
        block4: for (Unit unit : europe.getUnitList()) {
            UnitLabel unitLabel = new UnitLabel(unit, this.parent);
            unitLabel.setTransferHandler(this.defaultTransferHandler);
            unitLabel.addMouseListener(this.pressListener);
            if (!unit.isNaval()) {
                this.docksPanel.add((Component)unitLabel, false);
                continue;
            }
            switch (unit.getState()) {
                default: {
                    lastCarrier = unitLabel;
                    this.inPortPanel.add(unitLabel);
                    continue block4;
                }
                case TO_EUROPE: {
                    this.toEuropePanel.add((Component)unitLabel, false);
                    continue block4;
                }
                case TO_AMERICA: 
            }
            this.toAmericaPanel.add((Component)unitLabel, false);
        }
        this.setSelectedUnitLabel(lastCarrier);
        if (lastCarrier != null) {
            this.cargoPanel.setCarrier(lastCarrier.getUnit());
        }
        Player player = this.freeColClient.getMyPlayer();
        List<GoodsType> goodsTypes = FreeCol.getSpecification().getGoodsTypeList();
        for (GoodsType goodsType : goodsTypes) {
            if (!goodsType.isStorable()) continue;
            MarketLabel marketLabel = new MarketLabel(goodsType, player.getMarket(), this.parent);
            marketLabel.setTransferHandler(this.defaultTransferHandler);
            marketLabel.addMouseListener(this.pressListener);
            this.marketPanel.add(marketLabel);
        }
        String newLandName = player.getNewLandName();
        ((TitledBorder)this.toAmericaPanel.getBorder()).setTitle(Messages.message("sailingTo", "%location%", newLandName));
    }

    public void setSelectedUnit(Unit unit) {
        Component[] components = this.inPortPanel.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof UnitLabel) || ((UnitLabel)components[i]).getUnit() != unit) continue;
            this.setSelectedUnitLabel((UnitLabel)components[i]);
            break;
        }
    }

    public void setSelectedUnitLabel(UnitLabel unitLabel) {
        if (this.selectedUnit == unitLabel) {
            return;
        }
        if (this.selectedUnit != null) {
            this.selectedUnit.setSelected(false);
        }
        this.selectedUnit = unitLabel;
        if (unitLabel == null) {
            this.cargoPanel.setCarrier(null);
        } else {
            this.cargoPanel.setCarrier(unitLabel.getUnit());
            unitLabel.setSelected(true);
        }
        this.updateCargoPanel();
        this.cargoPanel.revalidate();
        this.refresh();
    }

    private void updateCargoPanel() {
        this.cargoPanel.initialize();
    }

    public Unit getSelectedUnit() {
        if (this.selectedUnit == null) {
            return null;
        }
        return this.selectedUnit.getUnit();
    }

    public UnitLabel getSelectedUnitLabel() {
        return this.selectedUnit;
    }

    private void unload() {
        Unit unit = this.getSelectedUnit();
        if (unit != null && unit.isCarrier()) {
            Player player = this.freeColClient.getMyPlayer();
            Iterator<Goods> goodsIterator = unit.getGoodsIterator();
            while (goodsIterator.hasNext()) {
                Goods goods = goodsIterator.next();
                if (player.canTrade(goods)) {
                    this.inGameController.sellGoods(goods);
                    this.updateCargoPanel();
                } else {
                    this.inGameController.payArrears(goods);
                }
                this.getCargoPanel().revalidate();
                this.refresh();
            }
            Iterator<Unit> unitIterator = unit.getUnitIterator();
            while (unitIterator.hasNext()) {
                Unit newUnit = unitIterator.next();
                this.inGameController.leaveShip(newUnit);
                this.updateCargoPanel();
                this.getCargoPanel().revalidate();
                this.refreshDocks();
                this.docksPanel.revalidate();
                this.refresh();
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        try {
            EuropeAction europeAction = Enum.valueOf(EuropeAction.class, command);
            this.parent.showEuropeDialog(europeAction);
            switch (europeAction) {
                case EXIT: {
                    this.freeColClient.getMyPlayer().getMarket().removeTransactionListener(this.log);
                    this.parent.remove(this);
                    this.freeColClient.getInGameController().nextModelMessage();
                    break;
                }
                case RECRUIT: 
                case PURCHASE: 
                case TRAIN: {
                    this.refreshDocks();
                    this.refreshInPort();
                    this.revalidate();
                    break;
                }
                case UNLOAD: {
                    this.unload();
                    break;
                }
                case SAIL: {
                    Unit unit = this.getSelectedUnit();
                    if (unit != null && unit.isNaval()) {
                        this.freeColClient.getInGameController().moveToAmerica(unit);
                        UnitLabel unitLabel = this.getSelectedUnitLabel();
                        this.inPortPanel.remove(unitLabel);
                        this.toAmericaPanel.add((Component)unitLabel, false);
                        this.refreshInPort();
                        this.revalidate();
                    }
                    break;
                }
                default: {
                    logger.warning("Invalid action command");
                    break;
                }
            }
        }
        catch (NumberFormatException e) {
            logger.warning("Invalid action number");
        }
    }

    public void payArrears(GoodsType goodsType) {
        if (this.freeColClient.getMyPlayer().getArrears(goodsType) > 0) {
            this.inGameController.payArrears(goodsType);
            this.getMarketPanel().revalidate();
            this.refresh();
        }
    }

    public void loadedGoods(Goods goods) {
        this.marketPanel.revalidate();
        this.revalidate();
        this.refresh();
    }

    public void loadedUnit(Unit unit) {
        this.refreshDocks();
    }

    public final CargoPanel getCargoPanel() {
        return this.cargoPanel;
    }

    public final MarketPanel getMarketPanel() {
        return this.marketPanel;
    }

    public class TransactionLog
    extends JTextPane
    implements TransactionListener {
        public TransactionLog() {
            this.setEditable(false);
        }

        private void add(String text) {
            StyledDocument doc = this.getStyledDocument();
            try {
                if (doc.getLength() > 0) {
                    text = "\n\n" + text;
                }
                doc.insertString(doc.getLength(), text, null);
            }
            catch (Exception e) {
                logger.warning("Failed to update transaction log: " + e.toString());
            }
        }

        public void logPurchase(GoodsType goodsType, int amount, int price) {
            int total = amount * price;
            String text = Messages.message("transaction.purchase", "%goods%", goodsType.getName(), "%amount%", String.valueOf(amount), "%gold%", String.valueOf(price)) + "\n" + Messages.message("transaction.price", "%gold%", String.valueOf(total));
            this.add(text);
        }

        public void logSale(GoodsType goodsType, int amount, int price, int tax) {
            int totalBeforeTax = amount * price;
            int totalTax = totalBeforeTax * tax / 100;
            int totalAfterTax = totalBeforeTax - totalTax;
            String text = Messages.message("transaction.sale", "%goods%", goodsType.getName(), "%amount%", String.valueOf(amount), "%gold%", String.valueOf(price)) + "\n" + Messages.message("transaction.price", "%gold%", String.valueOf(totalBeforeTax)) + "\n" + Messages.message("transaction.tax", "%tax%", String.valueOf(tax), "%gold%", String.valueOf(totalTax)) + "\n" + Messages.message("transaction.net", "%gold%", String.valueOf(totalAfterTax));
            this.add(text);
        }
    }

    public final class MarketPanel
    extends JPanel {
        private final EuropePanel europePanel;

        public MarketPanel(EuropePanel europePanel2) {
            this.europePanel = europePanel2;
            this.setLayout(new GridLayout(2, 8));
        }

        public Component add(Component comp, boolean editState) {
            if (editState) {
                if (comp instanceof GoodsLabel) {
                    Goods goods = ((GoodsLabel)comp).getGoods();
                    Player player = EuropePanel.this.freeColClient.getMyPlayer();
                    if (player.canTrade(goods)) {
                        EuropePanel.this.inGameController.sellGoods(goods);
                    } else {
                        switch (EuropePanel.this.parent.showBoycottedGoodsDialog(goods, EuropePanel.this.europe)) {
                            case PAY_ARREARS: {
                                EuropePanel.this.inGameController.payArrears(goods);
                                break;
                            }
                            case DUMP_CARGO: {
                                EuropePanel.this.inGameController.unloadCargo(goods);
                                break;
                            }
                        }
                    }
                    this.europePanel.getCargoPanel().revalidate();
                    this.revalidate();
                    EuropePanel.this.inGameController.nextModelMessage();
                    this.europePanel.refresh();
                    UnitLabel t = EuropePanel.this.selectedUnit;
                    EuropePanel.this.selectedUnit = null;
                    EuropePanel.this.setSelectedUnitLabel(t);
                    return comp;
                }
                logger.warning("An invalid component got dropped on this MarketPanel.");
                return null;
            }
            this.europePanel.refresh();
            return comp;
        }

        public void remove(Component comp) {
        }

        public String getUIClassID() {
            return "MarketPanelUI";
        }
    }

    public final class DocksPanel
    extends JPanel {
        private final EuropePanel europePanel;

        public DocksPanel(EuropePanel europePanel2) {
            this.europePanel = europePanel2;
        }

        public Component add(Component comp, boolean editState) {
            if (editState) {
                if (comp instanceof UnitLabel) {
                    comp.getParent().remove(comp);
                } else {
                    logger.warning("An invalid component got dropped on this DocksPanel.");
                    return null;
                }
            }
            Component c = this.add(comp);
            this.revalidate();
            this.europePanel.refresh();
            return c;
        }

        public int getUnitCount() {
            int number = 0;
            for (Unit u : EuropePanel.this.europe.getUnitList()) {
                if (u.isNaval()) continue;
                ++number;
            }
            return number;
        }

        public String getUIClassID() {
            return "DocksPanelUI";
        }
    }

    public final class InPortPanel
    extends JPanel {
        public Component add(Component comp) {
            return super.add(comp);
        }

        public String getUIClassID() {
            return "EuropeInPortPanelUI";
        }
    }

    public final class ToEuropePanel
    extends JPanel {
        private final EuropePanel europePanel;

        public ToEuropePanel(EuropePanel europePanel2) {
            this.europePanel = europePanel2;
        }

        public Component add(Component comp, boolean editState) {
            if (editState) {
                if (comp instanceof UnitLabel) {
                    comp.getParent().remove(comp);
                    Unit unit = ((UnitLabel)comp).getUnit();
                    EuropePanel.this.inGameController.moveToEurope(unit);
                } else {
                    logger.warning("An invalid component got dropped on this ToEuropePanel.");
                    return null;
                }
            }
            EuropePanel.this.setSelectedUnitLabel(null);
            Component c = this.add(comp);
            this.europePanel.refresh();
            return c;
        }

        public String getUIClassID() {
            return "ToEuropePanelUI";
        }
    }

    public final class ToAmericaPanel
    extends JPanel {
        private final EuropePanel europePanel;

        public ToAmericaPanel(EuropePanel europePanel2) {
            this.europePanel = europePanel2;
        }

        public Component add(Component comp, boolean editState) {
            if (editState) {
                if (comp instanceof UnitLabel) {
                    boolean leaveColonists;
                    Unit unit = ((UnitLabel)comp).getUnit();
                    ClientOptions co = EuropePanel.this.freeColClient.getClientOptions();
                    boolean autoload = co.getBoolean("model.option.autoloadEmigrants");
                    if (!autoload && EuropePanel.this.docksPanel.getUnitCount() > 0 && unit.getSpaceLeft() > 0 && !(leaveColonists = EuropePanel.this.parent.showConfirmDialog("europe.leaveColonists", "yes", "no", "%newWorld%", unit.getOwner().getNewLandName()))) {
                        return null;
                    }
                    comp.getParent().remove(comp);
                    EuropePanel.this.inGameController.moveToAmerica(unit);
                    EuropePanel.this.docksPanel.removeAll();
                    for (Unit u : EuropePanel.this.europe.getUnitList()) {
                        UnitLabel unitLabel = new UnitLabel(u, EuropePanel.this.parent);
                        unitLabel.setTransferHandler(EuropePanel.this.defaultTransferHandler);
                        unitLabel.addMouseListener(EuropePanel.this.pressListener);
                        if (u.isNaval()) continue;
                        EuropePanel.this.docksPanel.add((Component)unitLabel, false);
                    }
                    EuropePanel.this.docksPanel.revalidate();
                } else {
                    logger.warning("An invalid component got dropped on this ToAmericaPanel.");
                    return null;
                }
            }
            EuropePanel.this.setSelectedUnitLabel(null);
            Component c = this.add(comp);
            EuropePanel.this.toAmericaPanel.revalidate();
            this.europePanel.refresh();
            return c;
        }

        public String getUIClassID() {
            return "ToAmericaPanelUI";
        }
    }

    public final class EuropeCargoPanel
    extends CargoPanel {
        public EuropeCargoPanel(Canvas parent) {
            super(parent, true);
        }

        public Component add(Component comp, boolean editState) {
            Component result = super.add(comp, editState);
            EuropePanel.this.updateCargoPanel();
            EuropePanel.this.getCargoPanel().revalidate();
            EuropePanel.this.refresh();
            return result;
        }

        public String getUIClassID() {
            return "EuropeCargoPanelUI";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EuropeAction {
        EXIT,
        RECRUIT,
        PURCHASE,
        TRAIN,
        UNLOAD,
        SAIL;

    }
}

