/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import cz.autel.dmi.HIGLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.common.resources.ResourceManager;

public final class EventPanel
extends FreeColDialog
implements ActionListener {
    private static final Logger logger = Logger.getLogger(EventPanel.class.getName());
    public static final int FIRST_LANDING = 0;
    public static final int MEETING_NATIVES = 1;
    public static final int MEETING_EUROPEANS = 2;
    public static final int MEETING_AZTEC = 3;
    public static final int MEETING_INCA = 4;
    public static final int DISCOVER_PACIFIC = 5;
    private static final int OK = 0;
    private final FreeColClient freeColClient;
    private final Canvas parent;
    private JLabel header;
    private JLabel imageLabel;
    private JButton okButton;

    public EventPanel(Canvas parent, FreeColClient freeColClient) {
        this.parent = parent;
        this.freeColClient = freeColClient;
        int[] w = new int[]{0};
        int[] h = new int[]{0, 10, 0, 10, 0};
        this.setLayout(new HIGLayout(w, h));
        this.header = new JLabel("", 0);
        this.header.setFont(mediumHeaderFont);
        this.imageLabel = new JLabel();
        this.okButton = new JButton(Messages.message("ok", new String[0]));
        this.okButton.setActionCommand(String.valueOf(0));
        this.okButton.addActionListener(this);
        EventPanel.enterPressesWhenFocused(this.okButton);
        this.add((Component)this.header, higConst.rc(1, 1));
        this.add((Component)this.imageLabel, higConst.rc(3, 1, ""));
        this.add((Component)this.okButton, higConst.rc(5, 1));
    }

    public void requestFocus() {
        this.okButton.requestFocus();
    }

    public void initialize(int eventID) {
        if (eventID == 0) {
            Image image = ResourceManager.getImage("EventImage.firstLanding");
            this.imageLabel.setIcon(new ImageIcon(image));
            this.header.setText(Messages.message("event.firstLanding", "%name%", this.freeColClient.getMyPlayer().getNewLandName()));
        } else if (eventID == 1) {
            Image image = ResourceManager.getImage("EventImage.meetingNatives");
            this.imageLabel.setIcon(new ImageIcon(image));
            this.header.setText(Messages.message("event.meetingNatives", new String[0]));
        } else if (eventID == 2) {
            Image image = ResourceManager.getImage("EventImage.meetingEuropeans");
            this.imageLabel.setIcon(new ImageIcon(image));
            this.header.setText(Messages.message("event.meetingEuropeans", new String[0]));
        } else if (eventID == 3) {
            Image image = ResourceManager.getImage("EventImage.meetingAztec");
            this.imageLabel.setIcon(new ImageIcon(image));
            this.header.setText(Messages.message("event.meetingAztec", new String[0]));
        } else if (eventID == 4) {
            Image image = ResourceManager.getImage("EventImage.meetingInca");
            this.imageLabel.setIcon(new ImageIcon(image));
            this.header.setText(Messages.message("event.meetingInca", new String[0]));
        } else if (eventID == 5) {
            Image image = ResourceManager.getImage("EventImage.discoverPacific");
            this.imageLabel.setIcon(new ImageIcon(image));
            this.header.setText(Messages.message("model.region.pacific.discover", new String[0]));
        } else {
            this.setResponse(new Boolean(false));
        }
        this.setSize(this.getPreferredSize());
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        try {
            switch (Integer.valueOf(command)) {
                case 0: {
                    this.setResponse(new Boolean(true));
                    break;
                }
                default: {
                    logger.warning("Invalid Actioncommand: invalid number.");
                    break;
                }
            }
        }
        catch (NumberFormatException e) {
            logger.warning("Invalid Actioncommand: not a number.");
        }
    }
}

