/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import cz.autel.dmi.HIGLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.freecol.client.ClientOptions;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Player;

public final class FindColonyDialog
extends FreeColDialog
implements ListSelectionListener {
    private static final Logger logger = Logger.getLogger(FindColonyDialog.class.getName());
    private JButton okButton = new JButton(Messages.message("ok", new String[0]));
    private List<Colony> knownColonies = new ArrayList<Colony>();
    private JList colonyList;

    public FindColonyDialog(Canvas parent) {
        super(parent);
        for (Player player : this.getCanvas().getClient().getGame().getEuropeanPlayers()) {
            this.knownColonies.addAll(player.getColonies());
        }
        int comparator = 0;
        Collections.sort(this.knownColonies, ClientOptions.getColonyComparator(comparator));
        HIGLayout layout = new HIGLayout(new int[]{0}, new int[]{0, 20, 0, 10, 0});
        layout.setColumnWeight(1, 1);
        layout.setRowWeight(3, 1);
        this.setLayout(layout);
        JLabel header = new JLabel(Messages.message("menuBar.view.findColony", new String[0]));
        header.setFont(smallHeaderFont);
        this.add((Component)header, higConst.rc(1, 1, ""));
        this.colonyList = new JList<Colony>(this.knownColonies.toArray(new Colony[this.knownColonies.size()]));
        JScrollPane listScroller = new JScrollPane(this.colonyList);
        listScroller.setPreferredSize(new Dimension(250, 250));
        this.colonyList.addListSelectionListener(this);
        this.add((Component)listScroller, higConst.rc(3, 1));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                FindColonyDialog.this.remove();
            }
        });
        this.add((Component)this.okButton, higConst.rc(5, 1));
        this.setSize(this.getPreferredSize());
    }

    public void requestFocus() {
        this.okButton.requestFocus();
    }

    public void remove() {
        this.getCanvas().remove(this);
    }

    public void valueChanged(ListSelectionEvent e) {
        Colony colony = (Colony)this.colonyList.getSelectedValue();
        this.getCanvas().getGUI().setFocus(colony.getTile().getPosition());
    }
}

