/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import cz.autel.dmi.HIGLayout;
import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.MenuComponent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.ChoiceItem;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.common.model.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreeColDialog
extends FreeColPanel {
    private static final Logger logger = Logger.getLogger(FreeColDialog.class.getName());
    private Object response = null;
    private boolean responseGiven = false;

    public FreeColDialog() {
    }

    public FreeColDialog(Canvas parent) {
        super(parent);
    }

    public synchronized void setResponse(Object response) {
        this.response = response;
        this.responseGiven = true;
        logger.info("Response has been set to " + response);
        this.notifyAll();
    }

    public synchronized Object getResponse() {
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                EventQueue theQueue = this.getToolkit().getSystemEventQueue();
                while (!this.responseGiven) {
                    AWTEvent event = theQueue.getNextEvent();
                    Object src = event.getSource();
                    if (event instanceof ActiveEvent) {
                        ((ActiveEvent)((Object)event)).dispatch();
                        continue;
                    }
                    if (src instanceof Component) {
                        ((Component)src).dispatchEvent(event);
                        continue;
                    }
                    if (src instanceof MenuComponent) {
                        ((MenuComponent)src).dispatchEvent(event);
                        continue;
                    }
                    logger.warning("unable to dispatch event: " + event);
                }
            } else {
                while (!this.responseGiven) {
                    this.wait();
                }
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Object tempResponse = this.response;
        this.response = null;
        this.responseGiven = false;
        return tempResponse;
    }

    public boolean getResponseBoolean() {
        return (Boolean)this.getResponse();
    }

    public int getResponseInt() {
        return (Integer)this.getResponse();
    }

    public void resetResponse() {
        this.response = null;
        this.responseGiven = false;
    }

    public static FreeColDialog createChoiceDialog(String text, String cancelText, ChoiceItem ... objects) {
        if (objects.length == 0) {
            throw new IllegalArgumentException("Can not create choice dialog with 0 choices!");
        }
        final JButton firstButton = new JButton(objects[0].toString());
        final FreeColDialog choiceDialog = new FreeColDialog(){

            public void requestFocus() {
                firstButton.requestFocus();
            }
        };
        FreeColDialog.enterPressesWhenFocused(firstButton);
        choiceDialog.setLayout(new BorderLayout(10, 10));
        JTextArea textArea = FreeColDialog.getDefaultTextArea(text);
        choiceDialog.add((Component)textArea, "North");
        JPanel objectsPanel = new JPanel(new GridLayout(objects.length, 1, 10, 10));
        objectsPanel.setBorder(new CompoundBorder(objectsPanel.getBorder(), new EmptyBorder(10, 20, 10, 20)));
        final ChoiceItem firstObject = objects[0];
        firstButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                choiceDialog.setResponse(firstObject);
            }
        });
        objectsPanel.add(firstButton);
        for (int i = 1; i < objects.length; ++i) {
            final ChoiceItem object = objects[i];
            JButton objectButton = new JButton(((Object)object).toString());
            objectButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    choiceDialog.setResponse(object);
                }
            });
            FreeColDialog.enterPressesWhenFocused(objectButton);
            objectsPanel.add(objectButton);
        }
        if (cancelText != null) {
            JButton cancelButton = new JButton();
            cancelButton.setText(cancelText);
            FreeColDialog.enterPressesWhenFocused(cancelButton);
            cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    choiceDialog.setResponse(null);
                }
            });
            choiceDialog.add((Component)cancelButton, "South");
            choiceDialog.setCancelComponent(cancelButton);
        }
        JScrollPane scrollPane = new JScrollPane(objectsPanel, 20, 31);
        choiceDialog.add((Component)scrollPane, "Center");
        choiceDialog.setSize(choiceDialog.getPreferredSize());
        return choiceDialog;
    }

    public static FreeColDialog createConfirmDialog(String text, String okText, String cancelText) {
        return FreeColDialog.createConfirmDialog(new String[]{text}, null, okText, cancelText);
    }

    public static FreeColDialog createConfirmDialog(String[] texts, ImageIcon[] images, String okText, String cancelText) {
        char ch;
        int ci;
        final JButton okButton = new JButton();
        final FreeColDialog confirmDialog = new FreeColDialog(){

            public void requestFocus() {
                okButton.requestFocus();
            }
        };
        confirmDialog.setLayout(new HIGLayout(new int[]{0}, new int[]{0, 3, 0}));
        int margin = 10;
        int[] widths = new int[]{0, margin, 0};
        int[] heights = new int[2 * texts.length - 1];
        int imageColumn = 1;
        int textColumn = 3;
        for (int index = 1; index < heights.length; index += 2) {
            heights[index] = margin;
        }
        if (images == null) {
            widths = new int[]{0};
            textColumn = 1;
        }
        HIGLayout layout = new HIGLayout(widths, heights);
        layout.setColumnWeight(textColumn, 1);
        JPanel mainPanel = new JPanel(layout);
        int row = 1;
        for (int i = 0; i < texts.length; ++i) {
            if (images != null && images[i] != null) {
                JLabel image = new JLabel(images[i]);
                mainPanel.add((Component)image, higConst.rc(row, imageColumn));
            }
            mainPanel.add((Component)FreeColDialog.getDefaultTextArea(texts[i]), higConst.rc(row, textColumn));
            row += 2;
        }
        char okButtonMnemonic = '\u0000';
        char cancelButtonMnemonic = '\u0000';
        String okUpper = okText.toUpperCase();
        String cancelUpper = cancelText.toUpperCase();
        String menuMnemonics = "GVORCD";
        int nc = okUpper.length();
        for (ci = 0; ci < nc; ++ci) {
            ch = okUpper.charAt(ci);
            if (-1 != menuMnemonics.indexOf(ch)) continue;
            okButtonMnemonic = ch;
            break;
        }
        nc = cancelUpper.length();
        for (ci = 0; ci < nc; ++ci) {
            ch = cancelUpper.charAt(ci);
            if (-1 != menuMnemonics.indexOf(ch) || ch == okButtonMnemonic) continue;
            cancelButtonMnemonic = ch;
            break;
        }
        AbstractAction okAction = new AbstractAction(okText){

            public void actionPerformed(ActionEvent event) {
                confirmDialog.setResponse(Boolean.TRUE);
            }
        };
        okAction.putValue("AcceleratorKey", new Integer(10));
        okAction.putValue("MnemonicKey", new Integer(okButtonMnemonic));
        okButton.setAction(okAction);
        AbstractAction cancelAction = new AbstractAction(cancelText){

            public void actionPerformed(ActionEvent event) {
                confirmDialog.setResponse(Boolean.FALSE);
            }
        };
        cancelAction.putValue("AcceleratorKey", new Integer(27));
        cancelAction.putValue("MnemonicKey", new Integer(cancelButtonMnemonic));
        JButton cancelButton = new JButton(cancelAction);
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        buttonPanel.setOpaque(false);
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        FreeColDialog.enterPressesWhenFocused(okButton);
        FreeColDialog.enterPressesWhenFocused(cancelButton);
        confirmDialog.add((Component)mainPanel, higConst.rc(1, 1));
        confirmDialog.add((Component)buttonPanel, higConst.rc(3, 1));
        confirmDialog.setSize(confirmDialog.getPreferredSize());
        confirmDialog.setCancelComponent(cancelButton);
        return confirmDialog;
    }

    public static FreeColDialog createInciteDialog(List<Player> allPlayers, Player thisUser) {
        String mainText = Messages.message("missionarySettlement.inciteQuestion", new String[0]);
        JTextArea question = FreeColDialog.getDefaultTextArea(mainText);
        ArrayList<Player> players = new ArrayList<Player>();
        final JButton cancel = new JButton(Messages.message("missionarySettlement.cancel", new String[0]));
        for (Player p : allPlayers) {
            if (p.equals(thisUser) || p.isREF()) continue;
            players.add(p);
        }
        final FreeColDialog inciteDialog = new FreeColDialog(){

            public void requestFocus() {
                cancel.requestFocus();
            }
        };
        int[] widths = new int[]{0};
        int[] heights = new int[2 * players.size() + 3];
        for (int index = 0; index <= players.size(); ++index) {
            heights[2 * index + 1] = 3;
        }
        inciteDialog.setLayout(new HIGLayout(widths, heights));
        int textColumn = 1;
        int row = 1;
        inciteDialog.add((Component)question, higConst.rc(row, textColumn));
        row += 2;
        for (final Player p : players) {
            JButton button = new JButton(p.getNationAsString());
            button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    inciteDialog.setResponse(p);
                }
            });
            inciteDialog.add((Component)button, higConst.rc(row, textColumn));
            row += 2;
        }
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                inciteDialog.setResponse(null);
            }
        });
        inciteDialog.add((Component)cancel, higConst.rc(row, textColumn));
        inciteDialog.setSize(inciteDialog.getPreferredSize());
        return inciteDialog;
    }

    public static FreeColDialog createInputDialog(String text, String defaultValue, String okText, String cancelText) {
        final JTextField input = new JTextField(defaultValue);
        final FreeColDialog inputDialog = new FreeColDialog(){

            public void requestFocus() {
                input.requestFocus();
            }
        };
        int[] widths = new int[]{0};
        int[] heights = new int[]{0, 3, 0, 3, 0};
        inputDialog.setLayout(new HIGLayout(widths, heights));
        JPanel buttons = new JPanel();
        buttons.setOpaque(false);
        JButton okButton = new JButton(okText);
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                inputDialog.setResponse(input.getText());
            }
        });
        buttons.add(okButton);
        inputDialog.setCancelComponent(okButton);
        if (cancelText != null) {
            JButton cancelButton = new JButton(cancelText);
            cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    inputDialog.setResponse(null);
                }
            });
            buttons.add(cancelButton);
            inputDialog.setCancelComponent(cancelButton);
        }
        input.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                inputDialog.setResponse(input.getText());
            }
        });
        input.selectAll();
        int row = 1;
        int textColumn = 1;
        inputDialog.add((Component)FreeColDialog.getDefaultTextArea(text), higConst.rc(row, textColumn));
        inputDialog.add((Component)input, higConst.rc(row += 2, textColumn));
        inputDialog.add((Component)buttons, higConst.rc(row += 2, textColumn));
        inputDialog.setSize(inputDialog.getPreferredSize());
        return inputDialog;
    }

    public static FreeColDialog createLoadDialog(File directory, FileFilter[] fileFilters) {
        final FreeColDialog loadDialog = new FreeColDialog();
        final JFileChooser fileChooser = new JFileChooser(directory);
        fileChooser.setDialogType(0);
        if (fileFilters.length > 0) {
            for (int i = 0; i < fileFilters.length; ++i) {
                fileChooser.addChoosableFileFilter(fileFilters[i]);
            }
            fileChooser.setFileFilter(fileFilters[0]);
            fileChooser.setAcceptAllFileFilterUsed(false);
        }
        fileChooser.setFileSelectionMode(0);
        fileChooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                String actionCommand = event.getActionCommand();
                if (actionCommand.equals("ApproveSelection")) {
                    loadDialog.setResponse(fileChooser.getSelectedFile());
                } else if (actionCommand.equals("CancelSelection")) {
                    loadDialog.setResponse(null);
                }
            }
        });
        fileChooser.setFileHidingEnabled(false);
        loadDialog.setLayout(new BorderLayout());
        loadDialog.add(fileChooser);
        loadDialog.setSize(480, 320);
        return loadDialog;
    }

    public static FreeColDialog createSaveDialog(File directory, final String standardName, FileFilter[] fileFilters, String defaultName) {
        final FreeColDialog saveDialog = new FreeColDialog();
        final JFileChooser fileChooser = new JFileChooser(directory);
        File defaultFile = new File(defaultName);
        fileChooser.setDialogType(1);
        if (fileFilters.length > 0) {
            for (int i = 0; i < fileFilters.length; ++i) {
                fileChooser.addChoosableFileFilter(fileFilters[i]);
            }
            fileChooser.setFileFilter(fileFilters[0]);
            fileChooser.setAcceptAllFileFilterUsed(false);
        }
        fileChooser.setFileSelectionMode(0);
        fileChooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                String actionCommand = event.getActionCommand();
                if (actionCommand.equals("ApproveSelection")) {
                    File file = fileChooser.getSelectedFile();
                    if (standardName != null && !file.getName().endsWith(standardName)) {
                        file = new File(file.getAbsolutePath() + standardName);
                    }
                    saveDialog.setResponse(file);
                } else if (actionCommand.equals("CancelSelection")) {
                    saveDialog.setResponse(null);
                }
            }
        });
        fileChooser.setFileHidingEnabled(false);
        fileChooser.setSelectedFile(defaultFile);
        saveDialog.setLayout(new BorderLayout());
        saveDialog.add(fileChooser);
        saveDialog.setSize(480, 320);
        return saveDialog;
    }

    public static FileFilter getFSGFileFilter() {
        return new FreeColFileFilter(".fsg", "filter.savedGames");
    }

    public static FileFilter getFGOFileFilter() {
        return new FreeColFileFilter(".fgo", "filter.gameOptions");
    }

    public static FileFilter getGameOptionsFileFilter() {
        return new FreeColFileFilter(".fgo", ".fsg", "filter.gameOptionsAndSavedGames");
    }

    public void initialize() {
    }

    static final class FreeColFileFilter
    extends FileFilter {
        private final String extension1;
        private final String extension2;
        private final String description;

        FreeColFileFilter(String extension1, String extension2, String descriptionMessage) {
            this.extension1 = extension1;
            this.extension2 = extension2;
            this.description = Messages.message(descriptionMessage, new String[0]);
        }

        FreeColFileFilter(String extension, String descriptionMessage) {
            this.extension1 = extension;
            this.extension2 = "....";
            this.description = Messages.message(descriptionMessage, new String[0]);
        }

        public boolean accept(File f) {
            return f.isDirectory() || f.getName().endsWith(this.extension1) || f.getName().endsWith(this.extension2);
        }

        public String getDescription() {
            return this.description;
        }
    }
}

