/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import cz.autel.dmi.HIGConstraints;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.panel.FreeColImageBorder;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.resources.ResourceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreeColPanel
extends JPanel {
    private static final Logger logger = Logger.getLogger(FreeColPanel.class.getName());
    public static final Insets emptyMargin = new Insets(0, 0, 0, 0);
    protected static final HIGConstraints higConst = new HIGConstraints();
    private static final int cancelKeyCode = 27;
    private static final DecimalFormat modifierFormat = new DecimalFormat("0.00");
    private Canvas canvas = null;
    protected static final Font defaultFont = new Font("Dialog", 1, 12);
    protected static final Font headerFont = ((Font)UIManager.get("HeaderFont")).deriveFont(0, 12.0f);
    protected static final Font smallHeaderFont = ((Font)UIManager.get("HeaderFont")).deriveFont(0, 24.0f);
    protected static final Font mediumHeaderFont = ((Font)UIManager.get("HeaderFont")).deriveFont(0, 36.0f);
    protected static final Font bigHeaderFont = ((Font)UIManager.get("HeaderFont")).deriveFont(0, 48.0f);
    protected static final int columns = 20;
    protected static final int margin = 3;
    protected static final Color LINK_COLOR = new Color(122, 109, 82);
    public static final Border TOPCELLBORDER = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 1, 1, LINK_COLOR), BorderFactory.createEmptyBorder(2, 2, 2, 2));
    public static final Border CELLBORDER = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, LINK_COLOR), BorderFactory.createEmptyBorder(2, 2, 2, 2));
    public static final Border LEFTCELLBORDER = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 1, 1, 1, LINK_COLOR), BorderFactory.createEmptyBorder(2, 2, 2, 2));
    public static final Border TOPLEFTCELLBORDER = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, LINK_COLOR), BorderFactory.createEmptyBorder(2, 2, 2, 2));
    protected boolean editable = true;

    public FreeColPanel() {
        this(null, new FlowLayout());
    }

    public FreeColPanel(Canvas parent) {
        this(parent, new FlowLayout());
    }

    public FreeColPanel(LayoutManager layout) {
        this(null, layout);
    }

    public FreeColPanel(Canvas parent, LayoutManager layout) {
        super(layout);
        this.canvas = parent;
        this.setFocusCycleRoot(true);
        Image menuborderN = ResourceManager.getImage("menuborder.n.image");
        Image menuborderNW = ResourceManager.getImage("menuborder.nw.image");
        Image menuborderNE = ResourceManager.getImage("menuborder.ne.image");
        Image menuborderW = ResourceManager.getImage("menuborder.w.image");
        Image menuborderE = ResourceManager.getImage("menuborder.e.image");
        Image menuborderS = ResourceManager.getImage("menuborder.s.image");
        Image menuborderSW = ResourceManager.getImage("menuborder.sw.image");
        Image menuborderSE = ResourceManager.getImage("menuborder.se.image");
        FreeColImageBorder imageBorder = new FreeColImageBorder(menuborderN, menuborderW, menuborderS, menuborderE, menuborderNW, menuborderNE, menuborderSW, menuborderSE);
        this.setBorder(BorderFactory.createCompoundBorder(imageBorder, BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        this.addMouseListener(new MouseAdapter(){});
    }

    public final Canvas getCanvas() {
        return this.canvas;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public static JTextPane getDefaultTextPane() {
        JTextPane textPane = new JTextPane();
        textPane.setOpaque(false);
        textPane.setEditable(false);
        StyledDocument doc = textPane.getStyledDocument();
        Style def = StyleContext.getDefaultStyleContext().getStyle("default");
        Style regular = doc.addStyle("regular", def);
        StyleConstants.setFontFamily(def, "Dialog");
        StyleConstants.setBold(def, true);
        StyleConstants.setFontSize(def, 12);
        Style buttonStyle = doc.addStyle("button", regular);
        StyleConstants.setForeground(buttonStyle, LINK_COLOR);
        Style right = doc.addStyle("right", regular);
        StyleConstants.setAlignment(right, 2);
        return textPane;
    }

    public static JTextArea getDefaultTextArea(String text) {
        JTextArea textArea = new JTextArea(text);
        textArea.setColumns(20);
        textArea.setOpaque(false);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setFocusable(false);
        textArea.setFont(defaultFont);
        textArea.setSize(textArea.getPreferredSize());
        return textArea;
    }

    public static JButton getLinkButton(String text, Icon icon, String action) {
        JButton button = new JButton(text, icon);
        button.setMargin(emptyMargin);
        button.setOpaque(false);
        button.setForeground(LINK_COLOR);
        button.setAlignmentY(0.8f);
        button.setBorder(BorderFactory.createEmptyBorder());
        button.setActionCommand(action);
        return button;
    }

    public static JLabel getDefaultHeader(String text) {
        JLabel header = new JLabel(text, 0);
        header.setFont(bigHeaderFont);
        header.setBorder(BorderFactory.createEmptyBorder(20, 0, 20, 0));
        return header;
    }

    public void setCancelComponent(AbstractButton cancelButton) {
        if (cancelButton == null) {
            throw new NullPointerException();
        }
        InputMap inputMap = this.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(27, 0, true), "release");
        Action cancelAction = cancelButton.getAction();
        this.getActionMap().put("release", cancelAction);
    }

    public static void enterPressesWhenFocused(JButton button) {
        button.registerKeyboardAction(button.getActionForKeyStroke(KeyStroke.getKeyStroke(32, 0, false)), KeyStroke.getKeyStroke(10, 0, false), 0);
        button.registerKeyboardAction(button.getActionForKeyStroke(KeyStroke.getKeyStroke(32, 0, true)), KeyStroke.getKeyStroke(10, 0, true), 0);
    }

    public static final DecimalFormat getModifierFormat() {
        return modifierFormat;
    }

    public Set<Modifier> sortModifiers(Set<Modifier> result) {
        EnumMap modifierMap = new EnumMap(Modifier.Type.class);
        for (Modifier.Type type : Modifier.Type.values()) {
            modifierMap.put(type, new ArrayList());
        }
        for (Modifier modifier : result) {
            ((List)modifierMap.get((Object)modifier.getType())).add(modifier);
        }
        LinkedHashSet<Modifier> sortedResult = new LinkedHashSet<Modifier>();
        for (Modifier.Type type : Modifier.Type.values()) {
            sortedResult.addAll((Collection)modifierMap.get((Object)type));
        }
        return sortedResult;
    }

    public static MouseListener createEventForwardingMouseListener(final Component c) {
        MouseListener ml = new MouseListener(){

            private void forward(MouseEvent e) {
                c.dispatchEvent(SwingUtilities.convertMouseEvent(e.getComponent(), e, c));
            }

            public void mouseClicked(MouseEvent e) {
                this.forward(e);
            }

            public void mouseEntered(MouseEvent e) {
                this.forward(e);
            }

            public void mouseExited(MouseEvent e) {
                this.forward(e);
            }

            public void mousePressed(MouseEvent e) {
                this.forward(e);
            }

            public void mouseReleased(MouseEvent e) {
                this.forward(e);
            }
        };
        return ml;
    }

    public static MouseMotionListener createEventForwardingMouseMotionListener(final Component c) {
        MouseMotionListener ml = new MouseMotionListener(){

            private void forward(MouseEvent e) {
                c.dispatchEvent(SwingUtilities.convertMouseEvent(e.getComponent(), e, c));
            }

            public void mouseDragged(MouseEvent e) {
                this.forward(e);
            }

            public void mouseMoved(MouseEvent e) {
                this.forward(e);
            }
        };
        return ml;
    }
}

