/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.resources.ResourceManager;

public class FreeColProgressBar
extends JPanel {
    private static final Color PRIMARY_1 = new Color(122, 109, 82);
    private static final Color BG_COLOR_SELECT = new Color(255, 244, 195);
    private static final Color PRIMARY_3 = new Color(203, 182, 136);
    private int min = 0;
    private int max = 100;
    private int value = 0;
    private int step = 0;
    private int iconWidth;
    private int iconHeight = 16;
    private GoodsType goodsType = null;
    private final Canvas parent;
    private Image image;

    public FreeColProgressBar(Canvas parent, GoodsType goodsType) {
        this(parent, goodsType, 0, 100, 0, 0);
    }

    public FreeColProgressBar(Canvas parent, GoodsType goodsType, int min, int max) {
        this(parent, goodsType, min, max, 0, 0);
    }

    public FreeColProgressBar(Canvas parent, GoodsType goodsType, int min, int max, int value, int step) {
        this.parent = parent;
        this.goodsType = goodsType;
        this.min = min;
        this.max = max;
        this.value = value;
        this.step = step;
        this.setBorder(BorderFactory.createLineBorder(PRIMARY_1));
        ImageIcon icon = parent.getGUI().getImageLibrary().getGoodsImageIcon(goodsType);
        this.image = icon.getImage().getScaledInstance(-1, this.iconHeight, 4);
        this.iconWidth = this.image.getWidth(this);
        this.setPreferredSize(new Dimension(200, 20));
    }

    public void update(int value, int step) {
        this.update(this.min, this.max, value, step);
    }

    public void update(int min, int max, int value, int step) {
        this.min = min;
        this.max = max;
        this.value = value;
        this.step = step;
        this.repaint();
    }

    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g.create();
        int width = this.getWidth() - this.getInsets().left - this.getInsets().right;
        int height = this.getHeight() - this.getInsets().top - this.getInsets().bottom;
        if (this.iconWidth < 0) {
            this.iconWidth = this.image.getWidth(this);
        }
        if (this.isOpaque()) {
            Image tempImage = ResourceManager.getImage("BackgroundImage");
            if (tempImage != null) {
                for (int x = this.getInsets().left; x < width + this.getInsets().left; x += tempImage.getWidth(null)) {
                    for (int y = this.getInsets().top; y < height + this.getInsets().top; y += tempImage.getHeight(null)) {
                        g2d.drawImage(tempImage, x, y, null);
                    }
                }
            } else {
                g2d.setColor(this.getBackground());
                g2d.fillRect(this.getInsets().left, this.getInsets().top, width, height);
            }
        }
        int dvalue = 0;
        if (this.value >= this.max) {
            dvalue = width;
        } else if (this.max > 0) {
            dvalue = width * this.value / this.max;
        }
        if (dvalue > 0) {
            if (dvalue > width) {
                dvalue = width;
            }
            g2d.setColor(new Color(0, 0, 0, 70));
            g2d.fillRect(this.getInsets().left, this.getInsets().top, dvalue, height);
        }
        int dstep = 0;
        if (this.max > 0 && (dstep = width * this.step / this.max) > 0) {
            if (dstep + dvalue > width) {
                dstep = width - dvalue;
            }
            g2d.setColor(new Color(0, 0, 0, 40));
            g2d.fillRect(this.getInsets().left + dvalue, this.getInsets().top, dstep, height);
        }
        String stepSignal = this.step < 0 ? "-" : "+";
        String progressString = String.valueOf(this.value) + stepSignal + Math.abs(this.step) + "/" + this.max;
        String turnsString = "";
        if (this.max > this.value) {
            if (this.step > 0) {
                int turns = (this.max - this.value) / this.step;
                if ((this.max - this.value) % this.step > 0) {
                    ++turns;
                }
                turnsString = " (" + turns + " " + Messages.message("turns", new String[0]) + ")";
            } else {
                turnsString = " (" + Messages.message("turns", new String[0]) + ": N/A)";
            }
        }
        progressString = progressString + turnsString;
        int stringWidth = g2d.getFontMetrics().stringWidth(progressString);
        int stringHeight = g2d.getFontMetrics().getAscent() + g2d.getFontMetrics().getDescent();
        int restWidth = this.getWidth() - stringWidth;
        if (this.goodsType != null) {
            g2d.drawImage(this.image, (restWidth -= this.iconWidth) / 2, (this.getHeight() - this.iconHeight) / 2, null);
        }
        g2d.setColor(Color.BLACK);
        g2d.drawString(progressString, restWidth / 2 + this.iconWidth, this.getHeight() / 2 + stringHeight / 4);
        g2d.dispose();
    }
}

