/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.option.BooleanOptionUI;
import net.sf.freecol.client.gui.option.OptionMapUI;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.client.gui.panel.FreeColPanel;

public final class GameOptionsDialog
extends FreeColDialog
implements ActionListener {
    private static final Logger logger = Logger.getLogger(GameOptionsDialog.class.getName());
    private static final int OK = 0;
    private static final int CANCEL = 1;
    private static final int SAVE = 2;
    private static final int LOAD = 3;
    private static final int RESET = 4;
    private final Canvas parent;
    private final FreeColClient freeColClient;
    private JButton ok;
    private JButton load;
    private JButton save;
    private JButton cancel;
    private JPanel buttons = new JPanel(new FlowLayout());
    private JLabel header;
    private OptionMapUI ui;

    public GameOptionsDialog(Canvas parent, FreeColClient freeColClient) {
        this.setLayout(new BorderLayout());
        this.parent = parent;
        this.freeColClient = freeColClient;
        this.ok = new JButton(Messages.message("ok", new String[0]));
        this.ok.setActionCommand(String.valueOf(0));
        this.ok.addActionListener(this);
        this.ok.setMnemonic('O');
        this.buttons.add(this.ok);
        this.load = new JButton(Messages.message("load", new String[0]));
        this.load.setActionCommand(String.valueOf(3));
        this.load.addActionListener(this);
        this.load.setMnemonic('L');
        this.buttons.add(this.load);
        this.save = new JButton(Messages.message("save", new String[0]));
        this.save.setActionCommand(String.valueOf(2));
        this.save.addActionListener(this);
        this.save.setMnemonic('S');
        this.buttons.add(this.save);
        JButton reset = new JButton(Messages.message("reset", new String[0]));
        reset.setActionCommand(String.valueOf(4));
        reset.addActionListener(this);
        reset.setMnemonic('R');
        this.buttons.add(reset);
        this.cancel = new JButton(Messages.message("cancel", new String[0]));
        this.cancel.setActionCommand(String.valueOf(1));
        this.cancel.addActionListener(this);
        this.cancel.setMnemonic('C');
        this.buttons.add(this.cancel);
        FreeColPanel.enterPressesWhenFocused(this.ok);
        this.setCancelComponent(this.cancel);
        this.setSize(640, 480);
    }

    public Dimension getMinimumSize() {
        return new Dimension(640, 480);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void initialize(boolean editable) {
        this.removeAll();
        this.header = GameOptionsDialog.getDefaultHeader(this.freeColClient.getGame().getGameOptions().getName());
        this.add((Component)this.header, "North");
        JPanel uiPanel = new JPanel(new BorderLayout());
        uiPanel.setOpaque(false);
        this.ui = new OptionMapUI(this.freeColClient.getGame().getGameOptions(), editable);
        uiPanel.add((Component)this.ui, "Center");
        uiPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.add((Component)uiPanel, "Center");
        this.add((Component)this.buttons, "South");
        this.ok.setEnabled(editable);
        this.save.setEnabled(editable);
        this.load.setEnabled(editable);
        if (editable && this.freeColClient.isSingleplayer()) {
            BooleanOptionUI comp = (BooleanOptionUI)this.ui.getOptionUI("model.option.victoryDefeatHumans");
            comp.setValue(false);
            comp.setEnabled(false);
        }
    }

    public void requestFocus() {
        if (this.ok.isEnabled()) {
            this.ok.requestFocus();
        } else {
            this.cancel.requestFocus();
        }
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        try {
            switch (Integer.valueOf(command)) {
                case 0: {
                    this.ui.unregister();
                    this.ui.updateOption();
                    this.freeColClient.getPreGameController().sendGameOptions();
                    this.parent.remove(this);
                    this.setResponse(new Boolean(true));
                    break;
                }
                case 1: {
                    this.ui.rollback();
                    this.ui.unregister();
                    this.parent.remove(this);
                    this.setResponse(new Boolean(false));
                    break;
                }
                case 2: {
                    FileFilter[] filters = new FileFilter[]{FreeColDialog.getFGOFileFilter(), FreeColDialog.getFSGFileFilter(), FreeColDialog.getGameOptionsFileFilter()};
                    File saveFile = this.freeColClient.getCanvas().showSaveDialog(FreeCol.getSaveDirectory(), ".fgo", filters, "");
                    if (saveFile != null) {
                        this.ui.updateOption();
                        this.freeColClient.getGame().getGameOptions().save(saveFile);
                    }
                    break;
                }
                case 3: {
                    File loadFile = this.freeColClient.getCanvas().showLoadDialog(FreeCol.getSaveDirectory(), new FileFilter[]{FreeColDialog.getFGOFileFilter(), FreeColDialog.getFSGFileFilter(), FreeColDialog.getGameOptionsFileFilter()});
                    if (loadFile != null) {
                        this.freeColClient.getGame().getGameOptions().load(loadFile);
                    }
                    break;
                }
                case 4: {
                    this.ui.reset();
                    break;
                }
                default: {
                    logger.warning("Invalid ActionCommand: invalid number.");
                    break;
                }
            }
        }
        catch (NumberFormatException e) {
            logger.warning("Invalid Actioncommand: not a number.");
        }
    }
}

