/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Color;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Player;

public final class GoodsLabel
extends JLabel {
    private static Logger logger = Logger.getLogger(GoodsLabel.class.getName());
    private final Goods goods;
    private final Canvas parent;
    private boolean selected;
    private boolean partialChosen;

    public GoodsLabel(Goods goods, Canvas parent) {
        super(parent.getGUI().getImageLibrary().getGoodsImageIcon(goods.getType()));
        this.goods = goods;
        this.setToolTipText(goods.getName());
        this.parent = parent;
        this.selected = false;
        this.partialChosen = false;
        this.initializeDisplay();
    }

    public GoodsLabel(Goods goods, Canvas parent, boolean isSmall) {
        this(goods, parent);
        this.setSmall(true);
    }

    private void initializeDisplay() {
        Player player = null;
        Location location = this.goods.getLocation();
        if (location instanceof Ownable) {
            player = ((Ownable)((Object)location)).getOwner();
        }
        if (player == null || !this.goods.getType().isStorable() || player.canTrade(this.goods) || location instanceof Colony && player.getGameOptions().getBoolean("model.option.customIgnoreBoycott") && ((Colony)location).hasAbility("model.ability.export")) {
            this.setToolTipText(this.goods.getName());
            this.setEnabled(true);
        } else {
            this.setToolTipText(this.goods.getName(false));
            this.setEnabled(false);
        }
        if (this.goods.getType() != Goods.FOOD && location instanceof Colony && ((Colony)location).getWarehouseCapacity() < this.goods.getAmount()) {
            this.setForeground(Color.RED);
        } else if (location instanceof Colony && this.goods.getType().isStorable() && ((Colony)location).getExportData(this.goods.getType()).isExported()) {
            this.setForeground(Color.GREEN);
        } else if (this.goods.getAmount() == 0) {
            this.setForeground(Color.GRAY);
        } else if (this.goods.getAmount() < 0) {
            this.setForeground(Color.RED);
        } else {
            this.setForeground(Color.BLACK);
        }
        super.setText(String.valueOf(this.goods.getAmount()));
    }

    public boolean isPartialChosen() {
        return this.partialChosen;
    }

    public void setPartialChosen(boolean partialChosen) {
        this.partialChosen = partialChosen;
    }

    public Canvas getCanvas() {
        return this.parent;
    }

    public Goods getGoods() {
        return this.goods;
    }

    public void setSelected(boolean b) {
        this.selected = b;
    }

    public void setSmall(boolean isSmall) {
        if (isSmall) {
            ImageIcon imageIcon = this.parent.getGUI().getImageLibrary().getGoodsImageIcon(this.goods.getType());
            this.setIcon(new ImageIcon(imageIcon.getImage().getScaledInstance(imageIcon.getIconWidth() / 2, imageIcon.getIconHeight() / 2, 1)));
        } else {
            this.setIcon(this.parent.getGUI().getImageLibrary().getGoodsImageIcon(this.goods.getType()));
        }
    }
}

