/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import cz.autel.dmi.HIGLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;

public final class IndianSettlementPanel
extends FreeColDialog
implements ActionListener {
    private static final Logger logger = Logger.getLogger(IndianSettlementPanel.class.getName());
    private final FreeColClient freeColClient;
    private static final int OK = 0;
    private final JLabel settlementLabel;
    private final JLabel missionaryLabel;
    private final JLabel skillLabel;
    private final JLabel[] wantedGoodsLabels;
    private final JButton okButton;

    public IndianSettlementPanel(FreeColClient freeColClient) {
        this.freeColClient = freeColClient;
        int[] w = new int[]{10, 0, 30, 0, 10};
        int[] h = new int[]{10, 0, 5, 0, 5, 0, 5, 0, 10, 0, 10};
        this.setLayout(new HIGLayout(w, h));
        this.okButton = new JButton(Messages.message("ok", new String[0]));
        this.okButton.setActionCommand(String.valueOf(0));
        this.okButton.addActionListener(this);
        this.settlementLabel = new JLabel();
        this.missionaryLabel = new JLabel();
        this.skillLabel = new JLabel();
        this.wantedGoodsLabels = new JLabel[3];
        for (int i = 0; i < 3; ++i) {
            this.wantedGoodsLabels[i] = new JLabel();
        }
        int labelColumn = 2;
        int valueColumn = 4;
        this.add((Component)this.settlementLabel, higConst.rc(2, labelColumn));
        this.add((Component)this.missionaryLabel, higConst.rc(2, valueColumn));
        this.add((Component)new JLabel(Messages.message("indianSettlement.learnableSkill", new String[0])), higConst.rc(4, labelColumn));
        this.add((Component)this.skillLabel, higConst.rc(4, valueColumn));
        this.add((Component)new JLabel(Messages.message("indianSettlement.highlyWanted", new String[0])), higConst.rc(6, labelColumn));
        this.add((Component)this.wantedGoodsLabels[0], higConst.rc(6, valueColumn));
        this.add((Component)new JLabel(Messages.message("indianSettlement.otherWanted", new String[0])), higConst.rc(8, labelColumn));
        JPanel otherGoodsPanel = new JPanel();
        otherGoodsPanel.setOpaque(false);
        otherGoodsPanel.add(this.wantedGoodsLabels[1]);
        otherGoodsPanel.add(this.wantedGoodsLabels[2]);
        this.add((Component)otherGoodsPanel, higConst.rc(8, valueColumn));
        this.add((Component)this.okButton, higConst.rcwh(10, 2, 3, 1));
    }

    public void requestFocus() {
        this.okButton.requestFocus();
    }

    public void initialize(IndianSettlement settlement) {
        String skillName;
        UnitType skill;
        Image settlementImage = this.freeColClient.getImageLibrary().getSettlementImage(settlement);
        this.settlementLabel.setIcon(new ImageIcon(settlementImage));
        String text = settlement.getLocationName();
        Tension tension = settlement.getAlarm(this.freeColClient.getMyPlayer());
        if (tension != null) {
            text = text + " (" + tension.toString() + ")";
        } else if (!this.freeColClient.getMyPlayer().hasContacted(settlement.getOwner())) {
            text = text + " (" + Messages.message("notContacted", new String[0]) + ")";
        }
        this.settlementLabel.setText(text);
        Unit missionary = settlement.getMissionary();
        if (missionary != null) {
            ImageIcon missionaryImage = this.freeColClient.getImageLibrary().getUnitImageIcon(missionary);
            this.missionaryLabel.setIcon(this.freeColClient.getImageLibrary().getScaledImageIcon(missionaryImage, 0.66f));
            String missionaryName = missionary.getName() + " (" + missionary.getOwner().getNationAsString() + ")";
            this.missionaryLabel.setText(missionaryName);
        }
        if ((skill = settlement.getLearnableSkill()) != null) {
            skillName = skill.getName();
            ImageIcon skillImage = this.freeColClient.getImageLibrary().getUnitImageIcon(skill);
            this.skillLabel.setIcon(this.freeColClient.getImageLibrary().getScaledImageIcon(skillImage, 0.66f));
        } else {
            skillName = "indianSettlement.skill" + (settlement.hasBeenVisited() ? "None" : "Unknown");
        }
        this.skillLabel.setText(Messages.message(skillName, new String[0]));
        GoodsType[] wantedGoods = settlement.getWantedGoods();
        for (int i = 0; i < wantedGoods.length; ++i) {
            GoodsType g = wantedGoods[i];
            if (g == null) continue;
            this.wantedGoodsLabels[i].setText(g.getName());
            this.wantedGoodsLabels[i].setIcon(this.freeColClient.getImageLibrary().getScaledGoodsImageIcon(g, 0.66f));
        }
        this.setSize(this.getPreferredSize());
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        try {
            switch (Integer.valueOf(command)) {
                case 0: {
                    this.setResponse(new Boolean(true));
                    break;
                }
                default: {
                    logger.warning("Invalid Actioncommand: invalid number.");
                    break;
                }
            }
        }
        catch (NumberFormatException e) {
            logger.warning("Invalid Actioncommand: not a number.");
        }
    }
}

