/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import cz.autel.dmi.HIGLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.MapEditorTransformPanel;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.EquipmentType;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovement;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.resources.ResourceManager;

public final class InfoPanel
extends FreeColPanel {
    private static final Logger logger = Logger.getLogger(InfoPanel.class.getName());
    private static final int PANEL_WIDTH = 256;
    private static final int PANEL_HEIGHT = 128;
    private final FreeColClient freeColClient;
    private final Game game;
    private final ImageLibrary library;
    private final EndTurnPanel endTurnPanel = new EndTurnPanel();
    private final UnitInfoPanel unitInfoPanel;
    private final TileInfoPanel tileInfoPanel = new TileInfoPanel();
    private final JPanel mapEditorPanel;

    public InfoPanel(final FreeColClient freeColClient) {
        this.freeColClient = freeColClient;
        this.game = freeColClient.getGame();
        this.library = freeColClient.getImageLibrary();
        this.unitInfoPanel = new UnitInfoPanel();
        this.setLayout(null);
        int internalPanelTop = 0;
        int internalPanelHeight = 128;
        Image skin = ResourceManager.getImage("InfoPanel.skin");
        if (skin == null) {
            this.setSize(256, 128);
        } else {
            this.setBorder(null);
            this.setSize(skin.getWidth(null), skin.getHeight(null));
            this.setOpaque(false);
            internalPanelTop = 75;
            internalPanelHeight = 100;
        }
        this.mapEditorPanel = new JPanel(null);
        this.mapEditorPanel.setSize(130, 100);
        this.mapEditorPanel.setOpaque(false);
        this.add(this.unitInfoPanel, internalPanelTop, internalPanelHeight);
        this.add(this.endTurnPanel, internalPanelTop, internalPanelHeight);
        this.add(this.tileInfoPanel, internalPanelTop, internalPanelHeight);
        this.add(this.mapEditorPanel, internalPanelTop, internalPanelHeight);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                GUI gui = freeColClient.getGUI();
                Unit activeUnit = gui.getActiveUnit();
                if (activeUnit != null && activeUnit.getTile() != null) {
                    gui.setFocus(activeUnit.getTile().getPosition());
                }
            }
        });
    }

    private void add(JPanel panel, int internalPanelTop, int internalPanelHeight) {
        panel.setVisible(false);
        panel.setLocation((this.getWidth() - panel.getWidth()) / 2, internalPanelTop + (internalPanelHeight - panel.getHeight()) / 2);
        this.add(panel);
    }

    public void update(Unit unit) {
        this.unitInfoPanel.update(unit);
    }

    public void update(MapEditorTransformPanel.MapTransform mapTransform) {
        JPanel p;
        if (mapTransform != null && (p = mapTransform.getDescriptionPanel()) != null) {
            p.setOpaque(false);
            Dimension d = p.getPreferredSize();
            p.setBounds(0, (this.mapEditorPanel.getHeight() - d.height) / 2, this.mapEditorPanel.getWidth(), d.height);
            this.mapEditorPanel.removeAll();
            this.mapEditorPanel.add((Component)p, "Center");
            this.mapEditorPanel.validate();
            this.mapEditorPanel.revalidate();
            this.mapEditorPanel.repaint();
        }
    }

    public void update(Tile tile) {
        this.tileInfoPanel.update(tile);
    }

    public Unit getUnit() {
        return this.unitInfoPanel.getUnit();
    }

    public Tile getTile() {
        return this.tileInfoPanel.getTile();
    }

    public void paintComponent(Graphics graphics) {
        int viewMode = this.freeColClient.getGUI().getViewMode().getView();
        if (!this.freeColClient.isMapEditor()) {
            if (this.mapEditorPanel.isVisible()) {
                this.mapEditorPanel.setVisible(false);
            }
            switch (viewMode) {
                case 0: {
                    if (this.unitInfoPanel.getUnit() != null) {
                        if (!this.unitInfoPanel.isVisible()) {
                            this.unitInfoPanel.setVisible(true);
                            this.endTurnPanel.setVisible(false);
                        }
                    } else if (this.freeColClient.getMyPlayer() != null && !this.freeColClient.getMyPlayer().hasNextActiveUnit() && !this.endTurnPanel.isVisible()) {
                        this.endTurnPanel.setVisible(true);
                        this.unitInfoPanel.setVisible(false);
                    }
                    this.tileInfoPanel.setVisible(false);
                    break;
                }
                case 1: {
                    this.unitInfoPanel.setVisible(false);
                    this.endTurnPanel.setVisible(false);
                    this.tileInfoPanel.setVisible(true);
                }
            }
        } else if (!this.mapEditorPanel.isVisible()) {
            this.mapEditorPanel.setVisible(true);
            this.unitInfoPanel.setVisible(false);
            this.endTurnPanel.setVisible(false);
            this.tileInfoPanel.setVisible(false);
        }
        Image skin = ResourceManager.getImage("InfoPanel.skin");
        if (skin != null) {
            graphics.drawImage(skin, 0, 0, null);
        }
        super.paintComponent(graphics);
    }

    public class EndTurnPanel
    extends JPanel {
        private JLabel endTurnLabel;
        private JButton endTurnButton;

        public EndTurnPanel() {
            super(new FlowLayout(1, 10, 10));
            this.endTurnLabel = new JLabel(Messages.message("infoPanel.endTurnPanel.text", new String[0]), 0);
            this.endTurnButton = new JButton(Messages.message("infoPanel.endTurnPanel.endTurnButton", new String[0]));
            this.add(this.endTurnLabel);
            this.add(this.endTurnButton);
            this.setOpaque(false);
            this.setSize(230, this.endTurnLabel.getPreferredSize().height + this.endTurnButton.getPreferredSize().height + 30);
            this.endTurnButton.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    InfoPanel.this.freeColClient.getInGameController().endTurn();
                }
            });
        }
    }

    public class UnitInfoPanel
    extends JPanel {
        private final JLabel unitLabel;
        private final JLabel unitNameLabel;
        private final JLabel unitTypeLabel;
        private final JLabel unitMovesLabel;
        private final JLabel unitToolsLabel;
        private final JLabel goldLabel;
        private final JPanel unitCargoPanel;
        private final JPanel labelPanel;
        private Unit unit;
        private final int[] widths;
        private final int[] heights;

        public UnitInfoPanel() {
            super(null);
            this.widths = new int[]{0, 0, 0, 0};
            this.heights = new int[]{0, 0};
            Image tools = InfoPanel.this.library.getGoodsImage(Goods.TOOLS);
            ImageIcon toolsIcon = new ImageIcon(tools.getScaledInstance(tools.getWidth(null) * 2 / 3, tools.getHeight(null) * 2 / 3, 4));
            this.unitToolsLabel = new JLabel(toolsIcon);
            this.unitCargoPanel = new JPanel(new HIGLayout(this.widths, this.heights));
            this.unitCargoPanel.setOpaque(false);
            JPanel picturePanel = new JPanel(new BorderLayout());
            picturePanel.setOpaque(false);
            picturePanel.setSize(110, 100);
            picturePanel.setLocation(0, 0);
            this.unitLabel = new JLabel();
            this.unitLabel.setHorizontalAlignment(0);
            this.unitLabel.setVerticalAlignment(0);
            picturePanel.add((Component)this.unitLabel, "Center");
            this.add(picturePanel);
            int[] widths = new int[]{0};
            int[] heights = new int[]{0, 0, 0, 0};
            this.labelPanel = new JPanel(new HIGLayout(widths, heights));
            this.labelPanel.setOpaque(false);
            this.unitNameLabel = new JLabel();
            this.unitMovesLabel = new JLabel();
            this.unitTypeLabel = new JLabel();
            this.goldLabel = new JLabel();
            this.labelPanel.add((Component)this.unitNameLabel, FreeColPanel.higConst.rc(1, 1));
            this.labelPanel.add((Component)this.unitTypeLabel, FreeColPanel.higConst.rc(2, 1));
            this.labelPanel.add((Component)this.unitMovesLabel, FreeColPanel.higConst.rc(3, 1));
            this.labelPanel.add((Component)this.unitCargoPanel, FreeColPanel.higConst.rc(4, 1));
            this.unitLabel.setFocusable(false);
            this.unitNameLabel.setFocusable(false);
            this.unitTypeLabel.setFocusable(false);
            this.unitMovesLabel.setFocusable(false);
            this.unitToolsLabel.setFocusable(false);
            this.labelPanel.setSize(130, 100);
            this.labelPanel.setLocation(100, 10);
            this.add(this.labelPanel);
            this.setSize(226, 100);
            this.setOpaque(false);
        }

        public void update(Unit unit2) {
            this.unit = unit2;
            this.unitCargoPanel.removeAll();
            if (this.unit != null) {
                this.setUnitNameType(this.unit);
                this.unitLabel.setIcon(InfoPanel.this.library.getUnitImageIcon(this.unit));
                if (this.unit.getRole() == Unit.Role.PIONEER) {
                    EquipmentType toolsType = FreeCol.getSpecification().getEquipmentType("model.equipment.tools");
                    int count = this.unit.getEquipmentCount(toolsType) * 20;
                    this.unitToolsLabel.setText(String.valueOf(count));
                    this.unitCargoPanel.add((Component)this.unitToolsLabel, FreeColPanel.higConst.rc(1, 1));
                } else if (this.unit.canCarryTreasure()) {
                    this.goldLabel.setText(this.unit.getTreasureAmount() + " " + Messages.message("gold", new String[0]));
                    this.unitCargoPanel.add((Component)this.goldLabel, FreeColPanel.higConst.rc(1, 1));
                } else if (this.unit.isCarrier()) {
                    this.addCarriedGoods(this.unit);
                }
            } else {
                this.unitLabel.setIcon(null);
            }
            this.labelPanel.validate();
        }

        public Unit getUnit() {
            return this.unit;
        }

        private void setUnitNameType(Unit unit) {
            String name = unit.getName();
            int index = name.indexOf(" (");
            if (index < 0) {
                this.unitNameLabel.setText(name);
                this.unitTypeLabel.setText(null);
            } else {
                this.unitNameLabel.setText(name.substring(0, index));
                this.unitTypeLabel.setText(name.substring(index + 1));
            }
            this.unitMovesLabel.setText(Messages.message("moves", new String[0]) + " " + unit.getMovesAsString());
        }

        private void addCarriedGoods(Unit unit) {
            int counter = 1;
            int row = 1;
            for (Goods goods : unit.getGoodsList()) {
                JLabel goodsLabel = new JLabel(InfoPanel.this.library.getScaledGoodsImageIcon(goods.getType(), 0.66f));
                goodsLabel.setToolTipText(String.valueOf(goods.getAmount()) + " " + goods.getName());
                this.unitCargoPanel.add((Component)goodsLabel, FreeColPanel.higConst.rc(row, counter));
                if (counter == 4) {
                    ++row;
                    counter = 1;
                    continue;
                }
                ++counter;
            }
            for (Unit carriedUnit : unit.getUnitList()) {
                ImageIcon unitIcon = InfoPanel.this.library.getUnitImageIcon(carriedUnit);
                JLabel unitLabel = new JLabel(InfoPanel.this.library.getScaledImageIcon(unitIcon, 0.5f));
                unitLabel.setToolTipText(carriedUnit.getName());
                this.unitCargoPanel.add((Component)unitLabel, FreeColPanel.higConst.rc(row, counter));
                if (counter == 4) {
                    ++row;
                    counter = 1;
                    continue;
                }
                ++counter;
            }
            this.unitCargoPanel.validate();
        }
    }

    public class TileInfoPanel
    extends JPanel {
        private final JLabel tileLabel;
        private final JLabel tileNameLabel;
        private final JLabel bonusLabel;
        private final JLabel riverRoadLabel;
        private final JLabel plowOwnerLabel;
        private final JLabel movementLabel;
        private final JPanel picturePanel;
        private final JPanel labelPanel;
        private final JPanel goodsPanel;
        private Tile tile;

        public TileInfoPanel() {
            super(null);
            this.picturePanel = new JPanel(new BorderLayout());
            this.picturePanel.setOpaque(false);
            this.picturePanel.setSize(130, 100);
            this.picturePanel.setLocation(0, 0);
            this.tileLabel = new JLabel();
            this.tileLabel.setHorizontalAlignment(0);
            this.tileLabel.setVerticalAlignment(0);
            this.picturePanel.add((Component)this.tileLabel, "Center");
            this.add(this.picturePanel);
            int[] widths_goods = new int[]{0, 0, 0};
            int[] heights_goods = new int[]{0, 0};
            this.goodsPanel = new JPanel(new HIGLayout(widths_goods, heights_goods));
            this.goodsPanel.setOpaque(false);
            int[] widths = new int[]{0};
            int[] heights = new int[8];
            this.labelPanel = new JPanel(new HIGLayout(widths, heights));
            this.labelPanel.setOpaque(false);
            this.tileNameLabel = new JLabel();
            this.bonusLabel = new JLabel();
            this.riverRoadLabel = new JLabel();
            this.plowOwnerLabel = new JLabel();
            this.movementLabel = new JLabel();
            this.tileLabel.setFocusable(false);
            this.tileNameLabel.setFocusable(false);
            this.bonusLabel.setFocusable(false);
            this.riverRoadLabel.setFocusable(false);
            this.plowOwnerLabel.setFocusable(false);
            this.movementLabel.setFocusable(false);
            this.bonusLabel.setFont(this.bonusLabel.getFont().deriveFont(9.0f));
            this.riverRoadLabel.setFont(this.riverRoadLabel.getFont().deriveFont(9.0f));
            this.plowOwnerLabel.setFont(this.plowOwnerLabel.getFont().deriveFont(9.0f));
            this.movementLabel.setFont(this.movementLabel.getFont().deriveFont(9.0f));
            this.labelPanel.setSize(100, 100);
            this.labelPanel.setLocation(130, 10);
            this.add(this.labelPanel);
            this.setSize(226, 100);
            this.setOpaque(false);
        }

        private int getMovementCost(Tile tile) {
            return tile.getType().getBasicMoveCost();
        }

        private void addProducedGoods(Tile tile) {
            int counter = 1;
            int row = 1;
            this.goodsPanel.removeAll();
            List<AbstractGoods> production = tile.getType().getProduction();
            for (AbstractGoods goods : production) {
                JLabel goodsLabel = new JLabel(String.valueOf(tile.potential(goods.getType(), null)), InfoPanel.this.library.getScaledGoodsImageIcon(goods.getType(), 0.5f), 4);
                goodsLabel.setToolTipText(goods.getType().getName());
                goodsLabel.setFont(goodsLabel.getFont().deriveFont(9.0f));
                this.goodsPanel.add((Component)goodsLabel, FreeColPanel.higConst.rc(row, counter));
                if (counter == 3) {
                    ++row;
                    counter = 1;
                    continue;
                }
                ++counter;
            }
            this.goodsPanel.validate();
        }

        public void update(Tile tile) {
            this.tile = tile;
            this.labelPanel.removeAll();
            if (tile != null) {
                if (tile.isExplored()) {
                    this.tileNameLabel.setText(tile.getName());
                    this.labelPanel.add((Component)this.tileNameLabel, FreeColPanel.higConst.rc(1, 1));
                    StringBuilder text = new StringBuilder();
                    int row = 2;
                    for (TileImprovement tileImprovement : tile.getCompletedTileImprovements()) {
                        text.append(tileImprovement.getType().getDescription());
                        text.append(", ");
                    }
                    if (tile.getOwner() != null) {
                        text.append(tile.getOwner().getNationAsString());
                    } else {
                        int length = text.length();
                        if (length > 2) {
                            text.delete(length - 2, length);
                        }
                    }
                    if (text.length() > 0) {
                        this.plowOwnerLabel.setText(text.toString());
                        this.labelPanel.add((Component)this.plowOwnerLabel, FreeColPanel.higConst.rc(row, 1));
                        ++row;
                    }
                    int defenceBonus = (int)tile.getType().getFeatureContainer().applyModifier(100.0f, "model.modifier.defence") - 100;
                    this.bonusLabel.setText(Messages.message("colopedia.terrain.defenseBonus", new String[0]) + " " + defenceBonus + "%");
                    this.labelPanel.add((Component)this.bonusLabel, FreeColPanel.higConst.rc(row, 1));
                    this.movementLabel.setText(Messages.message("colopedia.terrain.movementCost", new String[0]) + " " + String.valueOf(this.getMovementCost(tile) / 3));
                    this.labelPanel.add((Component)this.movementLabel, FreeColPanel.higConst.rc(++row, 1));
                    this.labelPanel.add((Component)this.goodsPanel, FreeColPanel.higConst.rc(++row, 1));
                    this.addProducedGoods(tile);
                    int width = InfoPanel.this.library.getTerrainImageWidth(tile.getType());
                    int height = InfoPanel.this.library.getTerrainImageHeight(tile.getType());
                    BufferedImage image = new BufferedImage(width, height, 2);
                    InfoPanel.this.freeColClient.getGUI().displayTerrain(image.createGraphics(), InfoPanel.this.freeColClient.getGame().getMap(), tile, 0, 0);
                    this.tileLabel.setIcon(new ImageIcon(image));
                } else {
                    this.tileNameLabel.setText("Unexplored");
                    this.labelPanel.add((Component)this.tileNameLabel, FreeColPanel.higConst.rc(1, 1));
                    int width = InfoPanel.this.library.getTerrainImageWidth(tile.getType());
                    int height = InfoPanel.this.library.getTerrainImageHeight(tile.getType());
                    BufferedImage image = new BufferedImage(width, height, 2);
                    InfoPanel.this.freeColClient.getGUI().displayTerrain(image.createGraphics(), InfoPanel.this.freeColClient.getGame().getMap(), tile, 0, 0);
                    this.tileLabel.setIcon(new ImageIcon(image));
                }
            } else {
                this.tileLabel.setIcon(null);
            }
            this.labelPanel.validate();
        }

        public Tile getTile() {
            return this.tile;
        }
    }
}

