/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import cz.autel.dmi.HIGLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.common.resources.ResourceManager;

public class InformationDialog
extends FreeColDialog {
    public static final int leftMargin = 10;
    public static final int rightMargin = 10;
    public static final int topMargin = 200;
    public static final int bottomMargin = 10;
    public static final int hGap = 10;
    public static final int vGap = 10;
    private JButton okButton = new JButton(Messages.message("ok", new String[0]));

    public InformationDialog(String text, ImageIcon image) {
        this(new String[]{text}, new ImageIcon[]{image});
    }

    public InformationDialog(String[] texts, ImageIcon[] images) {
        int[] widths = new int[]{10, 510, 10};
        int[] heights = new int[]{200, 252, 10, 30, 10};
        this.setLayout(new HIGLayout(widths, heights));
        int[] textWidths = new int[]{0, 10, 0};
        int[] textHeights = new int[2 * texts.length - 1];
        int imageColumn = 1;
        int textColumn = 3;
        for (int index = 1; index < texts.length; index += 2) {
            textHeights[index] = 3;
        }
        if (images == null) {
            textWidths = new int[]{0};
            textColumn = 1;
        }
        InformationDialog.enterPressesWhenFocused(this.okButton);
        HIGLayout layout = new HIGLayout(textWidths, textHeights);
        JPanel textPanel = new JPanel(layout);
        textPanel.setOpaque(false);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                InformationDialog.this.setResponse(null);
            }
        });
        int row = 1;
        for (int i = 0; i < texts.length; ++i) {
            if (images != null && images[i] != null) {
                textPanel.add((Component)new JLabel(images[i]), higConst.rc(row, imageColumn));
            }
            JTextArea textArea = InformationDialog.getDefaultTextArea(texts[i]);
            textArea.setColumns(30);
            textPanel.add((Component)textArea, higConst.rc(row, textColumn));
            row += 2;
        }
        JScrollPane scrollPane = new JScrollPane(textPanel, 20, 31);
        scrollPane.getViewport().setOpaque(false);
        scrollPane.setBorder(null);
        this.setBorder(null);
        this.add((Component)scrollPane, higConst.rc(2, 2));
        this.add((Component)this.okButton, higConst.rc(4, 2));
        this.setSize(this.getPreferredSize());
    }

    public void requestFocus() {
        this.okButton.requestFocus();
    }

    public void paintComponent(Graphics g) {
        Image bgImage = ResourceManager.getImage("InformationDialog.backgroundImage");
        if (bgImage != null) {
            g.drawImage(bgImage, 0, 0, this);
        } else {
            int width = this.getWidth();
            int height = this.getHeight();
            Image tempImage = ResourceManager.getImage("BackgroundImage");
            if (tempImage != null) {
                for (int x = 0; x < width; x += tempImage.getWidth(null)) {
                    for (int y = 0; y < height; y += tempImage.getHeight(null)) {
                        g.drawImage(tempImage, x, y, null);
                    }
                }
            } else {
                g.setColor(this.getBackground());
                g.fillRect(0, 0, width, height);
            }
        }
    }
}

