/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.client.gui.panel.FreeColPanel;

public final class LoadingSavegameDialog
extends FreeColDialog
implements ActionListener {
    private static final Logger logger = Logger.getLogger(LoadingSavegameDialog.class.getName());
    private static final int OK = 0;
    private static final int CANCEL = 1;
    private final Canvas parent;
    private final FreeColClient freeColClient;
    private JButton ok;
    private JPanel buttons = new JPanel(new FlowLayout());
    private JLabel header;
    private JRadioButton singleplayer;
    private JRadioButton privateMultiplayer;
    private JRadioButton publicMultiplayer;
    private JTextField serverNameField;
    private JSpinner portField;

    public LoadingSavegameDialog(Canvas parent, FreeColClient freeColClient) {
        this.setLayout(new BorderLayout());
        this.parent = parent;
        this.freeColClient = freeColClient;
        this.ok = new JButton(Messages.message("ok", new String[0]));
        this.ok.setActionCommand(String.valueOf(0));
        this.ok.addActionListener(this);
        this.ok.setMnemonic('O');
        this.buttons.add(this.ok);
        JButton cancel = new JButton(Messages.message("cancel", new String[0]));
        cancel.setActionCommand(String.valueOf(1));
        cancel.addActionListener(this);
        cancel.setMnemonic('C');
        this.buttons.add(cancel);
        FreeColPanel.enterPressesWhenFocused(this.ok);
        this.setCancelComponent(cancel);
        this.header = new JLabel(Messages.message("LoadingSavegame.title", new String[0]), 0);
        this.header.setFont(mediumHeaderFont);
        this.header.setBorder(new EmptyBorder(20, 0, 0, 0));
        this.add((Component)this.header, "North");
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setOpaque(false);
        JPanel p1 = new JPanel(new FlowLayout(0));
        p1.add(new JLabel(Messages.message("LoadingSavegame.serverName", new String[0]), 2));
        panel.add(p1);
        this.serverNameField = new JTextField();
        panel.add(this.serverNameField);
        JPanel p2 = new JPanel(new FlowLayout(0));
        p2.add(new JLabel(Messages.message("LoadingSavegame.port", new String[0]), 2));
        panel.add(p2);
        this.portField = new JSpinner(new SpinnerNumberModel(FreeCol.getDefaultPort(), 1, 65536, 1));
        panel.add(this.portField);
        ButtonGroup bg = new ButtonGroup();
        this.singleplayer = new JRadioButton(Messages.message("LoadingSavegame.singleplayer", new String[0]));
        bg.add(this.singleplayer);
        panel.add(this.singleplayer);
        this.privateMultiplayer = new JRadioButton(Messages.message("LoadingSavegame.privateMultiplayer", new String[0]));
        bg.add(this.privateMultiplayer);
        panel.add(this.privateMultiplayer);
        this.publicMultiplayer = new JRadioButton(Messages.message("LoadingSavegame.publicMultiplayer", new String[0]));
        bg.add(this.publicMultiplayer);
        panel.add(this.publicMultiplayer);
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.add((Component)panel, "Center");
        this.add((Component)this.buttons, "South");
        this.setSize(this.getPreferredSize());
    }

    public boolean isSingleplayer() {
        return this.singleplayer.isSelected();
    }

    public boolean isPublic() {
        return this.publicMultiplayer.isSelected();
    }

    public int getPort() {
        return (Integer)this.portField.getValue();
    }

    public String getName() {
        return this.serverNameField.getName();
    }

    public void initialize(boolean publicServer, boolean singleplayer) {
        this.singleplayer.setSelected(false);
        this.privateMultiplayer.setSelected(false);
        this.publicMultiplayer.setSelected(false);
        if (singleplayer) {
            this.singleplayer.setSelected(true);
        } else if (publicServer) {
            this.publicMultiplayer.setSelected(true);
        } else {
            this.privateMultiplayer.setSelected(true);
        }
        this.serverNameField.setText("");
    }

    public void requestFocus() {
        this.ok.requestFocus();
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        try {
            switch (Integer.valueOf(command)) {
                case 0: {
                    this.parent.remove(this);
                    this.setResponse(new Boolean(true));
                    break;
                }
                case 1: {
                    this.parent.remove(this);
                    this.setResponse(new Boolean(false));
                    break;
                }
                default: {
                    logger.warning("Invalid ActionCommand: invalid number.");
                    break;
                }
            }
        }
        catch (NumberFormatException e) {
            logger.warning("Invalid Actioncommand: not a number.");
        }
    }
}

