/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.NewPanel;
import net.sf.freecol.common.resources.ResourceManager;

public final class MainPanel
extends FreeColPanel
implements ActionListener {
    private static final Logger logger = Logger.getLogger(MainPanel.class.getName());
    public static final int NEW = 0;
    public static final int OPEN = 1;
    public static final int MAP_EDITOR = 2;
    public static final int OPTIONS = 3;
    public static final int QUIT = 4;
    private final Canvas parent;
    private final FreeColClient freeColClient;
    private JButton newButton;

    public MainPanel(Canvas parent, FreeColClient freeColClient) {
        this.setLayout(new BorderLayout());
        this.parent = parent;
        this.freeColClient = freeColClient;
        JButton openButton = new JButton(Messages.message("menuBar.game.open", new String[0]));
        JButton mapEditorButton = new JButton(Messages.message("mainPanel.editor", new String[0]));
        JButton optionsButton = new JButton(Messages.message("mainPanel.options", new String[0]));
        JButton quitButton = new JButton(Messages.message("menuBar.game.quit", new String[0]));
        this.setCancelComponent(quitButton);
        this.newButton = new JButton(Messages.message("menuBar.game.new", new String[0]));
        this.newButton.setActionCommand(String.valueOf(0));
        mapEditorButton.setActionCommand(String.valueOf(2));
        openButton.setActionCommand(String.valueOf(1));
        optionsButton.setActionCommand(String.valueOf(3));
        quitButton.setActionCommand(String.valueOf(4));
        this.newButton.addActionListener(this);
        mapEditorButton.addActionListener(this);
        openButton.addActionListener(this);
        optionsButton.addActionListener(this);
        quitButton.addActionListener(this);
        MainPanel.enterPressesWhenFocused(this.newButton);
        MainPanel.enterPressesWhenFocused(mapEditorButton);
        MainPanel.enterPressesWhenFocused(openButton);
        MainPanel.enterPressesWhenFocused(optionsButton);
        MainPanel.enterPressesWhenFocused(quitButton);
        Image tempImage = ResourceManager.getImage("TitleImage");
        if (tempImage != null) {
            JLabel logoLabel = new JLabel(new ImageIcon(tempImage));
            logoLabel.setBorder(new CompoundBorder(new EmptyBorder(2, 2, 2, 2), new BevelBorder(1)));
            this.add((Component)logoLabel, "Center");
        }
        JPanel buttons = new JPanel(new GridLayout(0, 1, 50, 10));
        buttons.add(this.newButton);
        buttons.add(openButton);
        buttons.add(mapEditorButton);
        buttons.add(optionsButton);
        buttons.add(quitButton);
        buttons.setBorder(new EmptyBorder(5, 25, 20, 25));
        buttons.setOpaque(false);
        this.add((Component)buttons, "South");
        this.setSize(this.getPreferredSize());
    }

    public void requestFocus() {
        this.newButton.requestFocus();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        Component[] components = this.getComponents();
        for (int i = 0; i < components.length; ++i) {
            components[i].setEnabled(enabled);
        }
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        try {
            switch (Integer.valueOf(command)) {
                case 0: {
                    this.parent.remove(this);
                    this.parent.showPanel(new NewPanel(this.parent));
                    break;
                }
                case 1: {
                    this.freeColClient.getConnectController().loadGame();
                    break;
                }
                case 2: {
                    this.freeColClient.getMapEditorController().startMapEditor();
                    break;
                }
                case 3: {
                    this.parent.showClientOptionsDialog();
                    break;
                }
                case 4: {
                    this.parent.quit();
                    break;
                }
                default: {
                    logger.warning("Invalid Actioncommand: invalid number.");
                    break;
                }
            }
        }
        catch (NumberFormatException e) {
            logger.warning("Invalid Actioncommand: not a number.");
        }
    }
}

