/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.ChoiceItem;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.ResourceType;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovement;
import net.sf.freecol.common.model.TileItemContainer;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.server.generator.River;
import net.sf.freecol.server.generator.RiverSection;

public final class MapEditorTransformPanel
extends FreeColPanel {
    private static final Logger logger = Logger.getLogger(MapEditorTransformPanel.class.getName());
    private final FreeColClient freeColClient;
    private final ImageLibrary library;
    private final JPanel listPanel;
    private ButtonGroup group;

    public MapEditorTransformPanel(Canvas parent) {
        super(parent, new BorderLayout());
        this.freeColClient = parent.getClient();
        this.library = parent.getGUI().getImageLibrary();
        this.listPanel = new JPanel(new GridLayout(2, 0));
        this.group = new ButtonGroup();
        this.buildList();
        JScrollPane sl = new JScrollPane(this.listPanel, 20, 30);
        sl.getViewport().setOpaque(false);
        this.add(sl);
    }

    private void buildList() {
        List<TileType> tileList = FreeCol.getSpecification().getTileTypeList();
        for (TileType type : tileList) {
            this.buildButton(this.library.getScaledTerrainImage(type, 1.0f), type.getName(), new TileTypeTransform(type));
        }
        this.buildButton(this.library.getRiverImage(10), Messages.message("minorRiver", new String[0]), new RiverTransform(1));
        this.buildButton(this.library.getRiverImage(20), Messages.message("majorRiver", new String[0]), new RiverTransform(2));
        this.buildButton(this.library.getBonusImage(FreeCol.getSpecification().getResourceTypeList().get(0)), Messages.message("editor.resource", new String[0]), new ResourceTransform());
        this.buildButton(this.library.getMiscImage("lostCityRumour.image"), Messages.message("model.message.LOST_CITY_RUMOUR", new String[0]), new LostCityRumourTransform());
    }

    private void buildButton(Image image, String text, final MapTransform mt) {
        Image scaledImage = this.library.scaleImage(image, 0.5f);
        JPanel descriptionPanel = new JPanel(new BorderLayout());
        descriptionPanel.add((Component)new JLabel(new ImageIcon(image)), "Center");
        descriptionPanel.add((Component)new JLabel(text, 0), "South");
        descriptionPanel.setBackground(Color.RED);
        mt.setDescriptionPanel(descriptionPanel);
        ImageIcon icon = new ImageIcon(scaledImage);
        JButton button = new JButton(icon);
        button.setToolTipText(text);
        button.setOpaque(false);
        this.group.add(button);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MapEditorTransformPanel.this.freeColClient.getMapEditorController().setMapTransform(mt);
            }
        });
        button.setBorder(null);
        this.listPanel.add(button);
    }

    private class LostCityRumourTransform
    extends MapTransform {
        private LostCityRumourTransform() {
        }

        public void transform(Tile t) {
            t.setLostCityRumour(!t.hasLostCityRumour());
        }
    }

    private class ResourceTransform
    extends MapTransform {
        private ResourceTransform() {
        }

        public void transform(Tile t) {
            if (t.hasResource()) {
                t.getTileItemContainer().clearResource();
            } else {
                List<ResourceType> resList = t.getType().getResourceTypeList();
                switch (resList.size()) {
                    case 0: {
                        return;
                    }
                    case 1: {
                        t.setResource(resList.get(0));
                        return;
                    }
                }
                ChoiceItem[] choices = new ChoiceItem[resList.size()];
                for (int index = 0; index < choices.length; ++index) {
                    ResourceType resType = resList.get(index);
                    choices[index] = new ChoiceItem(resType.getName(), resType);
                }
                ChoiceItem choice = (ChoiceItem)MapEditorTransformPanel.this.getCanvas().showChoiceDialog("ok", "cancel", choices);
                if (choice != null) {
                    ResourceType resourceType = (ResourceType)choice.getObject();
                    t.setResource(resourceType);
                }
            }
        }
    }

    private class RiverTransform
    extends MapTransform {
        private int magnitude;

        private RiverTransform(int magnitude) {
            this.magnitude = magnitude;
        }

        public void transform(Tile tile) {
            if (tile.getType().canHaveRiver()) {
                TileItemContainer tic = tile.getTileItemContainer();
                if (tic == null) {
                    tic = new TileItemContainer(tile.getGame(), tile);
                    tile.setTileItemContainer(tic);
                }
                int oldMagnitude = 0;
                if (tic.hasRiver()) {
                    oldMagnitude = tic.getRiver().getMagnitude();
                }
                if (this.magnitude != oldMagnitude) {
                    tic.addRiver(this.magnitude, tic.getRiverStyle());
                    RiverSection mysection = new RiverSection(tic.getRiverStyle());
                    for (Map.Direction direction : River.directions) {
                        Tile t = tile.getMap().getNeighbourOrNull(direction, tile);
                        if (t == null) continue;
                        TileImprovement otherRiver = t.getRiver();
                        if (!t.isLand() && otherRiver == null) {
                            otherRiver = new TileImprovement(tile.getGame(), tile, FreeCol.getSpecification().getTileImprovementType("model.improvement.River"));
                            otherRiver.setMagnitude(tile.getRiver().getMagnitude());
                        }
                        if (otherRiver == null) continue;
                        Map.Direction otherDirection = direction.getReverseDirection();
                        RiverSection oppositesection = new RiverSection(otherRiver.getStyle());
                        oppositesection.setBranch(otherDirection, tile.getRiver().getMagnitude());
                        otherRiver.setStyle(oppositesection.encodeStyle());
                        mysection.setBranch(direction, tile.getRiver().getMagnitude());
                    }
                    tile.getRiver().setStyle(mysection.encodeStyle());
                }
            }
        }
    }

    private class TileTypeTransform
    extends MapTransform {
        private TileType tileType;

        private TileTypeTransform(TileType tileType) {
            this.tileType = tileType;
        }

        public void transform(Tile t) {
            t.setType(this.tileType);
            t.setLostCityRumour(false);
        }
    }

    public abstract class MapTransform {
        private JPanel descriptionPanel = null;

        public abstract void transform(Tile var1);

        public JPanel getDescriptionPanel() {
            return this.descriptionPanel;
        }

        public void setDescriptionPanel(JPanel descriptionPanel) {
            this.descriptionPanel = descriptionPanel;
        }
    }
}

