/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.option.BooleanOptionUI;
import net.sf.freecol.client.gui.option.FileOptionUI;
import net.sf.freecol.client.gui.option.OptionMapUI;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.server.generator.MapGeneratorOptions;

public final class MapGeneratorOptionsDialog
extends FreeColDialog
implements ActionListener {
    private static final Logger logger = Logger.getLogger(MapGeneratorOptionsDialog.class.getName());
    private static final int OK = 0;
    private static final int CANCEL = 1;
    private static final int RESET = 2;
    private final Canvas parent;
    private final FreeColClient freeColClient;
    private JButton ok;
    private JButton cancel;
    private JPanel buttons = new JPanel(new FlowLayout());
    private JLabel header;
    private OptionMapUI ui;

    public MapGeneratorOptionsDialog(Canvas parent, FreeColClient freeColClient) {
        this.setLayout(new BorderLayout());
        this.parent = parent;
        this.freeColClient = freeColClient;
        this.ok = new JButton(Messages.message("ok", new String[0]));
        this.ok.setActionCommand(String.valueOf(0));
        this.ok.addActionListener(this);
        this.ok.setMnemonic('O');
        this.buttons.add(this.ok);
        JButton reset = new JButton(Messages.message("reset", new String[0]));
        reset.setActionCommand(String.valueOf(2));
        reset.addActionListener(this);
        reset.setMnemonic('R');
        this.buttons.add(reset);
        this.cancel = new JButton(Messages.message("cancel", new String[0]));
        this.cancel.setActionCommand(String.valueOf(1));
        this.cancel.addActionListener(this);
        this.cancel.setMnemonic('C');
        this.buttons.add(this.cancel);
        FreeColPanel.enterPressesWhenFocused(this.ok);
        this.setCancelComponent(this.cancel);
        this.setSize(750, 500);
    }

    public Dimension getMinimumSize() {
        return new Dimension(750, 500);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void initialize(boolean editable, MapGeneratorOptions mgo) {
        this.removeAll();
        this.header = MapGeneratorOptionsDialog.getDefaultHeader(mgo.getName());
        this.add((Component)this.header, "North");
        JPanel uiPanel = new JPanel(new BorderLayout());
        uiPanel.setOpaque(false);
        this.ui = new OptionMapUI(mgo, editable);
        uiPanel.add((Component)this.ui, "Center");
        uiPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.add((Component)uiPanel, "Center");
        this.add((Component)this.buttons, "South");
        this.ok.setEnabled(editable);
        JPanel shortcutsPanel = new JPanel(new FlowLayout(0));
        shortcutsPanel.setOpaque(false);
        shortcutsPanel.add(new JLabel(Messages.message("shortcuts", new String[0])));
        File mapDirectory = new File(FreeCol.getDataDirectory(), "maps");
        if (mapDirectory.isDirectory()) {
            for (final File file : mapDirectory.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return file.isFile() && file.getName().endsWith(".fsg");
                }
            })) {
                JButton mapButton = new JButton();
                String mapName = file.getName().substring(0, file.getName().lastIndexOf(46));
                String imageName = mapName + ".png";
                File imageFile = new File(mapDirectory, imageName);
                if (imageFile.exists() && imageFile.isFile()) {
                    try {
                        BufferedImage mapImage = ImageIO.read(imageFile);
                        ImageIcon mapIcon = new ImageIcon(mapImage);
                        mapButton.setIcon(mapIcon);
                        mapButton.setToolTipText(mapName);
                    }
                    catch (IOException e) {
                        logger.warning("Unable to load map image " + imageName);
                    }
                } else {
                    mapButton.setText(mapName);
                }
                mapButton.setBorderPainted(false);
                mapButton.setRolloverEnabled(true);
                final OptionMapUI theUI = this.ui;
                mapButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        theUI.reset();
                        FileOptionUI fou = (FileOptionUI)theUI.getOptionUI("model.option.importFile");
                        fou.setValue(file);
                        ((BooleanOptionUI)theUI.getOptionUI("model.option.importRumours")).setValue(false);
                        ((BooleanOptionUI)theUI.getOptionUI("model.option.importTerrain")).setValue(true);
                        ((BooleanOptionUI)theUI.getOptionUI("model.option.importBonuses")).setValue(false);
                    }
                });
                shortcutsPanel.add(mapButton);
            }
        }
        uiPanel.add((Component)shortcutsPanel, "North");
    }

    public void requestFocus() {
        if (this.ok.isEnabled()) {
            this.ok.requestFocus();
        } else {
            this.cancel.requestFocus();
        }
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        try {
            switch (Integer.valueOf(command)) {
                case 0: {
                    this.ui.unregister();
                    this.ui.updateOption();
                    this.parent.remove(this);
                    if (!this.freeColClient.isMapEditor()) {
                        this.freeColClient.getPreGameController().sendMapGeneratorOptions();
                        this.freeColClient.getCanvas().getStartGamePanel().updateMapGeneratorOptions();
                    }
                    this.setResponse(new Boolean(true));
                    break;
                }
                case 1: {
                    this.ui.rollback();
                    this.ui.unregister();
                    this.parent.remove(this);
                    this.setResponse(new Boolean(false));
                    break;
                }
                case 2: {
                    this.ui.reset();
                    break;
                }
                default: {
                    logger.warning("Invalid ActionCommand: invalid number.");
                    break;
                }
            }
        }
        catch (NumberFormatException e) {
            logger.warning("Invalid Actioncommand: not a number.");
        }
    }
}

