/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.Player;

public final class MarketLabel
extends JLabel
implements ActionListener {
    private static Logger logger = Logger.getLogger(MarketLabel.class.getName());
    private final GoodsType type;
    private int amount;
    private final Market market;
    private final Canvas parent;
    private boolean partialChosen;

    public MarketLabel(GoodsType type, Market market, Canvas parent) {
        super(parent.getGUI().getImageLibrary().getGoodsImageIcon(type));
        this.type = type;
        if (market == null) {
            throw new NullPointerException();
        }
        this.market = market;
        this.parent = parent;
        this.partialChosen = false;
        this.amount = 100;
    }

    public MarketLabel(GoodsType type, Market market, Canvas parent, boolean isSmall) {
        this(type, market, parent);
        this.setSmall(true);
    }

    public boolean isPartialChosen() {
        return this.partialChosen;
    }

    public void setPartialChosen(boolean partialChosen) {
        this.partialChosen = partialChosen;
    }

    public GoodsType getType() {
        return this.type;
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public Market getMarket() {
        return this.market;
    }

    public void setSmall(boolean isSmall) {
        if (isSmall) {
            ImageIcon imageIcon = this.parent.getGUI().getImageLibrary().getGoodsImageIcon(this.type);
            this.setIcon(new ImageIcon(imageIcon.getImage().getScaledInstance(imageIcon.getIconWidth() / 2, imageIcon.getIconHeight() / 2, 1)));
        } else {
            this.setIcon(this.parent.getGUI().getImageLibrary().getGoodsImageIcon(this.type));
        }
    }

    public void paintComponent(Graphics g) {
        Player player = this.market.getGame().getViewOwner();
        String toolTipText = this.type.getName();
        if (player == null || player.canTrade(this.type)) {
            this.setEnabled(true);
        } else {
            toolTipText = this.type.getName(false);
            this.setEnabled(false);
        }
        if (FreeCol.isInDebugMode()) {
            toolTipText = toolTipText + " " + this.market.getMarketData(this.type).getAmountInMarket();
        }
        this.setToolTipText(toolTipText);
        super.setText(Integer.toString(this.market.paidForSale(this.type)) + "/" + Integer.toString(this.market.costToBuy(this.type)));
        super.paintComponent(g);
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        try {
            switch (Integer.valueOf(command)) {
                default: 
            }
            logger.warning("Invalid action");
            this.setIcon(this.parent.getGUI().getImageLibrary().getGoodsImageIcon(this.type));
            this.repaint(0, 0, this.getWidth(), this.getHeight());
        }
        catch (NumberFormatException e) {
            logger.warning("Invalid action number");
        }
    }
}

