/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import javax.swing.event.MouseInputListener;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.action.MiniMapChangeBackgroundAction;
import net.sf.freecol.client.gui.panel.ImageProvider;
import net.sf.freecol.client.gui.panel.UnitButton;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.resources.ResourceManager;

public final class MiniMap
extends JPanel
implements MouseInputListener {
    private static final Logger logger = Logger.getLogger(MiniMap.class.getName());
    public static final int MINIMAP_ZOOMOUT = 13;
    public static final int MINIMAP_ZOOMIN = 14;
    private static final int MAP_WIDTH = 220;
    private static final int MAP_HEIGHT = 128;
    private int mapX;
    private int mapY;
    private boolean scaleMap = false;
    private FreeColClient freeColClient;
    private final JButton miniMapZoomOutButton;
    private final JButton miniMapZoomInButton;
    private Color backgroundColor;
    private int tileSize;
    private int xOffset;
    private int yOffset;
    private int adjustX = 0;
    private int adjustY = 0;
    float scaledFactorX = 1.0f;
    float scaledFactorY = 1.0f;
    int scaledOffsetX = 0;
    int scaledOffsetY = 0;
    private int initialX;
    private int initialY;

    public MiniMap(FreeColClient freeColClient) {
        this.freeColClient = freeColClient;
        this.backgroundColor = Color.BLACK;
        this.tileSize = 4 * (freeColClient.getClientOptions().getInteger("model.option.defaultZoomLevel") + 1);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setLayout(null);
        Image skin = ResourceManager.getImage("MiniMap.skin");
        if (skin == null) {
            try {
                BevelBorder border = new BevelBorder(0);
                this.setBorder(border);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.setSize(220, 128);
            this.setOpaque(true);
            this.mapX = 0;
            this.mapY = 0;
        } else {
            this.setBorder(null);
            this.setSize(skin.getWidth(null), skin.getHeight(null));
            this.setOpaque(false);
            this.mapX = 38;
            this.mapY = 75;
        }
        this.miniMapZoomOutButton = new UnitButton(freeColClient.getActionManager().getFreeColAction("miniMapZoomOutAction"));
        this.miniMapZoomInButton = new UnitButton(freeColClient.getActionManager().getFreeColAction("miniMapZoomInAction"));
        this.miniMapZoomOutButton.setFocusable(false);
        this.miniMapZoomInButton.setFocusable(false);
        int bh = this.mapY + 128 - Math.max(this.miniMapZoomOutButton.getHeight(), this.miniMapZoomInButton.getHeight());
        int bw = this.mapX;
        if (this.getBorder() != null) {
            Insets insets = this.getBorder().getBorderInsets(this);
            bh -= insets.bottom;
            bw += insets.left;
        }
        this.miniMapZoomInButton.setLocation(4, 174);
        this.miniMapZoomOutButton.setLocation(264, 174);
        this.add(this.miniMapZoomInButton);
        this.add(this.miniMapZoomOutButton);
    }

    public void zoomIn() {
        if (this.scaleMap) {
            this.scaleMap = false;
        } else {
            this.tileSize += 4;
            if (this.tileSize >= 24) {
                this.tileSize = 24;
            }
        }
        this.repaint();
    }

    public void zoomOut() {
        if (this.tileSize > 8) {
            this.tileSize -= 4;
        } else if (this.tileSize == 4) {
            this.scaleMap = true;
        } else {
            this.tileSize = 4;
        }
        this.repaint();
    }

    public boolean canZoomIn() {
        return this.tileSize < 20;
    }

    public boolean canZoomOut() {
        if (this.freeColClient.getGame() == null || this.freeColClient.getGame().getMap() == null) {
            return false;
        }
        int realMapWidth = this.freeColClient.getGame().getMap().getWidth();
        int realMapHeight = this.freeColClient.getGame().getMap().getHeight();
        return this.tileSize > 4 || !this.scaleMap && (realMapWidth * 4 > 220 || realMapHeight > 128);
    }

    public void paintComponent(Graphics graphics) {
        if (this.freeColClient.getGame() == null || this.freeColClient.getGame().getMap() == null) {
            return;
        }
        Image skin = ResourceManager.getImage("MiniMap.skin");
        int colorIndex = this.freeColClient.getClientOptions().getInteger("model.option.color.background");
        Color newBackground = MiniMapChangeBackgroundAction.interpretIndex(colorIndex);
        this.setBackgroundColor(newBackground);
        this.scaledFactorX = 1.0f;
        this.scaledFactorY = 1.0f;
        this.scaledOffsetX = 0;
        this.scaledOffsetY = 1;
        if (skin == null) {
            this.paintMap(graphics, 0, 0, this.getWidth(), this.getHeight());
        } else {
            if (!this.scaleMap) {
                this.paintMap(graphics, this.mapX, this.mapY, 220, 128);
            } else {
                graphics.setColor(this.backgroundColor);
                graphics.fillRect(this.mapX, this.mapY, 220, 128);
                int realMapWidth = this.freeColClient.getGame().getMap().getWidth();
                int realMapHeight = this.freeColClient.getGame().getMap().getHeight();
                BufferedImage bi = new BufferedImage(realMapWidth * 4, realMapHeight, 2);
                this.paintMap(bi.createGraphics(), 0, 0, realMapWidth * 4, realMapHeight);
                int scaledWidth = 220;
                int scaledHeight = 128;
                if (realMapWidth * 4 > realMapHeight * 2) {
                    scaledHeight = 220 * realMapHeight / (realMapWidth * 4);
                } else {
                    scaledWidth = 128 * realMapWidth * 4 / realMapHeight;
                }
                this.scaledOffsetX = (220 - scaledWidth) / 2;
                this.scaledOffsetY = (128 - scaledHeight) / 2;
                this.scaledFactorX = (float)(realMapWidth * 4) / (float)scaledWidth;
                this.scaledFactorY = (float)realMapHeight / (float)scaledHeight;
                int scalingHint = this.freeColClient.getClientOptions().getBoolean("model.option.smoothRendering") ? 4 : 2;
                Image image = bi.getScaledInstance(scaledWidth, scaledHeight, scalingHint);
                graphics.drawImage(image, this.mapX + this.scaledOffsetX, this.mapY + this.scaledOffsetY, null);
            }
            this.paintSkin(graphics, skin);
        }
    }

    private void paintSkin(Graphics graphics, Image skin) {
        graphics.drawImage(skin, 0, 0, null);
    }

    private void paintMap(Graphics graphics, int x, int y, int width, int height) {
        Graphics2D g = (Graphics2D)graphics;
        Map map = this.freeColClient.getGame().getMap();
        ImageLibrary imageProvider = this.freeColClient.getGUI().getImageLibrary();
        g.setColor(Color.BLACK);
        g.fillRect(x, y, width, height);
        if (this.freeColClient.getGUI() == null || this.freeColClient.getGUI().getFocus() == null) {
            return;
        }
        int xSize = width / this.tileSize;
        int ySize = height / this.tileSize * 4;
        this.xOffset = this.freeColClient.getGUI().getFocus().getX() - xSize / 2;
        this.yOffset = this.freeColClient.getGUI().getFocus().getY() - ySize / 2;
        if (this.xOffset < 0) {
            this.xOffset = 0;
        } else if (this.xOffset + xSize + 1 > map.getWidth()) {
            this.xOffset = map.getWidth() - xSize - 1;
        }
        if (this.yOffset < 0) {
            this.yOffset = 0;
        } else if (this.yOffset + ySize + 1 > map.getHeight()) {
            this.yOffset = map.getHeight() - ySize - 1;
        }
        if (map.getWidth() <= xSize) {
            this.xOffset = 0;
            this.adjustX = (xSize - map.getWidth()) * this.tileSize / 2;
            width = map.getWidth() * this.tileSize;
            x += this.adjustX;
        } else {
            this.adjustX = 0;
        }
        if (map.getHeight() <= ySize) {
            this.yOffset = 0;
            this.adjustY = (ySize - map.getHeight()) * this.tileSize / 8;
            height = map.getHeight() * (this.tileSize / 4);
            y += this.adjustY;
        } else {
            this.adjustY = 0;
        }
        int[] xPoints = new int[4];
        int[] yPoints = new int[4];
        int tileX = 0;
        for (int xPixels = 0; xPixels <= width + this.tileSize; xPixels += this.tileSize) {
            int tileY = 0;
            for (int yPixels = 0; yPixels <= height + this.tileSize; yPixels += this.tileSize / 4) {
                Tile tile = map.getTile(tileX + this.xOffset, tileY + this.yOffset);
                if (tile != null) {
                    Settlement settlement = tile.getSettlement();
                    int units = tile.getUnitCount();
                    g.setColor(Color.BLACK);
                    if (tile.isExplored()) {
                        g.setColor(tile.getType().getMinimapColor());
                    }
                    if (this.tileSize == 4) {
                        int extra = (tileY + this.yOffset) % 2 == 0 ? 0 : 2;
                        g.drawLine(x + extra + 4 * tileX, y + tileY, x + 2 + extra + 4 * tileX, y + tileY);
                        g.drawLine(x + extra + 1 + 4 * tileX, y + 1 + tileY, x + extra + 1 + 4 * tileX, y + 1 + tileY);
                        if (settlement != null) {
                            g.setColor(settlement.getOwner().getColor());
                            g.drawLine(x + extra + 4 * tileX + 1, y + tileY, x + extra + 4 * tileX + 1, y + tileY);
                        } else if (units > 0) {
                            g.setColor(tile.getFirstUnit().getOwner().getColor());
                            g.drawLine(x + extra + 4 * tileX + 1, y + tileY, x + extra + 4 * tileX + 1, y + tileY);
                        }
                    } else {
                        if ((tileY + this.yOffset) % 2 == 0) {
                            xPoints[0] = x + tileX * this.tileSize - this.tileSize / 2;
                            xPoints[1] = x + tileX * this.tileSize;
                            xPoints[2] = x + tileX * this.tileSize + this.tileSize / 2;
                            xPoints[3] = xPoints[1];
                        } else {
                            xPoints[0] = x + tileX * this.tileSize;
                            xPoints[1] = x + tileX * this.tileSize + this.tileSize / 2;
                            xPoints[2] = x + tileX * this.tileSize + this.tileSize;
                            xPoints[3] = xPoints[1];
                        }
                        yPoints[0] = y + tileY * this.tileSize / 4;
                        yPoints[1] = y + tileY * this.tileSize / 4 - this.tileSize / 4;
                        yPoints[3] = y + tileY * this.tileSize / 4 + this.tileSize / 4;
                        yPoints[2] = yPoints[0];
                        g.fillPolygon(xPoints, yPoints, 4);
                        if (settlement != null) {
                            xPoints[0] = xPoints[0] + this.tileSize / 8;
                            xPoints[2] = xPoints[2] - this.tileSize / 8;
                            yPoints[1] = yPoints[1] + this.tileSize / 16;
                            yPoints[3] = yPoints[3] - this.tileSize / 16;
                            g.setColor(settlement.getOwner().getColor());
                            g.fillPolygon(xPoints, yPoints, 4);
                            g.setColor(Color.BLACK);
                            g.drawPolygon(xPoints, yPoints, 4);
                        } else if (units > 0) {
                            xPoints[0] = xPoints[0] + this.tileSize / 4;
                            xPoints[2] = xPoints[2] - this.tileSize / 4;
                            yPoints[1] = yPoints[1] + this.tileSize / 8;
                            yPoints[3] = yPoints[3] - this.tileSize / 8;
                            g.setColor(tile.getFirstUnit().getOwner().getColor());
                            g.fillPolygon(xPoints, yPoints, 4);
                            g.setColor(Color.BLACK);
                            g.drawPolygon(xPoints, yPoints, 4);
                        }
                    }
                }
                ++tileY;
            }
            ++tileX;
        }
        TileType tileType = FreeCol.getSpecification().getTileTypeList().get(0);
        int miniRectX = (this.freeColClient.getGUI().getFocus().getX() - this.xOffset) * this.tileSize;
        int miniRectY = (this.freeColClient.getGUI().getFocus().getY() - this.yOffset) * this.tileSize / 4;
        int miniRectWidth = (this.getParent().getWidth() / ((ImageProvider)imageProvider).getTerrainImageWidth(tileType) + 1) * this.tileSize;
        int miniRectHeight = (this.getParent().getHeight() / ((ImageProvider)imageProvider).getTerrainImageHeight(tileType) + 1) * this.tileSize / 2;
        if (miniRectX + miniRectWidth / 2 > width) {
            miniRectX = width - miniRectWidth / 2 - 1;
        } else if (miniRectX - miniRectWidth / 2 < 0) {
            miniRectX = miniRectWidth / 2;
        }
        if (miniRectY + miniRectHeight / 2 > height) {
            miniRectY = height - miniRectHeight / 2 - 1;
        } else if (miniRectY - miniRectHeight / 2 < 0) {
            miniRectY = miniRectHeight / 2;
        }
        g.setColor(Color.WHITE);
        int miniRectMaxX = Math.max((miniRectX += x) - miniRectWidth / 2, x);
        int miniRectMaxY = Math.max((miniRectY += y) - miniRectHeight / 2, y);
        int miniRectMinWidth = Math.min(miniRectWidth, width - 1);
        int miniRectMinHeight = Math.min(miniRectHeight, height - 1);
        if (miniRectMaxX + miniRectMinWidth > x + width - 1) {
            miniRectMaxX = x + width - miniRectMinWidth - 1;
        }
        if (miniRectMaxY + miniRectMinHeight > y + height - 1) {
            miniRectMaxY = y + height - miniRectMinHeight - 1;
        }
        g.drawRect(miniRectMaxX, miniRectMaxY, miniRectMinWidth, miniRectMinHeight);
        if (this.scaleMap) {
            g.drawRect(miniRectX - miniRectWidth / 2 + 1, miniRectY - miniRectHeight / 2 + 1, miniRectWidth - 2, miniRectHeight - 2);
        }
        if (this.adjustX > 0 && this.adjustY > 0) {
            g.setColor(Color.WHITE);
            g.drawRect(x, y, width - 1, height - 1);
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (!e.getComponent().isEnabled() || !this.isInMap(e.getX(), e.getY())) {
            return;
        }
        this.initialX = this.xOffset;
        this.initialY = this.yOffset;
        int x = (int)((float)(e.getX() - this.mapX - this.scaledOffsetX) * this.scaledFactorX);
        int y = (int)((float)(e.getY() - this.mapY - this.scaledOffsetY) * this.scaledFactorY);
        int tileX = (x - this.adjustX) / this.tileSize + this.initialX;
        int tileY = (y - this.adjustY) / this.tileSize * 4 + this.initialY;
        this.freeColClient.getGUI().setFocus(tileX, tileY);
    }

    private boolean isInMap(int x, int y) {
        return x >= this.mapX && x < this.mapX + 220 && y >= this.mapY && y < this.mapY + 128;
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        if (!e.getComponent().isEnabled() || !this.isInMap(e.getX(), e.getY())) {
            return;
        }
        int x = (int)((float)(e.getX() - this.mapX - this.scaledOffsetX) * this.scaledFactorX);
        int y = (int)((float)(e.getY() - this.mapY - this.scaledOffsetY) * this.scaledFactorY);
        int tileX = (x - this.adjustX) / this.tileSize + this.initialX;
        int tileY = (y - this.adjustY) / this.tileSize * 4 + this.initialY;
        this.freeColClient.getGUI().setFocus(tileX, tileY);
    }

    public void mouseMoved(MouseEvent e) {
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }
}

