/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import cz.autel.dmi.HIGLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.common.model.Monarch;
import net.sf.freecol.common.model.Nation;

public final class MonarchPanel
extends FreeColDialog
implements ActionListener {
    private static final Logger logger = Logger.getLogger(MonarchPanel.class.getName());
    private static final int OK = 0;
    private static final int CANCEL = 1;
    private final Canvas parent;
    private final JLabel header;
    private final JLabel imageLabel;
    private JTextArea textArea;
    private final JButton okButton;
    private final JButton cancelButton;

    public MonarchPanel(Canvas parent) {
        this.parent = parent;
        this.header = new JLabel("", 0);
        this.header.setFont(mediumHeaderFont);
        this.header.setText(Messages.message("aMessageFromTheCrown", new String[0]));
        this.header.setAlignmentX(0.5f);
        this.imageLabel = new JLabel();
        this.okButton = new JButton(Messages.message("ok", new String[0]));
        this.okButton.setActionCommand(String.valueOf(0));
        this.okButton.addActionListener(this);
        this.okButton.setAlignmentX(0.5f);
        this.cancelButton = new JButton();
        this.cancelButton.setActionCommand(String.valueOf(1));
        this.cancelButton.addActionListener(this);
        this.cancelButton.setAlignmentX(0.5f);
    }

    public void requestFocus() {
        this.okButton.requestFocus();
    }

    public void initialize(Monarch.MonarchAction action, String ... replace) {
        String messageID;
        this.removeAll();
        Nation nation = this.parent.getClient().getMyPlayer().getNation();
        this.imageLabel.setIcon(this.parent.getGUI().getImageLibrary().getMonarchImageIcon(nation));
        int[] widths = new int[]{-3, 9, -1};
        int[] heights = new int[]{0, 3, 0, 3, 0};
        this.setLayout(new HIGLayout(widths, heights));
        int row = 1;
        int imageColumn = 1;
        int textColumn = 3;
        this.add((Component)this.header, higConst.rcwh(row, imageColumn, widths.length, 1));
        this.add((Component)this.imageLabel, higConst.rc(row += 2, imageColumn, "r"));
        String okText = "ok";
        String cancelText = null;
        switch (action) {
            case RAISE_TAX: {
                messageID = "model.monarch.raiseTax";
                okText = "model.monarch.acceptTax";
                cancelText = "model.monarch.rejectTax";
                break;
            }
            case ADD_TO_REF: {
                messageID = "model.monarch.addToREF";
                break;
            }
            case DECLARE_WAR: {
                messageID = "model.monarch.declareWar";
                break;
            }
            case SUPPORT_SEA: {
                messageID = "model.monarch.supportSea";
                cancelText = "display";
                break;
            }
            case SUPPORT_LAND: {
                messageID = "model.monarch.supportLand";
                cancelText = "display";
                break;
            }
            case LOWER_TAX: {
                messageID = "model.monarch.lowerTax";
                break;
            }
            case WAIVE_TAX: {
                messageID = "model.monarch.waiveTax";
                break;
            }
            case OFFER_MERCENARIES: {
                messageID = "model.monarch.offerMercenaries";
                okText = "model.monarch.acceptMercenaries";
                cancelText = "model.monarch.rejectMercenaries";
                break;
            }
            default: {
                messageID = "Unknown monarch action: " + (Object)((Object)action);
            }
        }
        this.textArea = MonarchPanel.getDefaultTextArea(Messages.message(messageID, replace));
        this.add((Component)this.textArea, higConst.rc(row, textColumn));
        row += 2;
        this.okButton.setText(Messages.message(okText, new String[0]));
        if (cancelText == null) {
            this.add((Component)this.okButton, higConst.rcwh(row, imageColumn, widths.length, 1, ""));
        } else {
            this.cancelButton.setText(Messages.message(cancelText, new String[0]));
            this.add((Component)this.okButton, higConst.rc(row, imageColumn, "r"));
            this.add((Component)this.cancelButton, higConst.rc(row, textColumn, "l"));
        }
        this.setSize(this.getPreferredSize());
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        try {
            switch (Integer.valueOf(command)) {
                case 0: {
                    this.setResponse(new Boolean(true));
                    break;
                }
                case 1: {
                    this.setResponse(new Boolean(false));
                    break;
                }
                default: {
                    logger.warning("Invalid Actioncommand: invalid number.");
                    break;
                }
            }
        }
        catch (NumberFormatException e) {
            logger.warning("Invalid Actioncommand: not a number.");
        }
    }
}

