/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NationCellRenderer
implements TableCellRenderer {
    private final Nation[] nations;
    private final JComboBox comboBox;
    private List<Player> players;
    private Player thisPlayer;

    public NationCellRenderer(Nation[] nations) {
        this.nations = nations;
        this.comboBox = new JComboBox<Nation>(nations);
    }

    public void setData(List<Player> players, Player owningPlayer) {
        this.players = players;
        this.thisPlayer = owningPlayer;
    }

    private Player getPlayer(int i) {
        if (i == 0) {
            return this.thisPlayer;
        }
        if (this.players.get(i) == this.thisPlayer) {
            return this.players.get(0);
        }
        return this.players.get(i);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JComponent component;
        Player player = this.getPlayer(row);
        if (player == this.thisPlayer) {
            for (int index = 0; index < this.nations.length; ++index) {
                if (!this.nations[index].getId().equals(player.getNationID())) continue;
                this.comboBox.setSelectedIndex(index);
                break;
            }
            component = this.comboBox;
        } else {
            component = new JLabel(player.getNationAsString());
        }
        if (player.isReady()) {
            ((Component)component).setForeground(Color.GRAY);
        } else {
            ((Component)component).setForeground(table.getForeground());
        }
        ((Component)component).setBackground(table.getBackground());
        return component;
    }
}

