/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import cz.autel.dmi.HIGLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.control.ConnectController;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.common.ServerInfo;

public final class NewPanel
extends FreeColPanel
implements ActionListener {
    private static final Logger logger = Logger.getLogger(NewPanel.class.getName());
    private static final int CLASSIC_PLAYER_NO = 4;
    private static final int OK = 0;
    private static final int CANCEL = 1;
    private static final int SINGLE = 2;
    private static final int JOIN = 3;
    private static final int START = 4;
    private static final int META_SERVER = 5;
    private final JTextField server;
    private final JTextField port1;
    private final JTextField port2;
    private final JTextField name;
    private final JRadioButton single;
    private final JRadioButton join;
    private final JRadioButton start;
    private final JRadioButton meta;
    private final JLabel ipLabel;
    private final JLabel port1Label;
    private final JLabel port2Label;
    private final JLabel singlePlayerNoLabel;
    private final JLabel multiPlayerNoLabel;
    private final JCheckBox publicServer;
    private final JCheckBox additionalNations;
    private final JCheckBox selectAdvantages;
    private final JCheckBox useAdvantages;
    private final JSpinner singlePlayerNo;
    private final JSpinner multiPlayerNo;
    private final Canvas parent;
    private final ConnectController connectController;
    private JButton ok = new JButton(Messages.message("ok", new String[0]));

    public NewPanel(Canvas parent) {
        this.parent = parent;
        this.connectController = parent.getClient().getConnectController();
        JButton cancel = new JButton(Messages.message("cancel", new String[0]));
        ButtonGroup group = new ButtonGroup();
        JLabel nameLabel = new JLabel(Messages.message("name", new String[0]));
        this.setCancelComponent(cancel);
        this.ipLabel = new JLabel(Messages.message("host", new String[0]));
        this.port1Label = new JLabel(Messages.message("port", new String[0]));
        this.port2Label = new JLabel(Messages.message("startServerOnPort", new String[0]));
        this.singlePlayerNoLabel = new JLabel(Messages.message("singlePlayerNo", new String[0]));
        this.multiPlayerNoLabel = new JLabel(Messages.message("multiPlayerNo", new String[0]));
        this.publicServer = new JCheckBox(Messages.message("publicServer", new String[0]));
        this.additionalNations = new JCheckBox(Messages.message("additionalNations", new String[0]));
        this.additionalNations.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                int players;
                if (!NewPanel.this.additionalNations.isSelected() && (players = ((Integer)NewPanel.this.singlePlayerNo.getValue()).intValue()) > 4) {
                    NewPanel.this.singlePlayerNo.setValue(4);
                }
            }
        });
        this.selectAdvantages = new JCheckBox(Messages.message("selectAdvantages", new String[0]));
        this.useAdvantages = new JCheckBox(Messages.message("useAdvantages", new String[0]));
        this.singlePlayerNo = new JSpinner(new SpinnerNumberModel(4, 1, 8, 1));
        this.singlePlayerNo.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                int players = (Integer)NewPanel.this.singlePlayerNo.getValue();
                if (players > 4) {
                    NewPanel.this.additionalNations.setSelected(true);
                }
            }
        });
        this.multiPlayerNo = new JSpinner(new SpinnerNumberModel(4, 2, 8, 1));
        this.name = new JTextField(System.getProperty("user.name", Messages.message("defaultPlayerName", new String[0])));
        this.name.setColumns(20);
        this.server = new JTextField("127.0.0.1");
        this.port1 = new JTextField(new Integer(FreeCol.getDefaultPort()).toString());
        this.port2 = new JTextField(new Integer(FreeCol.getDefaultPort()).toString());
        this.single = new JRadioButton(Messages.message("singlePlayerGame", new String[0]), true);
        this.join = new JRadioButton(Messages.message("joinMultiPlayerGame", new String[0]), false);
        this.start = new JRadioButton(Messages.message("startMultiplayerGame", new String[0]), false);
        this.meta = new JRadioButton(Messages.message("getServerList", new String[0]) + " (" + "meta.freecol.org" + ")", false);
        group.add(this.single);
        group.add(this.join);
        group.add(this.start);
        group.add(this.meta);
        int numberOfRows = 13;
        int[] widths = new int[]{21, 0, 3, 0, 3, 0, 3, 0, 18, 0};
        int[] heights = new int[2 * numberOfRows - 1];
        for (int index = 1; index < heights.length; index += 2) {
            heights[index] = 3;
        }
        heights[heights.length - 2] = 9;
        this.setLayout(new HIGLayout(widths, heights));
        int row = 1;
        this.add((Component)nameLabel, higConst.rc(row, 8, "r"));
        this.add((Component)this.name, higConst.rc(row, 10));
        this.add((Component)this.single, higConst.rcwh(row += 2, 1, 8, 1, "l"));
        this.add((Component)this.additionalNations, higConst.rcwh(row += 2, 2, 3, 1, "l"));
        this.add((Component)this.selectAdvantages, higConst.rcwh(row += 2, 2, 3, 1, "l"));
        this.add((Component)this.singlePlayerNoLabel, higConst.rcwh(row += 2, 2, 3, 1, "l"));
        this.add((Component)this.singlePlayerNo, higConst.rc(row, 8));
        this.add((Component)this.meta, higConst.rcwh(row += 2, 1, 8, 1, "l"));
        this.add((Component)this.join, higConst.rcwh(row += 2, 1, 8, 1, "l"));
        this.add((Component)this.ipLabel, higConst.rc(row += 2, 2));
        this.add((Component)this.server, higConst.rc(row, 4));
        this.add((Component)this.port1Label, higConst.rc(row, 6));
        this.add((Component)this.port1, higConst.rc(row, 8));
        this.add((Component)this.start, higConst.rcwh(row += 2, 1, 8, 1, "l"));
        this.add((Component)this.port2Label, higConst.rcwh(row += 2, 2, 3, 1, "l"));
        this.add((Component)this.port2, higConst.rc(row, 8));
        this.add((Component)this.publicServer, higConst.rc(row, 10, "l"));
        this.add((Component)this.multiPlayerNoLabel, higConst.rcwh(row += 2, 2, 3, 1, "l"));
        this.add((Component)this.multiPlayerNo, higConst.rc(row, 8));
        this.add((Component)this.useAdvantages, higConst.rc(row, 10, "l"));
        this.add((Component)this.ok, higConst.rc(row += 2, 8, "r"));
        this.add((Component)cancel, higConst.rc(row, 10, "l"));
        this.ok.setActionCommand(String.valueOf(0));
        cancel.setActionCommand(String.valueOf(1));
        this.single.setActionCommand(String.valueOf(2));
        this.join.setActionCommand(String.valueOf(3));
        this.start.setActionCommand(String.valueOf(4));
        this.meta.setActionCommand(String.valueOf(5));
        this.ok.addActionListener(this);
        cancel.addActionListener(this);
        this.single.addActionListener(this);
        this.join.addActionListener(this);
        this.start.addActionListener(this);
        this.meta.addActionListener(this);
        this.single.setSelected(true);
        this.setEnabledComponents();
        this.setSize(this.getPreferredSize());
    }

    public void requestFocus() {
        this.ok.requestFocus();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        Component[] components = this.getComponents();
        for (int i = 0; i < components.length; ++i) {
            components[i].setEnabled(enabled);
        }
        this.setEnabledComponents();
    }

    private void setEnabledComponents() {
        if (this.single.isSelected()) {
            this.setSinglePlayerOptions(true);
            this.setJoinGameOptions(false);
            this.setServerOptions(false);
        } else if (this.join.isSelected()) {
            this.setSinglePlayerOptions(false);
            this.setJoinGameOptions(true);
            this.setServerOptions(false);
        } else if (this.start.isSelected()) {
            this.setSinglePlayerOptions(false);
            this.setJoinGameOptions(false);
            this.setServerOptions(true);
        } else if (this.meta.isSelected()) {
            this.setSinglePlayerOptions(false);
            this.setJoinGameOptions(false);
            this.setServerOptions(false);
        }
    }

    private void setSinglePlayerOptions(boolean enabled) {
        this.additionalNations.setEnabled(enabled);
        this.selectAdvantages.setEnabled(enabled);
        this.singlePlayerNoLabel.setEnabled(enabled);
        this.singlePlayerNo.setEnabled(enabled);
    }

    private void setJoinGameOptions(boolean enabled) {
        this.ipLabel.setEnabled(enabled);
        this.server.setEnabled(enabled);
        this.port1Label.setEnabled(enabled);
        this.port1.setEnabled(enabled);
    }

    private void setServerOptions(boolean enabled) {
        this.port2Label.setEnabled(enabled);
        this.port2.setEnabled(enabled);
        this.publicServer.setEnabled(enabled);
        this.multiPlayerNoLabel.setEnabled(enabled);
        this.multiPlayerNo.setEnabled(enabled);
        this.useAdvantages.setEnabled(enabled);
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        try {
            switch (Integer.valueOf(command)) {
                case 0: {
                    ArrayList<ServerInfo> serverList;
                    if (this.single.isSelected()) {
                        int players = (Integer)this.singlePlayerNo.getValue();
                        int advantages = 1;
                        if (this.selectAdvantages.isSelected()) {
                            advantages = 2;
                        }
                        this.connectController.startSingleplayerGame(this.name.getText(), players, this.additionalNations.isSelected(), advantages);
                        break;
                    }
                    if (this.join.isSelected()) {
                        int port;
                        try {
                            port = Integer.valueOf(this.port1.getText());
                        }
                        catch (NumberFormatException e) {
                            this.port1Label.setForeground(Color.red);
                            break;
                        }
                        this.connectController.joinMultiplayerGame(this.name.getText(), this.server.getText(), port);
                        break;
                    }
                    if (this.start.isSelected()) {
                        int port;
                        try {
                            port = Integer.valueOf(this.port2.getText());
                        }
                        catch (NumberFormatException e) {
                            this.port2Label.setForeground(Color.red);
                            break;
                        }
                        int players = (Integer)this.singlePlayerNo.getValue();
                        int advantages = 0;
                        if (this.useAdvantages.isSelected()) {
                            advantages = 2;
                        }
                        this.connectController.startMultiplayerGame(this.publicServer.isSelected(), this.name.getText(), port, players, advantages);
                        break;
                    }
                    if (this.meta.isSelected() && (serverList = this.connectController.getServerList()) != null) {
                        this.parent.showServerListPanel(this.name.getText(), serverList);
                    }
                    break;
                }
                case 1: {
                    this.parent.remove(this);
                    this.parent.showMainPanel();
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    this.setEnabledComponents();
                    break;
                }
                default: {
                    logger.warning("Invalid Actioncommand: invalid number.");
                }
            }
        }
        catch (NumberFormatException e) {
            logger.warning("Invalid Actioncommand: not a number.");
        }
    }
}

