/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.PreGameController;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.NationType;
import net.sf.freecol.common.model.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PlayersTableModel
extends AbstractTableModel {
    private FreeColClient freeColClient;
    private List<Player> players;
    private Player thisPlayer;
    private final PreGameController preGameController;
    private int advantages;
    private static final String[] columnNames = new String[]{Messages.message("player", new String[0]), Messages.message("nation", new String[0]), Messages.message("advantage", new String[0]), Messages.message("color", new String[0])};

    public PlayersTableModel(FreeColClient freeColClient, PreGameController pgc) {
        this.freeColClient = freeColClient;
        this.players = new ArrayList<Player>();
        this.thisPlayer = null;
        this.preGameController = pgc;
    }

    public void setData(List<Player> myPlayers, Player owningPlayer, int advantages) {
        this.players = myPlayers;
        this.thisPlayer = owningPlayer;
        this.advantages = advantages;
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return this.getValueAt(0, column).getClass();
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public String getColumnName(int column) {
        return columnNames[column];
    }

    @Override
    public int getRowCount() {
        return this.players.size();
    }

    private Player getPlayer(int i) {
        if (i == 0) {
            return this.thisPlayer;
        }
        if (this.players.get(i) == this.thisPlayer) {
            return this.players.get(0);
        }
        return this.players.get(i);
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (row < this.getRowCount() && column < this.getColumnCount() && row >= 0 && column >= 0) {
            Player player = this.getPlayer(row);
            switch (column) {
                case 0: {
                    return player.getName();
                }
                case 1: {
                    return new Integer(player.getIndex());
                }
                case 3: {
                    return player.getColor();
                }
                case 2: {
                    return player.getNationType();
                }
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column > 0 && column < columnNames.length && this.players.size() > 0 && row >= 0 && this.thisPlayer == this.getPlayer(row) && !this.thisPlayer.isReady();
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        if (row < this.getRowCount() && column < this.getColumnCount() && row >= 0 && column >= 0) {
            if (column == 1) {
                Nation nation = (Nation)value;
                this.preGameController.setNation(nation);
                this.preGameController.setColor(nation.getColor());
                this.fireTableCellUpdated(row, 3);
                if (this.advantages == 1) {
                    this.preGameController.setNationType(nation.getType());
                    this.fireTableCellUpdated(row, 2);
                }
            } else if (column == 3) {
                this.preGameController.setColor((Color)value);
            } else if (column == 2) {
                this.preGameController.setNationType((NationType)value);
            }
            this.fireTableCellUpdated(row, column);
        }
    }
}

