/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import cz.autel.dmi.HIGLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.client.gui.panel.UnitLabel;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.FeatureContainer;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Unit;

public class PreCombatDialog
extends FreeColDialog {
    public static final Modifier BASE_DEFENCE_MODIFIER = new Modifier("modifiers.baseDefence", Float.MIN_VALUE, Modifier.Type.ADDITIVE);

    public PreCombatDialog(Unit attacker, Unit defender, Settlement settlement, Canvas parent) {
        String defenderName;
        Set<Object> defence;
        CombatModel combatModel = attacker.getGame().getCombatModel();
        Set<Modifier> offence = this.sortModifiers(combatModel.getOffensiveModifiers(attacker, defender));
        if (defender == null && settlement != null) {
            defence = new LinkedHashSet<Modifier>();
            defence.add(BASE_DEFENCE_MODIFIER);
            defence.addAll(this.sortModifiers(settlement.getFeatureContainer().getModifierSet("model.modifier.defence", attacker.getType())));
        } else {
            defence = this.sortModifiers(combatModel.getDefensiveModifiers(attacker, defender));
        }
        int numberOfModifiers = Math.max(offence.size(), defence.size());
        int extraRows = 4;
        int numberOfRows = 2 * (numberOfModifiers + extraRows) - 1;
        int[] widths = new int[]{-6, 20, -8, 0, 40, -1, 20, -3, 0};
        int[] heights = new int[numberOfRows];
        int offenceLabelColumn = 1;
        int offenceValueColumn = 3;
        int offencePercentageColumn = 4;
        int defenceLabelColumn = 6;
        int defenceValueColumn = 8;
        int defencePercentageColumn = 9;
        for (int index = 1; index < numberOfRows; index += 2) {
            heights[index] = 3;
        }
        JButton okButton = new JButton();
        AbstractAction okAction = new AbstractAction(Messages.message("ok", new String[0])){

            public void actionPerformed(ActionEvent event) {
                PreCombatDialog.this.setResponse(Boolean.TRUE);
            }
        };
        okButton.setAction(okAction);
        okButton.requestFocus();
        AbstractAction cancelAction = new AbstractAction(Messages.message("cancel", new String[0])){

            public void actionPerformed(ActionEvent event) {
                PreCombatDialog.this.setResponse(Boolean.FALSE);
            }
        };
        JButton cancelButton = new JButton(cancelAction);
        PreCombatDialog.enterPressesWhenFocused(okButton);
        PreCombatDialog.enterPressesWhenFocused(cancelButton);
        this.setLayout(new HIGLayout(widths, heights));
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                PreCombatDialog.this.setResponse(false);
            }
        });
        int row = 1;
        String attackerName = Messages.message("model.unit.nationUnit", "%nation%", attacker.getOwner().getNationAsString(), "%unit%", attacker.getName());
        this.add((Component)new JLabel(attackerName), higConst.rc(row, offenceLabelColumn));
        this.add((Component)new UnitLabel(attacker, parent, false, true), higConst.rcwh(row += 2, offenceLabelColumn, 3, 1));
        row += 2;
        for (Modifier modifier : offence) {
            FreeColGameObjectType freeColGameObjectType = modifier.getSource();
            String sourceName = freeColGameObjectType == null ? "???" : freeColGameObjectType.getName();
            this.add((Component)new JLabel(sourceName), higConst.rc(row, offenceLabelColumn));
            String bonus = PreCombatDialog.getModifierFormat().format(modifier.getValue());
            switch (modifier.getType()) {
                case ADDITIVE: {
                    if (!(modifier.getValue() > 0.0f)) break;
                    bonus = "+" + bonus;
                    break;
                }
                case PERCENTAGE: {
                    if (modifier.getValue() > 0.0f) {
                        bonus = "+" + bonus;
                    }
                    this.add((Component)new JLabel("%"), higConst.rc(row, offencePercentageColumn));
                    break;
                }
                case MULTIPLICATIVE: {
                    bonus = "\u00d7" + bonus;
                    break;
                }
            }
            this.add((Component)new JLabel(bonus), higConst.rc(row, offenceValueColumn, "r"));
            row += 2;
        }
        int finalResultRow = row;
        row = 1;
        if (defender != null) {
            defenderName = Messages.message("model.unit.nationUnit", "%nation%", defender.getOwner().getNationAsString(), "%unit%", defender.getName());
            this.add((Component)new JLabel(defenderName), higConst.rc(row, defenceLabelColumn));
            this.add((Component)new UnitLabel(defender, parent, false, true), higConst.rcwh(row += 2, defenceLabelColumn, 3, 1));
            row += 2;
        } else {
            defenderName = settlement instanceof Colony ? ((Colony)settlement).getName() : Messages.message("indianSettlement", "%nation%", settlement.getOwner().getNationAsString());
            this.add((Component)new JLabel(defenderName), higConst.rc(row, defenceLabelColumn));
            this.add((Component)new JLabel(parent.getImageIcon(settlement, false)), higConst.rcwh(row += 2, defenceLabelColumn, 3, 1));
            row += 2;
        }
        for (Modifier modifier : defence) {
            FreeColGameObjectType source = modifier.getSource();
            String sourceString = null;
            sourceString = source == null ? "???" : Messages.message(source.getName(), new String[0]);
            this.add((Component)new JLabel(sourceString), higConst.rc(row, defenceLabelColumn));
            String bonus = PreCombatDialog.getModifierFormat().format(modifier.getValue());
            if (modifier.getValue() == Float.MIN_VALUE) {
                bonus = "???";
            }
            switch (modifier.getType()) {
                case ADDITIVE: {
                    if (!(modifier.getValue() > 0.0f)) break;
                    bonus = "+" + bonus;
                    break;
                }
                case PERCENTAGE: {
                    if (modifier.getValue() > 0.0f) {
                        bonus = "+" + bonus;
                    }
                    this.add((Component)new JLabel("%"), higConst.rc(row, defencePercentageColumn));
                    break;
                }
                case MULTIPLICATIVE: {
                    bonus = "\u00d7" + bonus;
                    break;
                }
            }
            this.add((Component)new JLabel(bonus), higConst.rc(row, defenceValueColumn, "r"));
            row += 2;
        }
        if (row < finalResultRow) {
            row = finalResultRow;
        }
        Font bigFont = this.getFont().deriveFont(1, 20.0f);
        float f = FeatureContainer.applyModifierSet(0.0f, attacker.getGame().getTurn(), offence);
        JLabel finalOffenceLabel = new JLabel(Messages.message("modifiers.finalResult.name", new String[0]));
        finalOffenceLabel.setFont(bigFont);
        this.add((Component)finalOffenceLabel, higConst.rc(row, offenceLabelColumn));
        JLabel finalOffenceResult = new JLabel(PreCombatDialog.getModifierFormat().format(f));
        finalOffenceResult.setFont(bigFont);
        this.add((Component)finalOffenceResult, higConst.rc(row, offenceValueColumn, "r"));
        float defenceResult = FeatureContainer.applyModifierSet(0.0f, attacker.getGame().getTurn(), defence);
        JLabel finalDefenceLabel = new JLabel(Messages.message("modifiers.finalResult.name", new String[0]));
        finalDefenceLabel.setFont(bigFont);
        this.add((Component)finalDefenceLabel, higConst.rc(row, defenceLabelColumn));
        JLabel finalDefenceResult = new JLabel(PreCombatDialog.getModifierFormat().format(defenceResult));
        if (defenceResult == Float.MIN_VALUE) {
            finalDefenceResult.setText("???");
        }
        finalDefenceResult.setFont(bigFont);
        this.add((Component)finalDefenceResult, higConst.rc(row, defenceValueColumn, "r"));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setOpaque(false);
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        this.add((Component)buttonPanel, higConst.rcwh(heights.length, 1, widths.length, 1));
        this.setSize(this.getPreferredSize());
    }
}

