/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import net.sf.freecol.client.ClientOptions;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;

public final class ProductionLabel
extends JComponent {
    private static Logger logger = Logger.getLogger(ProductionLabel.class.getName());
    private final Canvas parent;
    private int maxIcons = 7;
    private boolean drawPlus = false;
    private boolean centered = true;
    private int compressedWidth = -1;
    private GoodsType goodsType;
    private ImageIcon goodsIcon;
    private int production;
    private int maximumProduction = -1;
    private int displayNumber;
    private int stockNumber = -1;

    public ProductionLabel(Goods goods, Canvas parent) {
        this(goods.getType(), goods.getAmount(), -1, parent);
    }

    public ProductionLabel(GoodsType goodsType, int amount, Canvas parent) {
        this(goodsType, amount, -1, parent);
    }

    public ProductionLabel(GoodsType goodsType, int amount, int maximumProduction, Canvas parent) {
        this.parent = parent;
        this.production = amount;
        this.goodsType = goodsType;
        this.maximumProduction = maximumProduction;
        ClientOptions options = parent.getClient().getClientOptions();
        this.maxIcons = options.getInteger("model.option.guiMaxNumberOfGoodsImages");
        this.displayNumber = options.getInteger("model.option.guiMinNumberToDisplayGoodsCount");
        this.setFont(new Font("Dialog", 1, 12));
        if (amount < 0) {
            this.setForeground(Color.RED);
        } else {
            this.setForeground(Color.WHITE);
        }
        if (goodsType != null) {
            this.setGoodsIcon(parent.getGUI().getImageLibrary().getGoodsImageIcon(goodsType));
            this.setToolTipText(String.valueOf(amount) + " " + goodsType.getName());
        }
    }

    public Canvas getCanvas() {
        return this.parent;
    }

    public int getDisplayNumber() {
        return this.displayNumber;
    }

    public void setDisplayNumber(int newDisplayNumber) {
        this.displayNumber = newDisplayNumber;
    }

    public ImageIcon getGoodsIcon() {
        return this.goodsIcon;
    }

    public void setGoodsIcon(ImageIcon newGoodsIcon) {
        this.goodsIcon = newGoodsIcon;
        this.compressedWidth = this.goodsIcon.getIconWidth() * 2;
    }

    public int getProduction() {
        return this.production;
    }

    public void setProduction(int newProduction) {
        this.production = newProduction;
        if (this.goodsType != null) {
            this.setToolTipText(String.valueOf(this.production) + " " + this.goodsType.getName());
        }
    }

    public int getMaximumProduction() {
        return this.maximumProduction;
    }

    public void setMaximumProduction(int newMaximumProduction) {
        this.maximumProduction = newMaximumProduction;
    }

    public int getMaxGoodsIcons() {
        return this.maxIcons;
    }

    public void setMaxGoodsIcons(int newMaxGoodsIcons) {
        this.maxIcons = newMaxGoodsIcons;
    }

    public int getStockNumber() {
        return this.stockNumber;
    }

    public void setStockNumber(int newStockNumber) {
        this.stockNumber = newStockNumber;
    }

    public boolean drawPlus() {
        return this.drawPlus;
    }

    public void setDrawPlus(boolean newDrawPlus) {
        this.drawPlus = newDrawPlus;
    }

    public boolean isCentered() {
        return this.centered;
    }

    public void setCentered(boolean newCentered) {
        this.centered = newCentered;
    }

    public int getCompressedWidth() {
        return this.compressedWidth;
    }

    public void setCompressedWidth(int newCompressedWidth) {
        this.compressedWidth = newCompressedWidth;
    }

    public Dimension getPreferredSize() {
        if (this.goodsIcon == null || this.production == 0) {
            return new Dimension(0, 0);
        }
        return new Dimension(this.getPreferredWidth(), this.goodsIcon.getImage().getHeight(null));
    }

    public int getPreferredWidth() {
        int maxSpacing;
        boolean iconsTooFarApart;
        if (this.goodsIcon == null || this.production == 0) {
            return 0;
        }
        int drawImageCount = Math.min(Math.abs(this.production), this.maxIcons);
        int iconWidth = this.goodsIcon.getIconWidth();
        int pixelsPerIcon = iconWidth / 2;
        if (pixelsPerIcon - iconWidth < 0) {
            pixelsPerIcon = (this.compressedWidth - iconWidth) / drawImageCount;
        }
        boolean bl = iconsTooFarApart = pixelsPerIcon > (maxSpacing = iconWidth);
        if (iconsTooFarApart) {
            pixelsPerIcon = maxSpacing;
        }
        return pixelsPerIcon * (drawImageCount - 1) + iconWidth;
    }

    public void paintComponent(Graphics g) {
        boolean needToCenterImages;
        int maxSpacing;
        boolean iconsTooFarApart;
        int iconWidth;
        int pixelsPerIcon;
        if (this.goodsIcon == null || this.production == 0 && this.stockNumber < 0) {
            return;
        }
        int drawImageCount = Math.min(Math.abs(this.production), this.maxIcons);
        if (drawImageCount == 0) {
            drawImageCount = 1;
        }
        if ((pixelsPerIcon = (iconWidth = this.goodsIcon.getIconWidth()) / 2) - iconWidth < 0) {
            pixelsPerIcon = (this.compressedWidth - iconWidth) / drawImageCount;
        }
        boolean bl = iconsTooFarApart = pixelsPerIcon > (maxSpacing = iconWidth);
        if (iconsTooFarApart) {
            pixelsPerIcon = maxSpacing;
        }
        int coverage = pixelsPerIcon * (drawImageCount - 1) + iconWidth;
        int leftOffset = 0;
        boolean bl2 = needToCenterImages = this.centered && coverage < this.getWidth();
        if (needToCenterImages) {
            leftOffset = (this.getWidth() - coverage) / 2;
        }
        int width = Math.max(this.getWidth(), coverage);
        int height = Math.max(this.getHeight(), this.goodsIcon.getImage().getHeight(null));
        this.setSize(new Dimension(width, height));
        for (int i = 0; i < drawImageCount; ++i) {
            this.goodsIcon.paintIcon(null, g, leftOffset + i * pixelsPerIcon, 0);
        }
        if (this.production >= this.displayNumber || this.production < 0 || this.maxIcons < this.production || this.stockNumber > 0 || this.maximumProduction > this.production && this.production > 0) {
            BufferedImage stringImage;
            int textOffset;
            String number = "";
            if (this.stockNumber >= 0) {
                number = Integer.toString(this.stockNumber);
                this.drawPlus = true;
            }
            number = this.production >= 0 && this.drawPlus ? number + "+" + Integer.toString(this.production) : number + Integer.toString(this.production);
            if (this.maximumProduction > this.production && this.production > 0) {
                number = number + "/" + String.valueOf(this.maximumProduction);
            }
            textOffset = (textOffset = leftOffset + (coverage - (stringImage = this.parent.getGUI().createStringImage(this, number, this.getForeground(), width, 12)).getWidth()) / 2) >= 0 ? textOffset : 0;
            g.drawImage(stringImage, textOffset, this.goodsIcon.getIconHeight() / 2 - stringImage.getHeight() / 2, null);
        }
    }
}

