/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import net.sf.freecol.client.ClientOptions;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;

public final class ProductionMultiplesLabel
extends JComponent {
    private static Logger logger = Logger.getLogger(ProductionMultiplesLabel.class.getName());
    private final Canvas parent;
    private int maxIcons = 7;
    private boolean drawPlus = false;
    private boolean centered = true;
    private int compressedWidth = -1;
    private GoodsType[] goodsType;
    private ImageIcon[] goodsIcon;
    private int[] production;
    private int totalProduction;
    private int maximumProduction = -1;
    private int displayNumber;
    private int stockNumber = -1;

    public ProductionMultiplesLabel(Goods goods, Canvas parent) {
        this(goods.getType(), goods.getAmount(), -1, parent);
    }

    public ProductionMultiplesLabel(GoodsType goodsType, int amount, Canvas parent) {
        this(goodsType, amount, -1, parent);
    }

    public ProductionMultiplesLabel(GoodsType goodsType, int amount, int maximumProduction, Canvas parent) {
        this(new GoodsType[]{goodsType}, new int[]{amount}, maximumProduction, parent);
    }

    public ProductionMultiplesLabel(GoodsType goodsType, int amount, GoodsType goodsType2, int amount2, Canvas parent) {
        this(new GoodsType[]{goodsType, goodsType2}, new int[]{amount, amount2}, -1, parent);
    }

    public ProductionMultiplesLabel(GoodsType[] goodsType, int[] amount, int maximumProduction, Canvas parent) {
        this.parent = parent;
        this.production = amount;
        this.goodsType = goodsType;
        this.maximumProduction = maximumProduction;
        ClientOptions options = parent.getClient().getClientOptions();
        this.maxIcons = options.getInteger("model.option.guiMaxNumberOfGoodsImages");
        this.displayNumber = options.getInteger("model.option.guiMinNumberToDisplayGoodsCount");
        this.setFont(new Font("Dialog", 1, 12));
        this.totalProduction = 0;
        if (goodsType != null) {
            this.goodsIcon = new ImageIcon[goodsType.length];
            StringBuffer toolTipText = new StringBuffer();
            for (int ii = 0; ii < goodsType.length; ++ii) {
                this.goodsIcon[ii] = parent.getGUI().getImageLibrary().getGoodsImageIcon(goodsType[ii]);
                if (ii > 0) {
                    toolTipText.append(", ");
                }
                toolTipText.append(amount[ii]).append(" ").append(goodsType[ii].getName());
                this.totalProduction += amount[ii];
            }
            this.compressedWidth = this.getMaximumIconWidth() * 2;
            this.setToolTipText(toolTipText.toString());
        }
        if (this.totalProduction < 0) {
            this.setForeground(Color.RED);
        } else {
            this.setForeground(Color.WHITE);
        }
    }

    public Canvas getCanvas() {
        return this.parent;
    }

    public int getDisplayNumber() {
        return this.displayNumber;
    }

    public void setDisplayNumber(int newDisplayNumber) {
        this.displayNumber = newDisplayNumber;
    }

    public ImageIcon getGoodsIcon() {
        logger.warning("GETTING ProductionMultiplesLabel's getGoodsIcon...");
        return this.goodsIcon[0];
    }

    public void setGoodsIcon(ImageIcon newGoodsIcon) {
        logger.warning("RESETTING ProductionMultiplesLabel's setGoodsIcon generally instead of specifically...");
        this.goodsIcon[0] = newGoodsIcon;
    }

    public int getProduction() {
        return this.totalProduction;
    }

    public void setProduction(int newProduction) {
        logger.warning("RESETTING ProductionMultiplesLabel's value generally instead of specifically to: " + newProduction);
        this.totalProduction = newProduction;
        this.setToolTipText(String.valueOf(this.totalProduction) + " " + this.goodsType[0].getName());
    }

    public int getMaximumProduction() {
        return this.maximumProduction;
    }

    public void setMaximumProduction(int newMaximumProduction) {
        this.maximumProduction = newMaximumProduction;
    }

    public int getMaxGoodsIcons() {
        return this.maxIcons;
    }

    public void setMaxGoodsIcons(int newMaxGoodsIcons) {
        this.maxIcons = newMaxGoodsIcons;
    }

    public int getStockNumber() {
        return this.stockNumber;
    }

    public void setStockNumber(int newStockNumber) {
        this.stockNumber = newStockNumber;
    }

    public boolean drawPlus() {
        return this.drawPlus;
    }

    public void setDrawPlus(boolean newDrawPlus) {
        this.drawPlus = newDrawPlus;
    }

    public boolean isCentered() {
        return this.centered;
    }

    public void setCentered(boolean newCentered) {
        this.centered = newCentered;
    }

    public int getCompressedWidth() {
        return this.compressedWidth;
    }

    public void setCompressedWidth(int newCompressedWidth) {
        this.compressedWidth = newCompressedWidth;
    }

    public Dimension getPreferredSize() {
        if (this.goodsIcon == null || this.totalProduction == 0) {
            return new Dimension(0, 0);
        }
        return new Dimension(this.getPreferredWidth(), this.getMaximumIconHeight());
    }

    public int getPreferredWidth() {
        int maxSpacing;
        boolean iconsTooFarApart;
        if (this.goodsIcon == null || this.totalProduction == 0) {
            return 0;
        }
        int drawImageCount = Math.min(Math.abs(this.totalProduction), this.maxIcons);
        int iconWidth = this.getMaximumIconWidth();
        int pixelsPerIcon = iconWidth / 2;
        if (pixelsPerIcon - iconWidth < 0) {
            pixelsPerIcon = (this.compressedWidth - iconWidth) / drawImageCount;
        }
        boolean bl = iconsTooFarApart = pixelsPerIcon > (maxSpacing = iconWidth);
        if (iconsTooFarApart) {
            pixelsPerIcon = maxSpacing;
        }
        return pixelsPerIcon * (drawImageCount - 1) + iconWidth;
    }

    public int getMaximumIconWidth() {
        int width = 0;
        for (int ii = 0; ii < this.goodsIcon.length; ++ii) {
            if (this.goodsIcon[ii].getIconWidth() <= width) continue;
            width = this.goodsIcon[ii].getIconWidth();
        }
        return width;
    }

    public int getMaximumIconHeight() {
        int height = 0;
        for (int ii = 0; ii < this.goodsIcon.length; ++ii) {
            if (this.goodsIcon[ii].getImage().getHeight(null) <= height) continue;
            height = this.goodsIcon[ii].getImage().getHeight(null);
        }
        return height;
    }

    public void paintComponent(Graphics g) {
        boolean needToCenterImages;
        int maxSpacing;
        boolean iconsTooFarApart;
        int iconWidth;
        int pixelsPerIcon;
        if (this.goodsIcon == null || this.totalProduction == 0 && this.stockNumber < 0) {
            return;
        }
        int drawImageCount = Math.min(Math.abs(this.totalProduction), this.maxIcons);
        if (drawImageCount == 0) {
            drawImageCount = 1;
        }
        if ((pixelsPerIcon = (iconWidth = this.getMaximumIconWidth()) / 2) - iconWidth < 0) {
            pixelsPerIcon = (this.compressedWidth - iconWidth) / drawImageCount;
        }
        boolean bl = iconsTooFarApart = pixelsPerIcon > (maxSpacing = iconWidth);
        if (iconsTooFarApart) {
            pixelsPerIcon = maxSpacing;
        }
        int coverage = pixelsPerIcon * (drawImageCount - 1) + iconWidth;
        int leftOffset = 0;
        boolean bl2 = needToCenterImages = this.centered && coverage < this.getWidth();
        if (needToCenterImages) {
            leftOffset = (this.getWidth() - coverage) / 2;
        }
        int width = Math.max(this.getWidth(), coverage);
        int height = Math.max(this.getHeight(), this.getMaximumIconHeight());
        this.setSize(new Dimension(width, height));
        int countImages = 0;
        int leftImageOffset = 0;
        block0: for (int indexGoods = 0; indexGoods < this.goodsIcon.length; ++indexGoods) {
            for (int i = 0; i < Math.abs(this.production[indexGoods]); ++i) {
                this.goodsIcon[indexGoods].paintIcon(null, g, leftOffset + leftImageOffset, 0);
                leftImageOffset += pixelsPerIcon;
                if (++countImages < drawImageCount) continue;
                indexGoods = this.goodsIcon.length;
                continue block0;
            }
        }
        if (this.totalProduction >= this.displayNumber || this.totalProduction < 0 || this.maxIcons < this.totalProduction || this.stockNumber > 0) {
            BufferedImage stringImage;
            int textOffset;
            String number = "";
            if (this.stockNumber >= 0) {
                number = Integer.toString(this.stockNumber);
                this.drawPlus = true;
            }
            number = this.totalProduction >= 0 && this.drawPlus ? number + "+" + Integer.toString(this.totalProduction) : number + Integer.toString(this.totalProduction);
            if (this.maximumProduction > this.totalProduction && this.totalProduction > 0) {
                number = number + "/" + String.valueOf(this.maximumProduction);
            }
            textOffset = (textOffset = leftOffset + (coverage - (stringImage = this.parent.getGUI().createStringImage(this, number, this.getForeground(), width, 12)).getWidth()) / 2) >= 0 ? textOffset : 0;
            g.drawImage(stringImage, textOffset, this.getMaximumIconHeight() / 2 - stringImage.getHeight() / 2, null);
        }
    }
}

