/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import cz.autel.dmi.HIGLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JTextArea;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.InGameController;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.UnitType;

public final class RecruitDialog
extends FreeColDialog
implements ActionListener {
    private static Logger logger = Logger.getLogger(RecruitDialog.class.getName());
    private static final int RECRUIT_CANCEL = -1;
    private static final int NUMBER_OF_PERSONS = 3;
    private final JButton[] person = new JButton[3];
    private final JButton cancel;
    private final JTextArea question;
    private final FreeColClient freeColClient;
    private final InGameController inGameController;

    public RecruitDialog(Canvas parent) {
        super(parent);
        this.freeColClient = parent.getClient();
        this.inGameController = this.freeColClient.getInGameController();
        this.setFocusCycleRoot(true);
        this.question = RecruitDialog.getDefaultTextArea(Messages.message("recruitDialog.clickOn", new String[0]));
        for (int index = 0; index < 3; ++index) {
            this.person[index] = new JButton();
            this.person[index].setActionCommand(String.valueOf(index));
            RecruitDialog.enterPressesWhenFocused(this.person[index]);
            this.person[index].addActionListener(this);
            this.person[index].setIconTextGap(3);
        }
        this.cancel = new JButton(Messages.message("cancel", new String[0]));
        this.cancel.setActionCommand(String.valueOf(-1));
        RecruitDialog.enterPressesWhenFocused(this.cancel);
        this.cancel.addActionListener(this);
        this.setCancelComponent(this.cancel);
        this.initialize();
    }

    public void requestFocus() {
        this.cancel.requestFocus();
    }

    public void initialize() {
        int[] widths = new int[]{0};
        int[] heights = new int[]{0, 9, 0, 3, 0, 3, 0, 3, 0};
        this.setLayout(new HIGLayout(widths, heights));
        int row = 1;
        int column = 1;
        this.add((Component)this.question, higConst.rc(row, 1));
        row += 2;
        int recruitPrice = 0;
        Player player = this.freeColClient.getMyPlayer();
        if (this.freeColClient.getGame() != null && player != null) {
            int production = 0;
            for (Colony colony : player.getColonies()) {
                production += colony.getProductionOf(Goods.CROSSES);
            }
            int turns = 100;
            if (production > 0) {
                int crossesRequired = player.getCrossesRequired() - player.getCrosses();
                turns = crossesRequired / production;
                if (crossesRequired % production > 0) {
                    ++turns;
                }
            }
            ImageLibrary library = this.getCanvas().getGUI().getImageLibrary();
            recruitPrice = player.getRecruitPrice();
            this.question.setText(Messages.message("recruitDialog.clickOn", "%money%", String.valueOf(recruitPrice), "%number%", String.valueOf(turns)));
            for (int index = 0; index < 3; ++index) {
                UnitType unitType = player.getEurope().getRecruitable(index);
                ImageIcon unitIcon = library.getUnitImageIcon(unitType);
                this.person[index].setText(unitType.getName());
                this.person[index].setIcon(library.getScaledImageIcon(unitIcon, 0.66f));
                if (recruitPrice > player.getGold()) {
                    this.person[index].setEnabled(false);
                } else {
                    this.person[index].setEnabled(true);
                }
                this.add((Component)this.person[index], higConst.rc(row, column));
                row += 2;
            }
        }
        this.add((Component)this.cancel, higConst.rc(row, column, ""));
        this.setSize(this.getPreferredSize());
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        try {
            int action = Integer.valueOf(command);
            if (action == -1) {
                this.setResponse(new Integer(-1));
            } else if (action >= 0 && action < 3) {
                this.inGameController.recruitUnitInEurope(action);
                this.setResponse(new Integer(0));
            } else {
                logger.warning("Invalid action command");
                this.setResponse(new Integer(-1));
            }
        }
        catch (NumberFormatException e) {
            logger.warning("Invalid action number");
            this.setResponse(new Integer(-1));
        }
    }
}

