/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import cz.autel.dmi.HIGLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.ProductionLabel;
import net.sf.freecol.client.gui.panel.ReportPanel;
import net.sf.freecol.client.gui.panel.UnitLabel;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Unit;

public final class ReportColonyPanel
extends ReportPanel {
    private List<Colony> colonies;
    private final int ROWS_PER_COLONY = 4;

    public ReportColonyPanel(Canvas parent) {
        super(parent, Messages.message("menuBar.report.colony", new String[0]));
    }

    public void initialize() {
        int i;
        Player player = this.getCanvas().getClient().getMyPlayer();
        this.colonies = player.getColonies();
        int[] widths = new int[]{0};
        int[] heights = null;
        heights = this.colonies.size() == 0 ? new int[]{} : new int[this.colonies.size() * 2 - 1];
        for (i = 1; i < heights.length; i += 2) {
            heights[i] = 12;
        }
        this.reportPanel.setLayout(new HIGLayout(widths, heights));
        widths = new int[]{0};
        heights = new int[7];
        for (i = 1; i < heights.length; i += 2) {
            heights[i] = 5;
        }
        int panelColumn = 1;
        int colonyRow = 1;
        CompoundBorder colonyBorder = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(LINK_COLOR), BorderFactory.createEmptyBorder(5, 5, 5, 5));
        Collections.sort(this.colonies, this.getCanvas().getClient().getClientOptions().getColonyComparator());
        for (int colonyIndex = 0; colonyIndex < this.colonies.size(); ++colonyIndex) {
            int row = 1;
            Colony colony = this.colonies.get(colonyIndex);
            JPanel colonyPanel = new JPanel(new HIGLayout(widths, heights));
            colonyPanel.setBorder(colonyBorder);
            colonyPanel.add((Component)this.createColonyButton(colonyIndex), higConst.rc(row, panelColumn, "l"));
            colonyPanel.add((Component)this.createUnitPanel(colony), higConst.rc(row += 2, panelColumn));
            colonyPanel.add((Component)this.createProductionPanel(colony), higConst.rc(row += 2, panelColumn));
            colonyPanel.add((Component)this.createBuildingPanel(colony), higConst.rc(row += 2, panelColumn));
            this.reportPanel.add((Component)colonyPanel, higConst.rc(colonyRow, panelColumn));
            colonyRow += 2;
        }
    }

    private JPanel createUnitPanel(Colony colony) {
        UnitLabel unitLabel;
        JPanel unitPanel = new JPanel(new GridLayout(0, 12));
        unitPanel.setOpaque(false);
        List<Unit> unitList = colony.getUnitList();
        Collections.sort(unitList, this.getUnitTypeComparator());
        for (Unit unit : unitList) {
            unitLabel = new UnitLabel(unit, this.getCanvas(), true, true);
            unitPanel.add(unitLabel);
        }
        unitList = colony.getTile().getUnitList();
        Collections.sort(unitList, this.getUnitTypeComparator());
        for (Unit unit : unitList) {
            unitLabel = new UnitLabel(unit, this.getCanvas(), true, true);
            unitPanel.add(unitLabel);
        }
        return unitPanel;
    }

    private JPanel createProductionPanel(Colony colony) {
        JPanel goodsPanel = new JPanel(new GridLayout(0, 10));
        goodsPanel.setOpaque(false);
        int netFood = colony.getFoodProduction() - colony.getFoodConsumption();
        if (netFood != 0) {
            ProductionLabel productionLabel = new ProductionLabel(Goods.FOOD, netFood, this.getCanvas());
            productionLabel.setStockNumber(colony.getFoodCount());
            goodsPanel.add(productionLabel);
        }
        for (GoodsType goodsType : FreeCol.getSpecification().getGoodsTypeList()) {
            if (goodsType.isFoodType()) continue;
            int newValue = colony.getProductionNetOf(goodsType);
            int stockValue = colony.getGoodsCount(goodsType);
            if (newValue == 0 && stockValue <= 0) continue;
            Building building = colony.getBuildingForProducing(goodsType);
            ProductionLabel productionLabel = new ProductionLabel(goodsType, newValue, this.getCanvas());
            if (building != null) {
                productionLabel.setMaximumProduction(building.getMaximumProduction());
            }
            if (goodsType == Goods.HORSES) {
                productionLabel.setMaxGoodsIcons(1);
            }
            productionLabel.setStockNumber(stockValue);
            goodsPanel.add(productionLabel);
        }
        return goodsPanel;
    }

    private JPanel createBuildingPanel(Colony colony) {
        JPanel buildingPanel = new JPanel(new GridLayout(0, 5, 12, 0));
        buildingPanel.setOpaque(false);
        for (Building building : colony.getBuildings()) {
            buildingPanel.add(new JLabel(building.getName()));
        }
        BuildableType currentType = colony.getCurrentlyBuilding();
        JLabel buildableLabel = new JLabel(currentType.getName());
        if (currentType == BuildableType.NOTHING) {
            buildableLabel.setForeground(Color.RED);
        } else {
            buildableLabel.setForeground(Color.GRAY);
        }
        buildingPanel.add(buildableLabel);
        return buildingPanel;
    }

    private JButton createColonyButton(int index) {
        JButton button = ReportColonyPanel.getLinkButton(this.colonies.get(index).getName(), null, String.valueOf(index));
        button.addActionListener(this);
        return button;
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        int action = Integer.valueOf(command);
        if (action == -1) {
            super.actionPerformed(event);
        } else {
            this.getCanvas().showColonyPanel(this.colonies.get(action));
        }
    }
}

