/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import cz.autel.dmi.HIGLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColProgressBar;
import net.sf.freecol.client.gui.panel.ReportPanel;
import net.sf.freecol.client.gui.panel.ReportProductionPanel;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.Player;

public final class ReportContinentalCongressPanel
extends ReportPanel {
    static final String title = Messages.message("report.continentalCongress.title", new String[0]);
    static final String none = Messages.message("report.continentalCongress.none", new String[0]);
    private final ReportProductionPanel productionPanel;
    private final JPanel summaryPanel;
    private final JPanel fatherPanel;

    public ReportContinentalCongressPanel(Canvas parent) {
        super(parent, title);
        int[] widths = new int[]{0};
        int[] heights = new int[]{0, 12, 0, 12, 0};
        this.reportPanel.setLayout(new HIGLayout(widths, heights));
        this.summaryPanel = new JPanel();
        this.summaryPanel.setOpaque(false);
        this.fatherPanel = new JPanel(new GridLayout(0, 4));
        this.fatherPanel.setOpaque(false);
        this.productionPanel = new ReportProductionPanel(Goods.BELLS, this.getCanvas(), this);
    }

    public void initialize() {
        Player player = this.getCanvas().getClient().getMyPlayer();
        this.productionPanel.initialize();
        this.summaryPanel.removeAll();
        this.fatherPanel.removeAll();
        this.reportPanel.removeAll();
        this.summaryPanel.add((Component)new JLabel(Messages.message("report.continentalCongress.recruiting", new String[0])), higConst.rc(1, 1));
        if (player.getCurrentFather() == null) {
            this.summaryPanel.add((Component)new JLabel(none), higConst.rc(1, 3));
        } else {
            FoundingFather father = player.getCurrentFather();
            JLabel currentFatherLabel = new JLabel(father.getName());
            currentFatherLabel.setToolTipText(father.getDescription());
            this.summaryPanel.add((Component)currentFatherLabel, higConst.rc(1, 3));
            int bells = player.getBells();
            int required = player.getTotalFoundingFatherCost();
            int production = this.productionPanel.getTotalProduction();
            FreeColProgressBar progressBar = new FreeColProgressBar(this.getCanvas(), Goods.BELLS);
            progressBar.update(0, required, bells, production);
            this.summaryPanel.add(progressBar);
        }
        if (player.getFatherCount() < 1) {
            JLabel fatherLabel = new JLabel(none);
            fatherLabel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
            this.fatherPanel.add(fatherLabel);
        } else {
            for (FoundingFather father : FreeCol.getSpecification().getFoundingFathers()) {
                if (!player.hasFather(father)) continue;
                JLabel fatherLabel = new JLabel(Messages.message(father.getName(), new String[0]));
                fatherLabel.setToolTipText(Messages.message(father.getDescription(), new String[0]));
                fatherLabel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
                this.fatherPanel.add(fatherLabel);
            }
        }
        this.fatherPanel.setBorder(BorderFactory.createTitledBorder(player.getNationAsString() + " " + title));
        this.reportPanel.add((Component)this.summaryPanel, higConst.rc(1, 1));
        this.reportPanel.add((Component)this.fatherPanel, higConst.rc(3, 1));
        this.reportPanel.add((Component)this.productionPanel, higConst.rc(5, 1));
    }
}

