/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import cz.autel.dmi.HIGLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.ReportPanel;
import net.sf.freecol.common.model.Region;

public final class ReportExplorationPanel
extends ReportPanel {
    public static final int EXTRA_ROWS = 2;
    private static final Comparator<Region> regionComparator = new Comparator<Region>(){

        @Override
        public int compare(Region region1, Region region2) {
            int number2;
            int number1 = region1.getDiscoveredIn().getNumber();
            if (number1 == (number2 = region2.getDiscoveredIn().getNumber())) {
                return region2.getScoreValue() - region1.getScoreValue();
            }
            return number2 - number1;
        }
    };

    public ReportExplorationPanel(Canvas parent) {
        super(parent, Messages.message("menuBar.report.exploration", new String[0]));
    }

    public void initialize() {
        this.reportPanel.removeAll();
        ArrayList<Region> regions = new ArrayList<Region>();
        for (Region region : this.getCanvas().getClient().getGame().getMap().getRegions()) {
            if (region.getDiscoveredIn() == null) continue;
            regions.add(region);
        }
        Collections.sort(regions, regionComparator);
        int[] heights = new int[2 * regions.size() + 2];
        int[] widths = new int[]{0, 10, 0, 10, 0, 10, 0, 10, 0};
        int regionColumn = 1;
        int typeColumn = 3;
        int turnColumn = 5;
        int playerColumn = 7;
        int valueColumn = 9;
        int row = 1;
        for (int index = 1; index < heights.length; index += 2) {
            heights[index] = 3;
        }
        JPanel result = new JPanel(new HIGLayout(widths, heights));
        result.setOpaque(false);
        result.add((Component)new JLabel(Messages.message("report.exploration.nameOfRegion", new String[0])), higConst.rc(row, regionColumn));
        result.add((Component)new JLabel(Messages.message("report.exploration.typeOfRegion", new String[0])), higConst.rc(row, typeColumn));
        result.add((Component)new JLabel(Messages.message("report.exploration.discoveredIn", new String[0])), higConst.rc(row, turnColumn));
        result.add((Component)new JLabel(Messages.message("report.exploration.discoveredBy", new String[0])), higConst.rc(row, playerColumn));
        result.add((Component)new JLabel(Messages.message("report.exploration.valueOfRegion", new String[0])), higConst.rc(row, valueColumn));
        row += 2;
        for (Region region : regions) {
            result.add((Component)new JLabel(region.getName()), higConst.rc(row, regionColumn));
            result.add((Component)new JLabel(region.getTypeName()), higConst.rc(row, typeColumn));
            result.add((Component)new JLabel(region.getDiscoveredIn().toString()), higConst.rc(row, turnColumn));
            result.add((Component)new JLabel(region.getDiscoveredBy().getNationAsString()), higConst.rc(row, playerColumn));
            result.add((Component)new JLabel(String.valueOf(region.getScoreValue())), higConst.rc(row, valueColumn));
            row += 2;
        }
        this.reportPanel.add(result);
    }
}

