/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import cz.autel.dmi.HIGLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.ReportPanel;
import net.sf.freecol.common.model.Player;
import org.w3c.dom.Element;

public final class ReportForeignAffairPanel
extends ReportPanel {
    public ReportForeignAffairPanel(Canvas parent) {
        super(parent, Messages.message("menuBar.report.foreign", new String[0]));
    }

    public void initialize() {
        this.reportPanel.removeAll();
        this.reportPanel.setLayout(new GridLayout(0, 2));
        int[] widths = new int[]{0, 12, 0, 12, 0, 0};
        int[] heights = new int[]{0, 12, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0};
        int coatColumn = 1;
        int labelColumn = 3;
        int valueColumn = 5;
        int percentColumn = 6;
        FreeColClient client = this.getCanvas().getClient();
        ImageLibrary imageLibrary = this.getCanvas().getGUI().getImageLibrary();
        Element report = client.getInGameController().getForeignAffairsReport();
        int number = report.getChildNodes().getLength();
        for (int i = 0; i < number; ++i) {
            Element enemyElement = (Element)report.getChildNodes().item(i);
            JPanel enemyPanel = new JPanel(new HIGLayout(widths, heights));
            enemyPanel.setOpaque(false);
            int row = 1;
            Player enemy = (Player)client.getGame().getFreeColGameObject(enemyElement.getAttribute("player"));
            ImageIcon coatOfArms = imageLibrary.getCoatOfArmsImageIcon(enemy.getNation());
            if (coatOfArms != null) {
                enemyPanel.add((Component)new JLabel(coatOfArms), higConst.rcwh(row, coatColumn, 1, heights.length, "t"));
            }
            enemyPanel.add((Component)new JLabel(enemy.getNationAsString()), higConst.rc(row, labelColumn));
            enemyPanel.add((Component)new JLabel(Messages.message("report.stance", new String[0])), higConst.rc(row += 2, labelColumn));
            Player.Stance stance = Enum.valueOf(Player.Stance.class, enemyElement.getAttribute("stance"));
            enemyPanel.add((Component)new JLabel(Player.getStanceAsString(stance)), higConst.rc(row, valueColumn, "r"));
            enemyPanel.add((Component)new JLabel(Messages.message("report.numberOfColonies", new String[0])), higConst.rc(++row, labelColumn));
            enemyPanel.add((Component)new JLabel(enemyElement.getAttribute("numberOfColonies"), 11), higConst.rc(row, valueColumn));
            enemyPanel.add((Component)new JLabel(Messages.message("report.numberOfUnits", new String[0])), higConst.rc(++row, labelColumn));
            enemyPanel.add((Component)new JLabel(enemyElement.getAttribute("numberOfUnits"), 11), higConst.rc(row, valueColumn));
            enemyPanel.add((Component)new JLabel(Messages.message("report.militaryStrength", new String[0])), higConst.rc(++row, labelColumn));
            enemyPanel.add((Component)new JLabel(enemyElement.getAttribute("militaryStrength"), 11), higConst.rc(row, valueColumn));
            enemyPanel.add((Component)new JLabel(Messages.message("report.navalStrength", new String[0])), higConst.rc(++row, labelColumn));
            enemyPanel.add((Component)new JLabel(enemyElement.getAttribute("navalStrength"), 11), higConst.rc(row, valueColumn));
            enemyPanel.add((Component)new JLabel(Messages.message("goldTitle", new String[0])), higConst.rc(++row, labelColumn));
            enemyPanel.add((Component)new JLabel(enemyElement.getAttribute("gold"), 11), higConst.rc(row, valueColumn));
            row += 2;
            if (enemyElement.hasAttribute("tax")) {
                enemyPanel.add((Component)new JLabel(Messages.message("menuBar.colopedia.father", new String[0])), higConst.rc(row, labelColumn));
                enemyPanel.add((Component)new JLabel(enemyElement.getAttribute("foundingFathers"), 11), higConst.rc(row, valueColumn));
                enemyPanel.add((Component)new JLabel(Messages.message("tax", new String[0])), higConst.rc(++row, labelColumn));
                enemyPanel.add((Component)new JLabel(enemyElement.getAttribute("tax"), 11), higConst.rc(row, valueColumn));
                enemyPanel.add((Component)new JLabel("%"), higConst.rc(row, percentColumn));
                enemyPanel.add((Component)new JLabel(Messages.message("report.sonsOfLiberty", new String[0])), higConst.rc(++row, labelColumn));
                enemyPanel.add((Component)new JLabel(enemyElement.getAttribute("SoL"), 11), higConst.rc(row, valueColumn));
                enemyPanel.add((Component)new JLabel("%"), higConst.rc(row, percentColumn));
                ++row;
            }
            this.reportPanel.add(enemyPanel);
        }
        this.reportPanel.doLayout();
    }
}

