/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import cz.autel.dmi.HIGLayout;
import java.awt.Component;
import java.text.DateFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.ReportPanel;
import net.sf.freecol.common.model.HighScore;
import net.sf.freecol.common.model.Turn;
import org.w3c.dom.Element;

public final class ReportHighScoresPanel
extends ReportPanel {
    public ReportHighScoresPanel(Canvas parent) {
        super(parent, Messages.message("menuBar.game.highScores", new String[0]));
    }

    public void initialize() {
        this.reportPanel.removeAll();
        FreeColClient client = this.getCanvas().getClient();
        ImageLibrary imageLibrary = this.getCanvas().getGUI().getImageLibrary();
        Element report = client.getInGameController().getHighScores();
        int number = report.getChildNodes().getLength();
        int[] widths1 = new int[]{0, 30, 0};
        int[] heights1 = new int[4 * number - 1];
        for (int index = 1; index < heights1.length; index += 2) {
            heights1[index] = 3;
        }
        this.reportPanel.setLayout(new HIGLayout(widths1, heights1));
        int reportRow = 1;
        int scoreColumn = 1;
        int panelColumn = 3;
        for (int i = 0; i < number; ++i) {
            Element element = (Element)report.getChildNodes().item(i);
            try {
                HighScore highScore = new HighScore(element);
                JLabel scoreValue = new JLabel(String.valueOf(highScore.getScore()));
                scoreValue.setFont(smallHeaderFont);
                this.reportPanel.add((Component)scoreValue, higConst.rc(reportRow, scoreColumn, "r"));
                String messageID = null;
                String nation = null;
                if (highScore.getIndependenceTurn() > 0) {
                    messageID = "report.highScores.president";
                    nation = highScore.getNationName();
                } else {
                    messageID = "report.highScores.governor";
                    nation = highScore.getNewLandName();
                }
                JLabel headline = new JLabel(Messages.message(messageID, "%name%", highScore.getPlayerName(), "%nation%", nation));
                headline.setFont(smallHeaderFont);
                this.reportPanel.add((Component)headline, higConst.rc(reportRow, panelColumn));
                reportRow += 2;
                JPanel scorePanel = new JPanel();
                scorePanel.setOpaque(false);
                int rows = 9;
                int[] widths = new int[]{200, 30, 200};
                int[] heights = new int[2 * rows - 1];
                for (int index = 1; index < heights.length; index += 2) {
                    heights[index] = 3;
                }
                scorePanel.setLayout(new HIGLayout(widths, heights));
                int row = 1;
                int labelColumn = 1;
                int valueColumn = 3;
                JLabel scoreLabel = new JLabel(Messages.message("report.highScores.score", new String[0]));
                scorePanel.add((Component)scoreLabel, higConst.rc(row, labelColumn, "l"));
                JLabel scoreValue2 = new JLabel(String.valueOf(highScore.getScore()));
                scorePanel.add((Component)scoreValue2, higConst.rc(row, valueColumn, "r"));
                JLabel difficultyLabel = new JLabel(Messages.message("report.highScores.difficulty", new String[0]));
                scorePanel.add((Component)difficultyLabel, higConst.rc(row += 2, labelColumn, "l"));
                JLabel difficultyValue = new JLabel(Messages.message(highScore.getDifficulty(), new String[0]));
                scorePanel.add((Component)difficultyValue, higConst.rc(row, valueColumn, "r"));
                JLabel independenceLabel = new JLabel(Messages.message("report.highScores.independence", new String[0]));
                scorePanel.add((Component)independenceLabel, higConst.rc(row += 2, labelColumn, "l"));
                int independenceTurn = highScore.getIndependenceTurn();
                String independence = independenceTurn > 0 ? Turn.toString(independenceTurn) : Messages.message("no", new String[0]);
                JLabel independenceValue = new JLabel(independence);
                scorePanel.add((Component)independenceValue, higConst.rc(row, valueColumn, "r"));
                JLabel nationLabel = new JLabel(Messages.message("report.highScores.nation", new String[0]));
                scorePanel.add((Component)nationLabel, higConst.rc(row += 2, labelColumn, "l"));
                JLabel nationValue = new JLabel(String.valueOf(highScore.getOldNationName()));
                scorePanel.add((Component)nationValue, higConst.rc(row, valueColumn, "r"));
                JLabel nationTypeLabel = new JLabel(Messages.message("report.highScores.nationType", new String[0]));
                scorePanel.add((Component)nationTypeLabel, higConst.rc(row += 2, labelColumn, "l"));
                JLabel nationTypeValue = new JLabel(Messages.message(highScore.getNationTypeID() + ".name", new String[0]));
                scorePanel.add((Component)nationTypeValue, higConst.rc(row, valueColumn, "r"));
                JLabel unitLabel = new JLabel(Messages.message("report.highScores.units", new String[0]));
                scorePanel.add((Component)unitLabel, higConst.rc(row += 2, labelColumn, "l"));
                JLabel unitValue = new JLabel(String.valueOf(highScore.getUnits()));
                scorePanel.add((Component)unitValue, higConst.rc(row, valueColumn, "r"));
                JLabel coloniesLabel = new JLabel(Messages.message("report.highScores.colonies", new String[0]));
                scorePanel.add((Component)coloniesLabel, higConst.rc(row += 2, labelColumn, "l"));
                JLabel coloniesValue = new JLabel(String.valueOf(highScore.getColonies()));
                scorePanel.add((Component)coloniesValue, higConst.rc(row, valueColumn, "r"));
                JLabel dateLabel = new JLabel(Messages.message("report.highScores.retired", new String[0]));
                scorePanel.add((Component)dateLabel, higConst.rc(row += 2, labelColumn, "l"));
                DateFormat format = DateFormat.getDateTimeInstance(2, 3);
                JLabel dateValue = new JLabel(format.format(highScore.getDate()));
                scorePanel.add((Component)dateValue, higConst.rc(row, valueColumn, "r"));
                this.reportPanel.add((Component)scorePanel, higConst.rc(reportRow, panelColumn));
                reportRow += 2;
                continue;
            }
            catch (XMLStreamException e) {
                logger.warning(e.toString());
            }
        }
        this.reportPanel.doLayout();
    }
}

