/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import cz.autel.dmi.HIGLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.ReportPanel;
import net.sf.freecol.common.model.IndianNationType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.UnitType;

public final class ReportIndianPanel
extends ReportPanel {
    public static final int EXTRA_ROWS = 10;

    public ReportIndianPanel(Canvas parent) {
        super(parent, Messages.message("menuBar.report.indian", new String[0]));
    }

    public void initialize() {
        Player player = this.getCanvas().getClient().getMyPlayer();
        this.reportPanel.removeAll();
        this.reportPanel.setLayout(new GridLayout(0, 1));
        for (Player opponent : this.getCanvas().getClient().getGame().getPlayers()) {
            this.buildIndianAdvisorPanel(player, opponent);
        }
        this.reportPanel.doLayout();
    }

    private void buildIndianAdvisorPanel(Player player, Player opponent) {
        if (opponent.isEuropean() || opponent.isREF()) {
            return;
        }
        if (opponent.isDead()) {
            return;
        }
        if (!player.hasContacted(opponent)) {
            return;
        }
        ImageLibrary library = this.getCanvas().getClient().getImageLibrary();
        int numberOfSettlements = opponent.getSettlements().size();
        int[] heights = new int[2 * (numberOfSettlements + 10)];
        int[] widths = new int[]{0, 10, 0};
        int labelColumn = 1;
        int valueColumn = 3;
        int row = 1;
        for (int index = 1; index < heights.length; index += 2) {
            heights[index] = 3;
        }
        heights[9] = 16;
        heights[11] = 6;
        JPanel result = new JPanel(new HIGLayout(widths, heights));
        result.add((Component)new JLabel(Messages.message("report.indian.nameOfTribe", new String[0])), higConst.rc(row, labelColumn));
        result.add((Component)new JLabel(opponent.getNationAsString()), higConst.rc(row, valueColumn));
        result.add((Component)new JLabel(Messages.message("report.indian.chieftain", new String[0])), higConst.rc(row += 2, labelColumn));
        result.add((Component)new JLabel(opponent.getName()), higConst.rc(row, valueColumn));
        result.add((Component)new JLabel(Messages.message("report.indian.typeOfSettlements", new String[0])), higConst.rc(row += 2, labelColumn));
        result.add((Component)new JLabel(String.valueOf(((IndianNationType)opponent.getNationType()).getSettlementTypeAsString())), higConst.rc(row, valueColumn));
        result.add((Component)new JLabel(Messages.message("report.indian.numberOfSettlements", new String[0])), higConst.rc(row += 2, labelColumn));
        result.add((Component)new JLabel(String.valueOf(numberOfSettlements)), higConst.rc(row, valueColumn));
        result.add((Component)new JLabel(Messages.message("report.indian.tension", new String[0])), higConst.rc(row += 2, labelColumn));
        result.add((Component)new JLabel(opponent.getTension(player).toString()), higConst.rc(row, valueColumn));
        result.add((Component)new JLabel(Messages.message("report.indian.location", new String[0])), higConst.rc(row += 2, labelColumn));
        result.add((Component)new JLabel(Messages.message("report.indian.skillTaught", new String[0])), higConst.rc(row, valueColumn));
        row += 2;
        for (IndianSettlement settlement : opponent.getIndianSettlements()) {
            String locationName = settlement.getLocationName() + " (" + settlement.getTile().getX() + ", " + settlement.getTile().getY() + ")";
            JLabel skillLabel = new JLabel();
            UnitType skillType = settlement.getLearnableSkill();
            String skill = Messages.message("indianSettlement.skillUnknown", new String[0]);
            if (skillType != null) {
                skill = skillType.getName();
                ImageIcon skillImage = library.getUnitImageIcon(skillType);
                skillLabel.setIcon(library.getScaledImageIcon(skillImage, 0.66f));
            }
            skillLabel.setText(skill);
            result.add((Component)new JLabel(locationName), higConst.rc(row, labelColumn));
            result.add((Component)skillLabel, higConst.rc(row, valueColumn));
            row += 2;
        }
        this.reportPanel.add(result);
    }
}

