/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import cz.autel.dmi.HIGLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.LabourData;
import net.sf.freecol.client.gui.panel.ReportPanel;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;

public final class ReportLabourPanel
extends ReportPanel {
    private static final int HEADER_ROWS = 1;
    private int COLONY_COLUMN = 1;
    private int UNIT_TYPE_COLUMN = 2;
    private int WORKING_COLUMN = 3;
    private int BUILDING_COLUMN = 4;
    private int COLONIST_COLUMN = 5;
    private int COLONIST_SUMMARY_COLUMN = 6;
    private int PRODUCTION_SYMBOL_COLUMN = 7;
    private int PRODUCTION_COLUMN = 8;
    private int PRODUCTION_SUMMARY_COLUMN = 9;
    private int NETPRODUCTION_SUMMARY_COLUMN = 10;
    private static final int COLUMNS = 10;
    private LabourData labourData;
    private LabourData.UnitData unitData;
    private Player player;
    private boolean showProduction;
    private boolean showNetProduction;
    private boolean showProductionSymbols;
    private boolean showBuildings;
    private final JPanel headerRow = new JPanel();

    public ReportLabourPanel(Canvas parent) {
        this(parent, (LabourData.UnitData)null);
        this.labourData = new LabourData(this.getCanvas().getClient());
    }

    private ReportLabourPanel(Canvas parent, LabourData.UnitData data) {
        super(parent, data == null ? Messages.message("report.labour", new String[0]) : Messages.message("report.labour.details", new String[0]));
        this.unitData = data;
        this.player = parent.getClient().getMyPlayer();
        this.headerRow.setBorder(new EmptyBorder(20, 20, 0, 20));
        this.scrollPane.setColumnHeaderView(this.headerRow);
    }

    protected Border createBorder() {
        return new EmptyBorder(0, 20, 20, 20);
    }

    private boolean isOverview() {
        return this.unitData == null;
    }

    private boolean isSummary() {
        return this.isOverview() || this.unitData.isSummary();
    }

    private ImageIcon getUnitIcon(UnitType unit) {
        Unit.Role role = Unit.Role.DEFAULT;
        if (unit.hasAbility("model.ability.expertPioneer")) {
            role = Unit.Role.PIONEER;
        } else if (unit.hasAbility("model.ability.expertMissionary")) {
            role = Unit.Role.MISSIONARY;
        }
        return this.getLibrary().getUnitImageIcon(unit, role);
    }

    public void initialize() {
        if (this.isOverview()) {
            this.showProduction = true;
            this.showNetProduction = true;
            this.showProductionSymbols = true;
            this.showBuildings = false;
        } else {
            this.showProduction = this.unitData.showProduction();
            this.showNetProduction = this.unitData.showNetProduction();
            this.showProductionSymbols = false;
            GoodsType expertProduction = this.getGoodsType();
            this.showBuildings = expertProduction != null && !expertProduction.isFarmed() || this.unitData.getTotal().isTraining();
        }
        int[] widths = new int[10];
        widths[this.COLONY_COLUMN - 1] = 160;
        widths[this.UNIT_TYPE_COLUMN - 1] = this.isOverview() || !this.unitData.isSummary() ? 150 : 0;
        widths[this.WORKING_COLUMN - 1] = 170;
        widths[this.BUILDING_COLUMN - 1] = this.showBuildings ? 130 : 0;
        widths[this.COLONIST_COLUMN - 1] = 26;
        widths[this.COLONIST_SUMMARY_COLUMN - 1] = 33;
        widths[this.PRODUCTION_COLUMN - 1] = this.showProduction ? 30 : 0;
        widths[this.PRODUCTION_SUMMARY_COLUMN - 1] = this.showProduction ? 40 : 0;
        widths[this.NETPRODUCTION_SUMMARY_COLUMN - 1] = this.showNetProduction ? 40 : 0;
        widths[this.PRODUCTION_SYMBOL_COLUMN - 1] = this.showProductionSymbols ? 50 : 0;
        this.headerRow.setLayout(new HIGLayout(widths, new int[1]));
        this.addHeader();
        if (this.isOverview()) {
            int rows = this.labourData.getSummary().getTotal().getRowCount();
            for (UnitType unitType : LabourData.getLabourTypes(this.player)) {
                rows += this.labourData.getUnitData(unitType).getUnitSummaryRowCount();
            }
            this.reportPanel.setLayout(new HIGLayout(widths, new int[rows]));
            this.addUnitTypes();
        } else {
            int footerRows = 1;
            int rows = footerRows + this.unitData.getTotal().getRowCount() + this.unitData.getUnitsInEurope().getRowCount() + this.unitData.getUnitsAtSea().getRowCount() + this.unitData.getUnitsOnLand().getRowCount();
            for (LabourData.LocationData colonyData : this.unitData.getDetails().values()) {
                rows += colonyData.getRowCount();
            }
            this.reportPanel.setLayout(new HIGLayout(widths, new int[rows]));
            this.addLocations();
        }
    }

    private void addUnitTypes() {
        int row = 1;
        JButton allColonistsButton = this.createUnitNameButton(Messages.message("report.labour.allColonists", new String[0]), this.labourData.getSummary());
        this.reportPanel.add((Component)allColonistsButton, higConst.rcwh(row, this.COLONY_COLUMN, 1, this.labourData.getSummary().getUnitSummaryRowCount()));
        row = this.addLocationData(this.labourData.getSummary().getTotal(), null, row);
        int minHeight = allColonistsButton.getPreferredSize().height;
        HIGLayout higLayout = (HIGLayout)this.reportPanel.getLayout();
        for (UnitType unitType : LabourData.getLabourTypes(this.player)) {
            LabourData.UnitData unitData = this.labourData.getUnitData(unitType);
            JButton unitButton = this.createUnitNameButton(unitData.getUnitName(), unitData);
            int rows = unitData.getUnitSummaryRowCount();
            this.ensureHeight(higLayout, unitButton.getPreferredSize().height, row, rows, minHeight);
            this.reportPanel.add((Component)unitButton, higConst.rcwh(row, this.COLONY_COLUMN, 1, rows));
            if (unitData.hasDetails()) {
                row = this.addLocationData(unitData.getTotal(), null, row);
                continue;
            }
            unitButton.setEnabled(false);
            unitButton.setDisabledIcon(unitButton.getIcon());
            unitButton.setForeground(Color.GRAY);
            this.reportPanel.add((Component)this.createEmptyLabel(), higConst.rcwh(row, this.UNIT_TYPE_COLUMN, 9, 1));
            ++row;
        }
    }

    private void ensureHeight(HIGLayout higLayout, int height, int startRow, int rows, int minHeight) {
        for (int delta : this.distribute(height, rows)) {
            higLayout.setRowHeight(startRow, Math.max(delta, minHeight));
            ++startRow;
        }
    }

    private int[] distribute(int value, int pocketCount) {
        int[] pockets = new int[pocketCount];
        int pocketIndex = 0;
        for (int i = value; i > 0; --i) {
            int n = pocketIndex++;
            pockets[n] = pockets[n] + 1;
            pocketIndex %= pocketCount;
        }
        return pockets;
    }

    private JLabel createEmptyLabel() {
        JLabel empty = new JLabel("");
        empty.setBorder(CELLBORDER);
        return empty;
    }

    private void addLocations() {
        LabourData.LocationData unitTotal = this.unitData.getTotal();
        int row = 1;
        JLabel summaryLabel = new JLabel(Messages.message("report.labour.summary", new String[0]));
        summaryLabel.setBorder(LEFTCELLBORDER);
        this.reportPanel.add((Component)summaryLabel, higConst.rcwh(row, this.COLONY_COLUMN, 1, unitTotal.getRowCount()));
        row = this.addLocationData(unitTotal, null, row);
        List<Colony> colonies = this.player.getColonies();
        Collections.sort(colonies, this.getCanvas().getClient().getClientOptions().getColonyComparator());
        for (Colony colony : colonies) {
            LabourData.LocationData colonyData = this.unitData.getDetails().get(colony);
            if (colonyData == null) continue;
            this.reportPanel.add((Component)this.createColonyButton(colony), higConst.rcwh(row, this.COLONY_COLUMN, 1, colonyData.getRowCount()));
            row = this.addLocationData(colonyData, colony, row);
        }
        LabourData.LocationData europe = this.unitData.getUnitsInEurope();
        if (europe.getRowCount() > 0) {
            JButton button = this.createButton(this.player.getEurope().getName(), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ReportLabourPanel.this.getCanvas().showEuropePanel();
                }
            });
            this.reportPanel.add((Component)button, higConst.rcwh(row, this.COLONY_COLUMN, 1, europe.getRowCount()));
            row = this.addLocationData(europe, null, row);
        }
        row = this.addNonLinkedLocation(this.unitData.getUnitsOnLand(), "report.onLand", row);
        row = this.addNonLinkedLocation(this.unitData.getUnitsAtSea(), "report.atSea", row);
        this.reportPanel.add((Component)new JLabel(Messages.message("report.labour.canTrain", new String[0])), higConst.rcwh(row, 1, 10, 1));
    }

    private GoodsType getGoodsType() {
        return this.isSummary() ? null : this.unitData.getUnitType().getExpertProduction();
    }

    private void addHeader() {
        int row = 1;
        JLabel empty = new JLabel("");
        empty.setBorder(TOPLEFTCELLBORDER);
        this.headerRow.add((Component)empty, higConst.rc(row, this.COLONY_COLUMN));
        if (this.isOverview() || !this.unitData.isSummary()) {
            JLabel unitType = new JLabel(Messages.message("model.unit.type", new String[0]));
            unitType.setBorder(TOPCELLBORDER);
            this.headerRow.add((Component)unitType, higConst.rc(row, this.UNIT_TYPE_COLUMN));
        }
        JLabel workingAs = new JLabel(Messages.message("model.unit.workingAs", new String[0]));
        workingAs.setBorder(TOPCELLBORDER);
        this.headerRow.add((Component)workingAs, higConst.rc(row, this.WORKING_COLUMN));
        if (this.showBuildings) {
            JLabel building = new JLabel(Messages.message("building", new String[0]));
            building.setBorder(TOPCELLBORDER);
            this.headerRow.add((Component)building, higConst.rc(row, this.BUILDING_COLUMN));
        }
        JLabel colonists = new JLabel(Messages.message("colonists", new String[0]));
        colonists.setBorder(TOPCELLBORDER);
        this.headerRow.add((Component)colonists, higConst.rcwh(row, this.COLONIST_COLUMN, 2, 1));
        if (this.isOverview()) {
            JLabel production = new JLabel(Messages.message("report.production", new String[0]));
            production.setBorder(TOPCELLBORDER);
            this.headerRow.add((Component)production, higConst.rcwh(row, this.PRODUCTION_SYMBOL_COLUMN, 4, 1));
        } else if (this.showProduction) {
            LabourData.UnitData unit = this.unitData;
            GoodsType goods = unit.getExpertProduction();
            ImageLibrary imageLibrary = this.getCanvas().getGUI().getImageLibrary();
            JLabel production = new JLabel(imageLibrary.getGoodsImageIcon(goods));
            production.setBorder(TOPCELLBORDER);
            this.headerRow.add((Component)production, higConst.rcwh(row, this.PRODUCTION_SYMBOL_COLUMN, !goods.isStoredAs() ? 4 : 3, 1));
            if (this.showNetProduction && goods.isStoredAs()) {
                JLabel netProduction = new JLabel(imageLibrary.getGoodsImageIcon(goods.getStoredAs()));
                netProduction.setBorder(TOPCELLBORDER);
                this.headerRow.add((Component)netProduction, higConst.rc(row, this.NETPRODUCTION_SUMMARY_COLUMN));
            }
        }
        if (!this.isSummary()) {
            ImageIcon icon = this.getUnitIcon(this.unitData.getUnitType());
            this.header.setIcon(icon);
            this.header.setIconTextGap(20);
        }
    }

    private int addNonLinkedLocation(LabourData.LocationData data, String messageKey, int row) {
        int rows = data.getRowCount();
        if (rows > 0) {
            JLabel label = new JLabel(Messages.message(messageKey, new String[0]));
            label.setBorder(LEFTCELLBORDER);
            label.setForeground(Color.GRAY);
            this.reportPanel.add((Component)label, higConst.rcwh(row, this.COLONY_COLUMN, 1, rows));
            return this.addLocationData(data, null, row);
        }
        return row;
    }

    private int addLocationData(LabourData.LocationData data, Colony colony, int row) {
        int studentCount;
        Building schoolhouse;
        boolean allColonists = data.getUnitData().isSummary();
        LabourData.UnitData unit = data.getUnitData();
        UnitType unitType = unit.getUnitType();
        String unitName = unit.getUnitName();
        String workingAs = null;
        Building productionBuilding = null;
        if (!allColonists) {
            GoodsType expert;
            workingAs = Messages.message(unitType.getId() + ".workingAs", new String[0]);
            if (colony != null && (expert = unitType.getExpertProduction()) != null) {
                productionBuilding = colony.getBuildingForProducing(expert);
            }
        }
        this.addLocationSummary(data, row);
        int buildingStartRow = row;
        int otherAmateurs = data.getOtherWorkingAmateurs().getColonists();
        if (!allColonists && otherAmateurs > 0) {
            this.addRow(data, Messages.message("report.labour.otherUnitType", new String[0]), workingAs, this.createNonCountedLabel(otherAmateurs), data.getOtherWorkingAmateurs().getProduction(), row);
            ++row;
        }
        int notProducingStartRow = row = this.addRow(data, unitName, allColonists ? Messages.message("report.labour.expertsWorking", new String[0]) : workingAs, data.getWorkingProfessionals().getColonists(), data.getWorkingProfessionals().getProduction(), row);
        if (this.showBuildings && productionBuilding != null && row > buildingStartRow) {
            JLabel buildingLabel = new JLabel(productionBuilding.getName());
            buildingLabel.setBorder(CELLBORDER);
            this.reportPanel.add((Component)buildingLabel, higConst.rcwh(buildingStartRow, this.BUILDING_COLUMN, 1, row - buildingStartRow));
            buildingStartRow = row;
        }
        row = this.addRow(data, unitName, Messages.message(allColonists ? "report.labour.amateursWorking" : "report.labour.workingAsOther", new String[0]), data.getWorkingAmateurs(), 0, row);
        if (data.getNotWorking() > 0) {
            this.addRow(data, unitName, Messages.message("report.labour.notWorking", new String[0]), this.createNumberLabel(data.getNotWorking(), "report.labour.notWorking.tooltip"), 0, row);
            ++row;
        }
        Building building = schoolhouse = colony != null && data.isTraining() ? colony.getBuildingWithAbility("model.ability.teach") : null;
        if (this.showBuildings && schoolhouse != null && row > buildingStartRow) {
            this.reportPanel.add((Component)this.createEmptyLabel(), higConst.rcwh(buildingStartRow, this.BUILDING_COLUMN, 1, row - buildingStartRow));
            buildingStartRow = row;
        }
        row = this.addRow(data, unitName, Messages.message("report.labour.teacher", new String[0]), data.getTeachers(), 0, row);
        if (!allColonists) {
            row = this.addRow(data, data.getOtherStudentsName(), Messages.message("report.labour.learning", "%unit%", data.getUnitData().getUnitName()), data.getOtherStudents(), 0, row);
        }
        if ((studentCount = data.getStudents()) > 0) {
            if (allColonists) {
                this.addRow(data, null, Messages.message("report.labour.sutdent", new String[0]), this.createNonCountedLabel(studentCount), 0, row);
            } else {
                LinkedHashSet<UnitType> resultOfTraining = new LinkedHashSet<UnitType>();
                if (colony != null) {
                    for (Unit teacher : colony.getTeachers()) {
                        Unit student = teacher.getStudent();
                        if (student == null || student.getType() != unitType) continue;
                        resultOfTraining.add(Unit.getUnitTypeTeaching(teacher.getType(), student.getType()));
                    }
                }
                String student = resultOfTraining.size() == 1 ? Messages.message("report.labour.learning", "%unit%", ((UnitType)resultOfTraining.iterator().next()).getName()) : Messages.message("report.labour.learningOther", new String[0]);
                this.addRow(data, data.getUnitData().getUnitName(), student, this.createNumberLabel(-studentCount, "report.labour.subtracted.tooltip"), 0, row);
            }
            ++row;
        }
        if (this.showBuildings && row > buildingStartRow) {
            JLabel buildingLabel = new JLabel(schoolhouse != null ? schoolhouse.getName() : "");
            buildingLabel.setBorder(CELLBORDER);
            this.reportPanel.add((Component)buildingLabel, higConst.rcwh(buildingStartRow, this.BUILDING_COLUMN, 1, row - buildingStartRow));
        }
        if (data.getUnitData().showProduction() && row > notProducingStartRow) {
            this.reportPanel.add((Component)this.createEmptyLabel(), higConst.rcwh(notProducingStartRow, this.PRODUCTION_COLUMN, 1, row - notProducingStartRow));
        }
        return row;
    }

    private void addLocationSummary(LabourData.LocationData data, int row) {
        int rows = data.getRowCount();
        JLabel colonistsLabel = this.createNumberLabel(data.getTotalColonists(), null);
        if (data.getUnitData().isSummary()) {
            if (this.isOverview()) {
                this.reportPanel.add((Component)this.createEmptyLabel(), higConst.rcwh(row, this.UNIT_TYPE_COLUMN, 1, rows));
            }
        } else {
            colonistsLabel.setToolTipText(Messages.message("report.labour.unitTotal.tooltip", "%unit%", data.getUnitData().getUnitName()));
        }
        this.reportPanel.add((Component)colonistsLabel, higConst.rcwh(row, this.COLONIST_SUMMARY_COLUMN, 1, data.getRowCount()));
        if (this.showProduction && !data.getUnitData().showProduction()) {
            this.reportPanel.add((Component)this.createEmptyLabel(), higConst.rcwh(row, this.PRODUCTION_SYMBOL_COLUMN, 4, rows));
            return;
        }
        if (this.showProduction) {
            JLabel productionLabel = this.createNumberLabel(data.getTotalProduction(), "report.labour.potentialProduction.tooltip");
            if (!data.isTotal() && data.getTotalProduction() == 0) {
                productionLabel.setText("");
            }
            this.reportPanel.add((Component)productionLabel, higConst.rcwh(row, this.PRODUCTION_SUMMARY_COLUMN, 1, rows));
        }
        if (this.showNetProduction) {
            int net = data.getNetProduction();
            JLabel netProductionLabel = this.createNumberLabel(net, "report.labour.netProduction.tooltip");
            if (!data.getUnitData().showNetProduction() || !data.isTotal() && net == 0) {
                netProductionLabel.setText("");
                netProductionLabel.setToolTipText("");
            } else if (net >= 0) {
                netProductionLabel.setText("+" + net);
            } else {
                netProductionLabel.setForeground(Color.RED);
            }
            this.reportPanel.add((Component)netProductionLabel, higConst.rcwh(row, this.NETPRODUCTION_SUMMARY_COLUMN, 1, rows));
        }
        if (this.showProductionSymbols) {
            JLabel icon = new JLabel();
            icon.setBorder(CELLBORDER);
            GoodsType goods = data.getUnitData().getExpertProduction();
            if (goods != null) {
                ImageLibrary imageLibrary = this.getCanvas().getGUI().getImageLibrary();
                icon.setIcon(imageLibrary.getGoodsImageIcon(goods));
            }
            this.reportPanel.add((Component)icon, higConst.rcwh(row, this.PRODUCTION_SYMBOL_COLUMN, 1, rows));
        }
    }

    private JLabel createNonCountedLabel(int otherAmateurs) {
        JLabel label = this.createNumberLabel(otherAmateurs, "report.labour.notCounted.tooltip");
        label.setForeground(Color.GRAY);
        return label;
    }

    private JLabel createNumberLabel(int number, String toolTipKey) {
        JLabel label = new JLabel(String.valueOf(number));
        label.setHorizontalAlignment(11);
        label.setBorder(CELLBORDER);
        if (toolTipKey != null) {
            label.setToolTipText(Messages.message(toolTipKey, new String[0]));
        }
        return label;
    }

    private int addRow(LabourData.LocationData data, String typeName, String activity, int colonists, int production, int row) {
        if (colonists > 0) {
            this.addRow(data, typeName, activity, this.createNumberLabel(colonists, null), production, row);
            ++row;
        }
        return row;
    }

    private void addRow(LabourData.LocationData data, String typeName, String activity, JLabel colonistLabel, int production, int row) {
        if (!data.getUnitData().isSummary()) {
            JLabel typeLabel = new JLabel(typeName);
            typeLabel.setBorder(CELLBORDER);
            this.reportPanel.add((Component)typeLabel, higConst.rc(row, this.UNIT_TYPE_COLUMN));
        }
        JLabel activityLabel = new JLabel(activity);
        activityLabel.setBorder(CELLBORDER);
        this.reportPanel.add((Component)activityLabel, higConst.rc(row, this.WORKING_COLUMN));
        this.reportPanel.add((Component)colonistLabel, higConst.rc(row, this.COLONIST_COLUMN));
        if (data.getUnitData().showProduction() && production > 0) {
            this.reportPanel.add((Component)this.createNumberLabel(production, "report.labour.potentialProduction.tooltip"), higConst.rc(row, this.PRODUCTION_COLUMN));
        }
    }

    private JButton createColonyButton(final Colony colony) {
        String text = colony.getName();
        if (!this.unitData.isSummary() && colony.canTrain(this.unitData.getUnitType())) {
            text = text + "*";
        }
        return this.createButton(text, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ReportLabourPanel.this.getCanvas().showColonyPanel(colony);
            }
        });
    }

    private JButton createUnitNameButton(String name, final LabourData.UnitData unitData) {
        JButton button = this.createButton(name, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ReportLabourPanel details = new ReportLabourPanel(ReportLabourPanel.this.getCanvas(), unitData);
                details.initialize();
                ReportLabourPanel.this.getCanvas().addAsFrame(details);
                details.requestFocus();
            }
        });
        if (!unitData.isSummary()) {
            button.setIcon(this.getUnitIcon(unitData.getUnitType()));
        }
        return button;
    }

    private JButton createButton(String name, ActionListener listener) {
        JButton button = new JButton(name);
        button.setMargin(new Insets(0, 0, 0, 0));
        button.setOpaque(false);
        button.setHorizontalAlignment(10);
        button.setForeground(LINK_COLOR);
        button.setBorder(LEFTCELLBORDER);
        button.addActionListener(listener);
        return button;
    }
}

