/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Comparator;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.common.model.Unit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportPanel
extends FreeColPanel
implements ActionListener {
    protected static final Logger logger = Logger.getLogger(ReportPanel.class.getName());
    protected static final int OK = -1;
    protected JPanel reportPanel;
    protected JLabel header;
    protected JButton ok;
    protected JScrollPane scrollPane;
    private static ImageLibrary library;
    private static final Comparator<Unit> unitTypeComparator;

    public ReportPanel(Canvas parent, String title) {
        super(parent, new FlowLayout(1, 1000, 10));
        library = this.getCanvas().getGUI().getImageLibrary();
        this.setLayout(new BorderLayout());
        this.header = ReportPanel.getDefaultHeader(title);
        this.add((Component)this.header, "North");
        this.reportPanel = new JPanel();
        this.reportPanel.setOpaque(true);
        this.reportPanel.setBorder(this.createBorder());
        this.scrollPane = new JScrollPane(this.reportPanel, 20, 30);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(16);
        this.add((Component)this.scrollPane, "Center");
        this.ok = new JButton(Messages.message("ok", new String[0]));
        this.ok.setActionCommand(String.valueOf(-1));
        this.ok.addActionListener(this);
        ReportPanel.enterPressesWhenFocused(this.ok);
        this.setCancelComponent(this.ok);
        this.add((Component)this.ok, "South");
        this.setSize(850, 600);
    }

    protected Border createBorder() {
        return new EmptyBorder(20, 20, 20, 20);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(850, 600);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void initialize() {
        this.reportPanel.removeAll();
        this.reportPanel.doLayout();
    }

    @Override
    public void requestFocus() {
        this.ok.requestFocus();
    }

    public ImageLibrary getLibrary() {
        return library;
    }

    public Comparator<Unit> getUnitTypeComparator() {
        return unitTypeComparator;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        int action = Integer.valueOf(command);
        if (action == -1) {
            this.getCanvas().remove(this);
        } else {
            logger.warning("Invalid ActionCommand: " + action);
        }
    }

    static {
        unitTypeComparator = new Comparator<Unit>(){

            @Override
            public int compare(Unit unit1, Unit unit2) {
                int deltaType = unit2.getType().getIndex() - unit1.getType().getIndex();
                if (deltaType == 0) {
                    return unit2.getRole().ordinal() - unit1.getRole().ordinal();
                }
                return deltaType;
            }
        };
    }
}

