/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.GoodsLabel;
import net.sf.freecol.client.gui.panel.ReportPanel;
import net.sf.freecol.client.gui.panel.UnitLabel;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Unit;

public final class ReportProductionPanel
extends JPanel
implements ActionListener {
    private final int extraRows = 2;
    private final int columnSeparatorWidth = 12;
    private final int marginWidth = 12;
    private Canvas parent;
    private List<Colony> colonies;
    private final GoodsType goodsType;
    private final ReportPanel reportPanel;
    private int totalProduction;

    public ReportProductionPanel(GoodsType goodsType, Canvas parent, ReportPanel reportPanel) {
        this.goodsType = goodsType;
        this.parent = parent;
        this.reportPanel = reportPanel;
        this.setOpaque(false);
    }

    public void initialize() {
        Player player = this.parent.getClient().getMyPlayer();
        int columns = 3;
        if (this.goodsType == Goods.BELLS) {
            columns += 5;
        }
        int[] buildingCount = new int[FreeCol.getSpecification().numberOfBuildingTypes()];
        ArrayList<BuildingType> buildingTypes = new ArrayList<BuildingType>();
        for (BuildingType buildingType : FreeCol.getSpecification().getBuildingTypeList()) {
            if (buildingType.getProducedGoodsType() != this.goodsType && buildingType.getModifierSet(this.goodsType.getId()).isEmpty() || buildingType.getGoodsRequired().isEmpty()) continue;
            buildingTypes.add(buildingType);
            buildingCount[buildingType.getIndex()] = 0;
        }
        columns += buildingTypes.size();
        int colonyColumn = 1;
        int productionColumn = 2;
        int unitColumn = 3;
        int buildingColumn = 4;
        int percentageColumn = buildingColumn + buildingTypes.size();
        int solColumn = percentageColumn + 1;
        int toryColumn = solColumn + 1;
        int percent50Column = toryColumn + 1;
        int percent100Column = percent50Column + 1;
        this.removeAll();
        this.colonies = player.getColonies();
        int numberOfColonies = this.colonies.size();
        int[] widths = new int[columns];
        int[] heights = new int[numberOfColonies + 2];
        Arrays.fill(heights, 0, heights.length, 64);
        HIGConstraints higConst = new HIGConstraints();
        this.setLayout(new HIGLayout(widths, heights));
        JLabel newLabel = new JLabel(Messages.message("Colony", new String[0]));
        newLabel.setBorder(FreeColPanel.TOPLEFTCELLBORDER);
        this.add((Component)newLabel, higConst.rc(1, colonyColumn));
        newLabel = new JLabel(Messages.message("report.production", new String[0]));
        newLabel.setBorder(FreeColPanel.TOPCELLBORDER);
        this.add((Component)newLabel, higConst.rc(1, productionColumn));
        newLabel = new JLabel(Messages.message("report.units", new String[0]));
        newLabel.setBorder(FreeColPanel.TOPCELLBORDER);
        this.add((Component)newLabel, higConst.rc(1, unitColumn));
        int column = buildingColumn;
        for (BuildingType buildingType : buildingTypes) {
            newLabel = new JLabel(buildingType.getName());
            newLabel.setBorder(FreeColPanel.TOPCELLBORDER);
            this.add((Component)newLabel, higConst.rc(1, column));
            ++column;
        }
        if (this.goodsType == Goods.BELLS) {
            newLabel = new JLabel(Messages.message("sonsOfLiberty", new String[0]) + "%");
            newLabel.setBorder(FreeColPanel.TOPCELLBORDER);
            this.add((Component)newLabel, higConst.rc(1, percentageColumn));
            newLabel = new JLabel(Messages.message("sonsOfLiberty", new String[0]));
            newLabel.setBorder(FreeColPanel.TOPCELLBORDER);
            this.add((Component)newLabel, higConst.rc(1, solColumn));
            newLabel = new JLabel(Messages.message("tory", new String[0]));
            newLabel.setBorder(FreeColPanel.TOPCELLBORDER);
            this.add((Component)newLabel, higConst.rc(1, toryColumn));
            newLabel = new JLabel("50%");
            newLabel.setToolTipText(Messages.message("report.50percent", new String[0]));
            newLabel.setBorder(FreeColPanel.TOPCELLBORDER);
            this.add((Component)newLabel, higConst.rc(1, percent50Column));
            newLabel = new JLabel("100%");
            newLabel.setToolTipText(Messages.message("report.100percent", new String[0]));
            newLabel.setBorder(FreeColPanel.TOPCELLBORDER);
            this.add((Component)newLabel, higConst.rc(1, percent100Column));
        }
        int row = 3;
        this.totalProduction = 0;
        int totalUnits = 0;
        int percentageCount = 0;
        int solCount = 0;
        int toryCount = 0;
        Collections.sort(this.colonies, this.parent.getClient().getClientOptions().getColonyComparator());
        for (int colonyIndex = 0; colonyIndex < this.colonies.size(); ++colonyIndex) {
            Colony colony = this.colonies.get(colonyIndex);
            this.add((Component)this.createColonyButton(colonyIndex), higConst.rc(row, colonyColumn));
            int newValue = colony.getProductionOf(this.goodsType);
            if (this.goodsType == Goods.BELLS) {
                newValue -= colony.getBellUpkeep();
            }
            this.totalProduction += newValue;
            Goods goods = new Goods(colony.getGame(), colony, this.goodsType, newValue);
            GoodsLabel goodsLabel = new GoodsLabel(goods, this.parent);
            goodsLabel.setHorizontalAlignment(10);
            goodsLabel.setBorder(FreeColPanel.CELLBORDER);
            this.add((Component)goodsLabel, higConst.rc(row, productionColumn));
            Building building = colony.getBuildingForProducing(this.goodsType);
            JPanel unitPanel = new JPanel();
            unitPanel.setBorder(FreeColPanel.CELLBORDER);
            unitPanel.setOpaque(false);
            if (building != null) {
                Iterator<Unit> unitIterator = building.getUnitIterator();
                while (unitIterator.hasNext()) {
                    Unit unit = unitIterator.next();
                    UnitLabel label = new UnitLabel(unit, this.parent, true);
                    unitPanel.add(label);
                    ++totalUnits;
                }
            }
            this.add((Component)unitPanel, higConst.rc(row, unitColumn));
            column = buildingColumn;
            for (BuildingType buildingType : buildingTypes) {
                Building b = colony.getBuilding(buildingType);
                int level = 0;
                if (b != null) {
                    level = b.getLevel();
                }
                newLabel = new JLabel();
                newLabel.setBorder(FreeColPanel.CELLBORDER);
                if (level == buildingType.getLevel()) {
                    newLabel.setText("X");
                    int n = buildingType.getIndex();
                    buildingCount[n] = buildingCount[n] + 1;
                }
                this.add((Component)newLabel, higConst.rc(row, column));
                ++column;
            }
            if (this.goodsType == Goods.BELLS) {
                int turns;
                int required;
                int percentage = colony.getSoL();
                percentageCount += percentage;
                int count = colony.getUnitCount();
                int sol = percentage * count / 100;
                solCount += sol;
                int tories = count - sol;
                toryCount += tories;
                newLabel = new JLabel(String.valueOf(percentage), 11);
                newLabel.setBorder(FreeColPanel.CELLBORDER);
                this.add((Component)newLabel, higConst.rc(row, percentageColumn));
                newLabel = new JLabel(String.valueOf(sol), 11);
                newLabel.setBorder(FreeColPanel.CELLBORDER);
                this.add((Component)newLabel, higConst.rc(row, solColumn));
                newLabel = new JLabel(String.valueOf(tories), 11);
                newLabel.setBorder(FreeColPanel.CELLBORDER);
                this.add((Component)newLabel, higConst.rc(row, toryColumn));
                if (newValue > 0 && percentage < 50) {
                    required = 200 * count / 2;
                    turns = required / newValue;
                    if (required % newValue > 0) {
                        ++turns;
                    }
                    newLabel = new JLabel(String.valueOf(turns), 11);
                    newLabel.setBorder(FreeColPanel.CELLBORDER);
                    this.add((Component)newLabel, higConst.rc(row, percent50Column));
                } else {
                    newLabel = new JLabel();
                    newLabel.setBorder(FreeColPanel.CELLBORDER);
                    this.add((Component)newLabel, higConst.rc(row, percent50Column));
                }
                if (newValue > 0 && percentage < 100) {
                    required = 200 * count;
                    turns = required / newValue;
                    if (required % newValue > 0) {
                        ++turns;
                    }
                    newLabel = new JLabel(String.valueOf(turns), 11);
                    newLabel.setBorder(FreeColPanel.CELLBORDER);
                    this.add((Component)newLabel, higConst.rc(row, percent100Column));
                } else {
                    newLabel = new JLabel();
                    newLabel.setBorder(FreeColPanel.CELLBORDER);
                    this.add((Component)newLabel, higConst.rc(row, percent100Column));
                }
            }
            ++row;
        }
        row = 2;
        JLabel allColonies = new JLabel(Messages.message("report.allColonies", "%number%", String.valueOf(numberOfColonies)));
        allColonies.setForeground(Color.BLUE);
        allColonies.setBorder(FreeColPanel.LEFTCELLBORDER);
        this.add((Component)allColonies, higConst.rc(row, colonyColumn));
        Goods allGoods = new Goods(this.parent.getClient().getGame(), null, this.goodsType, this.totalProduction);
        GoodsLabel allGoodsLabel = new GoodsLabel(allGoods, this.parent);
        allGoodsLabel.setHorizontalAlignment(10);
        allGoodsLabel.setBorder(FreeColPanel.CELLBORDER);
        this.add((Component)allGoodsLabel, higConst.rc(row, productionColumn));
        newLabel = new JLabel(String.valueOf(totalUnits));
        newLabel.setBorder(FreeColPanel.CELLBORDER);
        this.add((Component)newLabel, higConst.rc(row, unitColumn));
        column = buildingColumn;
        for (BuildingType buildingType : buildingTypes) {
            int count = buildingCount[buildingType.getIndex()];
            newLabel = new JLabel(String.valueOf(count), 11);
            newLabel.setBorder(FreeColPanel.CELLBORDER);
            this.add((Component)newLabel, higConst.rc(row, column));
            ++column;
        }
        if (this.goodsType == Goods.BELLS) {
            int percentage = 0;
            if (numberOfColonies > 0) {
                percentage = percentageCount / numberOfColonies;
            }
            newLabel = new JLabel(String.valueOf(percentage), 11);
            newLabel.setBorder(FreeColPanel.CELLBORDER);
            this.add((Component)newLabel, higConst.rc(row, percentageColumn));
            newLabel = new JLabel(String.valueOf(solCount), 11);
            newLabel.setBorder(FreeColPanel.CELLBORDER);
            this.add((Component)newLabel, higConst.rc(row, solColumn));
            newLabel = new JLabel(String.valueOf(toryCount), 11);
            newLabel.setBorder(FreeColPanel.CELLBORDER);
            this.add((Component)newLabel, higConst.rc(row, toryColumn));
            newLabel = new JLabel();
            newLabel.setBorder(FreeColPanel.CELLBORDER);
            this.add((Component)newLabel, higConst.rc(row, percent50Column));
            newLabel = new JLabel();
            newLabel.setBorder(FreeColPanel.CELLBORDER);
            this.add((Component)newLabel, higConst.rc(row, percent100Column));
        }
    }

    private JButton createColonyButton(int index) {
        JButton button = FreeColPanel.getLinkButton(this.colonies.get(index).getName(), null, String.valueOf(index));
        button.setHorizontalAlignment(10);
        button.setBorder(FreeColPanel.LEFTCELLBORDER);
        button.addActionListener(this);
        return button;
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        int action = Integer.valueOf(command);
        if (action == -1) {
            this.reportPanel.actionPerformed(event);
        } else {
            this.parent.showColonyPanel(this.colonies.get(action));
        }
    }

    public int getTotalProduction() {
        return this.totalProduction;
    }
}

