/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import cz.autel.dmi.HIGLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JTextPane;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.ReportPanel;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;

public final class ReportRequirementsPanel
extends ReportPanel {
    private List<Colony> colonies;
    private int[][] unitCount;
    private boolean[][] canTrain;
    private int[][] surplus;

    public ReportRequirementsPanel(Canvas parent) {
        super(parent, Messages.message("menuBar.report.requirements", new String[0]));
    }

    public void initialize() {
        Colony colony;
        int index;
        Player player = this.getCanvas().getClient().getMyPlayer();
        this.colonies = player.getColonies();
        Collections.sort(this.colonies, this.getCanvas().getClient().getClientOptions().getColonyComparator());
        this.reportPanel.setLayout(new HIGLayout(new int[]{780}, new int[]{0}));
        JTextPane textPane = ReportRequirementsPanel.getDefaultTextPane();
        StyledDocument doc = textPane.getStyledDocument();
        int numberUnitTypes = FreeCol.getSpecification().numberOfUnitTypes();
        int numberGoodsTypes = FreeCol.getSpecification().numberOfGoodsTypes();
        this.unitCount = new int[this.colonies.size()][numberUnitTypes];
        this.canTrain = new boolean[this.colonies.size()][numberUnitTypes];
        this.surplus = new int[this.colonies.size()][numberGoodsTypes];
        List<GoodsType> goodsTypes = FreeCol.getSpecification().getGoodsTypeList();
        for (index = 0; index < this.colonies.size(); ++index) {
            colony = this.colonies.get(index);
            for (Unit unit : colony.getUnitList()) {
                int[] nArray = this.unitCount[index];
                int n = unit.getType().getIndex();
                nArray[n] = nArray[n] + 1;
                this.canTrain[index][unit.getType().getIndex()] = colony.canTrain(unit.getType());
            }
            for (GoodsType goodsType : goodsTypes) {
                this.surplus[index][goodsType.getIndex()] = colony.getProductionNetOf(goodsType);
            }
        }
        for (index = 0; index < this.colonies.size(); ++index) {
            colony = this.colonies.get(index);
            try {
                StyleConstants.setComponent(doc.getStyle("button"), this.createColonyButton(colony, true));
                doc.insertString(doc.getLength(), " ", doc.getStyle("button"));
                doc.insertString(doc.getLength(), "\n\n", doc.getStyle("regular"));
            }
            catch (Exception e) {
                logger.warning(e.toString());
            }
            boolean[] expertWarning = new boolean[numberUnitTypes];
            boolean[] productionWarning = new boolean[numberGoodsTypes];
            boolean hasWarning = false;
            for (ColonyTile colonyTile : colony.getColonyTiles()) {
                Unit unit = colonyTile.getUnit();
                if (unit == null) continue;
                GoodsType workType = unit.getWorkType();
                UnitType expert = FreeCol.getSpecification().getExpertForProducing(workType);
                int expertIndex = expert.getIndex();
                if (this.unitCount[index][expertIndex] != 0 || expertWarning[expertIndex]) continue;
                this.addExpertWarning(doc, index, workType.getName(), expert);
                expertWarning[expertIndex] = true;
                hasWarning = true;
            }
            for (Building building : colony.getBuildings()) {
                GoodsType goodsType = building.getGoodsOutputType();
                UnitType expert = building.getExpertUnitType();
                if (goodsType != null && expert != null) {
                    int expertIndex = expert.getIndex();
                    if (building.getFirstUnit() != null && !expertWarning[expertIndex] && this.unitCount[index][expertIndex] == 0) {
                        this.addExpertWarning(doc, index, goodsType.getName(), expert);
                        expertWarning[expertIndex] = true;
                        hasWarning = true;
                    }
                }
                if (goodsType == null) continue;
                int goodsIndex = goodsType.getIndex();
                if (building.getProductionNextTurn() >= building.getMaximumProduction() || productionWarning[goodsIndex]) continue;
                this.addProductionWarning(doc, index, goodsType, building.getGoodsInputType());
                productionWarning[goodsIndex] = true;
                hasWarning = true;
            }
            if (!hasWarning) {
                try {
                    doc.insertString(doc.getLength(), Messages.message("report.requirements.met", new String[0]) + "\n\n", doc.getStyle("regular"));
                }
                catch (Exception e) {
                    logger.warning(e.toString());
                }
            }
            this.reportPanel.add((Component)textPane, higConst.rc(1, 1));
        }
        textPane.setCaretPosition(0);
    }

    private void addExpertWarning(StyledDocument doc, int colonyIndex, String goods, UnitType workType) {
        String expertName = workType.getName();
        String colonyName = this.colonies.get(colonyIndex).getName();
        String newMessage = Messages.message("report.requirements.noExpert", "%colony%", colonyName, "%goods%", goods, "%unit%", expertName);
        try {
            Colony colony;
            int index;
            doc.insertString(doc.getLength(), newMessage + "\n\n", doc.getStyle("regular"));
            ArrayList<Colony> severalExperts = new ArrayList<Colony>();
            ArrayList<Colony> canTrainExperts = new ArrayList<Colony>();
            for (index = 0; index < this.colonies.size(); ++index) {
                if (this.unitCount[index][workType.getIndex()] > 1) {
                    severalExperts.add(this.colonies.get(index));
                }
                if (!this.canTrain[index][workType.getIndex()]) continue;
                canTrainExperts.add(this.colonies.get(index));
            }
            if (!severalExperts.isEmpty()) {
                doc.insertString(doc.getLength(), Messages.message("report.requirements.severalExperts", "%unit%", expertName), doc.getStyle("regular"));
                for (index = 0; index < severalExperts.size() - 1; ++index) {
                    colony = (Colony)severalExperts.get(index);
                    StyleConstants.setComponent(doc.getStyle("button"), this.createColonyButton(colony, false));
                    doc.insertString(doc.getLength(), " ", doc.getStyle("button"));
                    doc.insertString(doc.getLength(), ", ", doc.getStyle("regular"));
                }
                Colony colony2 = (Colony)severalExperts.get(severalExperts.size() - 1);
                StyleConstants.setComponent(doc.getStyle("button"), this.createColonyButton(colony2, false));
                doc.insertString(doc.getLength(), " ", doc.getStyle("button"));
                doc.insertString(doc.getLength(), "\n\n", doc.getStyle("regular"));
            }
            if (!canTrainExperts.isEmpty()) {
                doc.insertString(doc.getLength(), Messages.message("report.requirements.canTrainExperts", "%unit%", expertName), doc.getStyle("regular"));
                for (index = 0; index < canTrainExperts.size() - 1; ++index) {
                    colony = (Colony)canTrainExperts.get(index);
                    StyleConstants.setComponent(doc.getStyle("button"), this.createColonyButton(colony, false));
                    doc.insertString(doc.getLength(), " ", doc.getStyle("button"));
                    doc.insertString(doc.getLength(), ", ", doc.getStyle("regular"));
                }
                Colony colony3 = (Colony)canTrainExperts.get(canTrainExperts.size() - 1);
                StyleConstants.setComponent(doc.getStyle("button"), this.createColonyButton(colony3, false));
                doc.insertString(doc.getLength(), " ", doc.getStyle("button"));
                doc.insertString(doc.getLength(), "\n\n", doc.getStyle("regular"));
            }
        }
        catch (Exception e) {
            logger.warning(e.toString());
        }
    }

    private void addProductionWarning(StyledDocument doc, int colonyIndex, GoodsType output, GoodsType input) {
        String colonyName = this.colonies.get(colonyIndex).getName();
        String newMessage = Messages.message("report.requirements.missingGoods", "%colony%", colonyName, "%goods%", output.getName(), "%input%", input.getName());
        try {
            int index;
            doc.insertString(doc.getLength(), newMessage + "\n\n", doc.getStyle("regular"));
            ArrayList<Colony> withSurplus = new ArrayList<Colony>();
            ArrayList<Integer> theSurplus = new ArrayList<Integer>();
            for (index = 0; index < this.colonies.size(); ++index) {
                if (this.surplus[index][input.getIndex()] <= 0) continue;
                withSurplus.add(this.colonies.get(index));
                theSurplus.add(new Integer(this.surplus[index][input.getIndex()]));
            }
            if (!withSurplus.isEmpty()) {
                doc.insertString(doc.getLength(), Messages.message("report.requirements.surplus", "%goods%", input.getName()) + " ", doc.getStyle("regular"));
                for (index = 0; index < withSurplus.size() - 1; ++index) {
                    Colony colony = (Colony)withSurplus.get(index);
                    String amount = " (" + theSurplus.get(index) + ")";
                    StyleConstants.setComponent(doc.getStyle("button"), this.createColonyButton(colony, amount, false));
                    doc.insertString(doc.getLength(), " ", doc.getStyle("button"));
                    doc.insertString(doc.getLength(), ", ", doc.getStyle("regular"));
                }
                Colony colony = (Colony)withSurplus.get(withSurplus.size() - 1);
                String amount = " (" + theSurplus.get(theSurplus.size() - 1) + ")";
                StyleConstants.setComponent(doc.getStyle("button"), this.createColonyButton(colony, amount, false));
                doc.insertString(doc.getLength(), " ", doc.getStyle("button"));
                doc.insertString(doc.getLength(), "\n\n", doc.getStyle("regular"));
            }
        }
        catch (Exception e) {
            logger.warning(e.toString());
        }
    }

    private JButton createColonyButton(Colony colony, boolean headline) {
        return this.createColonyButton(colony, "", headline);
    }

    private JButton createColonyButton(Colony colony, String info, boolean headline) {
        JButton button = ReportRequirementsPanel.getLinkButton(colony.getName() + info, null, colony.getId());
        if (headline) {
            button.setFont(smallHeaderFont);
        }
        button.addActionListener(this);
        return button;
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals(String.valueOf(-1))) {
            super.actionPerformed(event);
        } else {
            Colony colony = (Colony)this.getCanvas().getClient().getGame().getFreeColGameObject(command);
            if (colony instanceof Colony) {
                this.getCanvas().showColonyPanel(colony);
            }
        }
    }
}

