/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import cz.autel.dmi.HIGLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.MarketLabel;
import net.sf.freecol.client.gui.panel.ReportPanel;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Unit;

public final class ReportTradePanel
extends ReportPanel {
    private static final int extraRows = 7;
    private static final int extraBottomRows = 2;
    private static final int extraColumns = 1;
    private List<GoodsType> storableGoods = new ArrayList<GoodsType>();
    private static final int marginWidth = 12;
    private final JLabel salesLabel;
    private final JLabel beforeTaxesLabel;
    private final JLabel afterTaxesLabel;
    private List<Colony> colonies;
    private final JPanel goodsHeader = new JPanel();

    public ReportTradePanel(Canvas parent) {
        super(parent, Messages.message("menuBar.report.trade", new String[0]));
        this.setSize(this.getMinimumSize());
        this.salesLabel = new JLabel(Messages.message("report.trade.unitsSold", new String[0]), 11);
        this.salesLabel.setBorder(FreeColPanel.LEFTCELLBORDER);
        this.beforeTaxesLabel = new JLabel(Messages.message("report.trade.beforeTaxes", new String[0]), 11);
        this.beforeTaxesLabel.setBorder(FreeColPanel.LEFTCELLBORDER);
        this.afterTaxesLabel = new JLabel(Messages.message("report.trade.afterTaxes", new String[0]), 11);
        this.afterTaxesLabel.setBorder(FreeColPanel.LEFTCELLBORDER);
        this.goodsHeader.setBorder(new EmptyBorder(20, 20, 0, 20));
        this.scrollPane.setColumnHeaderView(this.goodsHeader);
        for (GoodsType goodsType : FreeCol.getSpecification().getGoodsTypeList()) {
            if (!goodsType.isStorable()) continue;
            this.storableGoods.add(goodsType);
        }
    }

    public Dimension getMinimumSize() {
        return new Dimension(900, 750);
    }

    protected Border createBorder() {
        return new EmptyBorder(0, 20, 20, 20);
    }

    public void initialize() {
        Player player = this.getCanvas().getClient().getMyPlayer();
        Market market = player.getMarket();
        this.reportPanel.removeAll();
        this.goodsHeader.removeAll();
        this.colonies = player.getColonies();
        Collections.sort(this.colonies, this.getCanvas().getClient().getClientOptions().getColonyComparator());
        int columns = this.storableGoods.size() + 1;
        int[] widths = new int[columns];
        widths[0] = 170;
        for (int i = 1; i < columns; ++i) {
            widths[i] = 42;
        }
        int[] heights = new int[this.colonies.size() * 2 + 7 + 2];
        int labelColumn = 1;
        heights[6] = 12;
        heights[heights.length - 2] = 12;
        this.reportPanel.setLayout(new HIGLayout(widths, heights));
        this.goodsHeader.setLayout(new HIGLayout(widths, new int[1]));
        JLabel emptyLabel = new JLabel();
        emptyLabel.setBorder(FreeColPanel.TOPLEFTCELLBORDER);
        this.goodsHeader.add((Component)emptyLabel, higConst.rc(1, labelColumn));
        this.reportPanel.add((Component)this.salesLabel, higConst.rc(1, labelColumn));
        this.reportPanel.add((Component)this.beforeTaxesLabel, higConst.rc(2, labelColumn));
        this.reportPanel.add((Component)this.afterTaxesLabel, higConst.rc(3, labelColumn));
        JLabel cargoUnitsLabel = new JLabel(Messages.message("report.trade.cargoUnits", new String[0]), 11);
        cargoUnitsLabel.setBorder(FreeColPanel.LEFTCELLBORDER);
        JLabel totalUnitsLabel = new JLabel(Messages.message("report.trade.totalUnits", new String[0]), 11);
        totalUnitsLabel.setBorder(FreeColPanel.LEFTCELLBORDER);
        JLabel totalDeltaLabel = new JLabel(Messages.message("report.trade.totalDelta", new String[0]), 11);
        totalDeltaLabel.setBorder(FreeColPanel.LEFTCELLBORDER);
        this.reportPanel.add((Component)cargoUnitsLabel, higConst.rc(4, labelColumn));
        this.reportPanel.add((Component)totalUnitsLabel, higConst.rc(5, labelColumn));
        this.reportPanel.add((Component)totalDeltaLabel, higConst.rc(6, labelColumn));
        int column = 1;
        for (GoodsType goodsType : this.storableGoods) {
            ++column;
            int sales = player.getSales(goodsType);
            int beforeTaxes = player.getIncomeBeforeTaxes(goodsType);
            int afterTaxes = player.getIncomeAfterTaxes(goodsType);
            MarketLabel marketLabel = new MarketLabel(goodsType, market, this.getCanvas());
            marketLabel.setBorder(FreeColPanel.TOPCELLBORDER);
            marketLabel.setVerticalTextPosition(3);
            marketLabel.setHorizontalTextPosition(0);
            this.goodsHeader.add((Component)marketLabel, higConst.rc(1, column));
            JLabel currentLabel = new JLabel(String.valueOf(sales), 11);
            currentLabel.setBorder(FreeColPanel.CELLBORDER);
            if (sales < 0) {
                currentLabel.setForeground(Color.RED);
            }
            this.reportPanel.add((Component)currentLabel, higConst.rc(1, column));
            currentLabel = new JLabel(String.valueOf(beforeTaxes), 11);
            currentLabel.setBorder(FreeColPanel.CELLBORDER);
            if (beforeTaxes < 0) {
                currentLabel.setForeground(Color.RED);
            }
            this.reportPanel.add((Component)currentLabel, higConst.rc(2, column));
            currentLabel = new JLabel(String.valueOf(afterTaxes), 11);
            currentLabel.setBorder(FreeColPanel.CELLBORDER);
            if (afterTaxes < 0) {
                currentLabel.setForeground(Color.RED);
            }
            this.reportPanel.add((Component)currentLabel, higConst.rc(3, column));
            int cargoUnits = 0;
            Iterator<Unit> iterator = player.getUnitIterator();
            while (iterator.hasNext()) {
                Unit unit = iterator.next();
                if (!unit.isCarrier()) continue;
                cargoUnits += unit.getGoodsContainer().getGoodsCount(goodsType);
            }
            int totalUnits = cargoUnits;
            int deltaUnits = 0;
            for (Colony colony : this.colonies) {
                deltaUnits += colony.getProductionNetOf(goodsType);
                totalUnits += colony.getGoodsCount(goodsType);
            }
            JLabel cargoUnitsAmount = new JLabel(String.valueOf(cargoUnits), 11);
            cargoUnitsAmount.setBorder(FreeColPanel.CELLBORDER);
            this.reportPanel.add((Component)cargoUnitsAmount, higConst.rc(4, column));
            JLabel totalUnitsAmount = new JLabel(String.valueOf(totalUnits), 11);
            totalUnitsAmount.setBorder(FreeColPanel.CELLBORDER);
            this.reportPanel.add((Component)totalUnitsAmount, higConst.rc(5, column));
            JLabel deltaUnitsAmount = new JLabel(String.valueOf(deltaUnits), 11);
            if (deltaUnits < 0) {
                deltaUnitsAmount.setForeground(Color.RED);
            } else if (deltaUnits > 0) {
                deltaUnitsAmount.setText("+" + deltaUnits);
            }
            deltaUnitsAmount.setBorder(FreeColPanel.CELLBORDER);
            this.reportPanel.add((Component)deltaUnitsAmount, higConst.rc(6, column));
        }
        int row = 8;
        for (int colonyIndex = 0; colonyIndex < this.colonies.size(); ++colonyIndex) {
            Colony colony = this.colonies.get(colonyIndex);
            JButton colonyButton = this.createColonyButton(colonyIndex);
            this.reportPanel.add((Component)colonyButton, higConst.rcwh(row, labelColumn, 1, 2));
            column = 1;
            for (GoodsType goodsType : FreeCol.getSpecification().getGoodsTypeList()) {
                if (!goodsType.isStorable()) continue;
                ++column;
                int amount = colony.getGoodsCount(goodsType);
                JLabel goodsLabel = new JLabel(String.valueOf(amount), 11);
                if (colonyIndex == 0) {
                    goodsLabel.setBorder(FreeColPanel.TOPCELLBORDER);
                } else {
                    goodsLabel.setBorder(FreeColPanel.CELLBORDER);
                }
                if (colony.getExportData(goodsType).isExported()) {
                    goodsLabel.setText("*" + String.valueOf(amount));
                }
                this.reportPanel.add((Component)goodsLabel, higConst.rc(row, column));
                int production = colony.getProductionNetOf(goodsType);
                JLabel productionLabel = new JLabel(String.valueOf(production), 11);
                if (production < 0) {
                    productionLabel.setForeground(Color.RED);
                } else if (production > 0) {
                    productionLabel.setText("+" + production);
                }
                StringBuffer toolTip = new StringBuffer();
                for (String warning : colony.getWarnings(goodsType, amount, production)) {
                    if (toolTip.length() > 0) {
                        toolTip.append(" - ");
                    }
                    toolTip.append(warning);
                    productionLabel.setForeground(Color.MAGENTA);
                    productionLabel.setToolTipText(toolTip.toString());
                }
                productionLabel.setBorder(FreeColPanel.CELLBORDER);
                this.reportPanel.add((Component)productionLabel, higConst.rc(row + 1, column));
            }
            row += 2;
        }
        this.reportPanel.add((Component)new JLabel(Messages.message("report.trade.hasCustomHouse", new String[0])), higConst.rcwh(++row, 1, widths.length, 1));
    }

    private JButton createColonyButton(int index) {
        JButton button = new JButton();
        String name = this.colonies.get(index).getName();
        if (this.colonies.get(index).hasAbility("model.ability.export")) {
            name = name + "*";
        }
        button.setText(name);
        button.setOpaque(false);
        button.setForeground(LINK_COLOR);
        button.setHorizontalAlignment(10);
        button.setAlignmentY(0.8f);
        if (index == 0) {
            button.setBorder(FreeColPanel.TOPLEFTCELLBORDER);
        } else {
            button.setBorder(FreeColPanel.LEFTCELLBORDER);
        }
        button.setActionCommand(String.valueOf(index));
        button.addActionListener(this);
        return button;
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        int action = Integer.valueOf(command);
        if (action == -1) {
            super.actionPerformed(event);
        } else {
            this.getCanvas().showColonyPanel(this.colonies.get(action));
        }
    }
}

