/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import cz.autel.dmi.HIGLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextPane;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import net.sf.freecol.client.ClientOptions;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.ReportPanel;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Nameable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.option.BooleanOption;

public final class ReportTurnPanel
extends ReportPanel {
    public ReportTurnPanel(Canvas parent, ModelMessage ... messages) {
        super(parent, Messages.message("menuBar.report.turn", new String[0]));
        Comparator<ModelMessage> comparator = this.getCanvas().getClient().getClientOptions().getModelMessageComparator();
        if (comparator != null) {
            Arrays.sort(messages, comparator);
        }
        ClientOptions options = this.getCanvas().getClient().getClientOptions();
        int groupBy = options.getInteger("model.option.guiMessagesGroupBy");
        Object source = this;
        ModelMessage.MessageType type = null;
        int headlines = 0;
        for (ModelMessage message : messages) {
            if (groupBy == 2 && message.getSource() != source) {
                source = message.getSource();
                ++headlines;
                continue;
            }
            if (groupBy != 1 || message.getType() == type) continue;
            type = message.getType();
            ++headlines;
        }
        this.reportPanel.removeAll();
        int[] widths = new int[]{0, 3, 500, 3, 0, 3, 0};
        int[] heights = new int[2 * (messages.length + headlines) - 1];
        int imageColumn = 1;
        int textColumn = 3;
        int button1Column = 5;
        int button2Column = 7;
        for (int index = 1; index < heights.length; index += 2) {
            heights[index] = 3;
        }
        HIGLayout layout = new HIGLayout(widths, heights);
        layout.setColumnWeight(textColumn, 1);
        this.reportPanel.setLayout(layout);
        source = this;
        type = null;
        int row = 1;
        for (final ModelMessage message : messages) {
            BooleanOption filterOption;
            if (groupBy == 2 && message.getSource() != source) {
                source = message.getSource();
                this.reportPanel.add((Component)this.getHeadline(source), higConst.rc(row, textColumn, "l"));
                row += 2;
            } else if (groupBy == 1 && message.getType() != type) {
                type = message.getType();
                JLabel headline = new JLabel(message.getTypeName());
                headline.setFont(smallHeaderFont);
                this.reportPanel.add((Component)headline, higConst.rc(row, textColumn, "l"));
                row += 2;
            }
            JComponent component = new JLabel();
            if (message.getDisplay() != null) {
                JButton button;
                ImageIcon icon = this.getCanvas().getImageIcon(message.getDisplay(), false);
                if (icon != null && icon.getIconHeight() > 40) {
                    Image image = icon.getImage();
                    int newWidth = (int)((double)image.getWidth(null) / (double)image.getHeight(null) * 40.0);
                    image = image.getScaledInstance(newWidth, 40, 4);
                    icon.setImage(image);
                }
                if (message.getDisplay() instanceof Colony) {
                    button = new JButton();
                    button.setIcon(icon);
                    button.setActionCommand(((Colony)message.getDisplay()).getId());
                    button.addActionListener(this);
                    button.setBorder(BorderFactory.createEmptyBorder());
                    component = button;
                } else if (message.getDisplay() instanceof Unit) {
                    button = new JButton();
                    button.setIcon(icon);
                    button.setActionCommand(((Unit)message.getDisplay()).getLocation().getId());
                    button.addActionListener(this);
                    button.setBorder(BorderFactory.createEmptyBorder());
                    component = button;
                } else {
                    component = message.getDisplay() instanceof Player ? new JLabel(icon) : new JLabel(icon);
                }
                this.reportPanel.add((Component)component, higConst.rc(row, imageColumn, ""));
            }
            final JTextPane textPane = ReportTurnPanel.getDefaultTextPane();
            this.insertMessage(textPane.getStyledDocument(), message, this.getCanvas().getClient().getMyPlayer());
            final JLabel label = component;
            this.reportPanel.add((Component)textPane, higConst.rc(row, textColumn));
            if (message.getType() == ModelMessage.MessageType.WAREHOUSE_CAPACITY) {
                JButton ignoreButton = new JButton("x");
                ignoreButton.setToolTipText(Messages.message("model.message.ignore", message.getData()));
                ignoreButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent event) {
                        boolean flag = label.isEnabled();
                        ReportTurnPanel.this.getCanvas().getClient().getInGameController().ignoreMessage(message, flag);
                        textPane.setEnabled(!flag);
                        label.setEnabled(!flag);
                    }
                });
                this.reportPanel.add((Component)ignoreButton, higConst.rc(row, button1Column, ""));
            }
            if ((filterOption = options.getBooleanOption(message)) != null) {
                JButton filterButton = new JButton("X");
                filterButton.setToolTipText(Messages.message("model.message.filter", "%type%", message.getTypeName()));
                filterButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent event) {
                        boolean flag = filterOption.getValue();
                        filterOption.setValue(!flag);
                        textPane.setEnabled(!flag);
                        label.setEnabled(!flag);
                    }
                });
                this.reportPanel.add((Component)filterButton, higConst.rc(row, button2Column, ""));
            }
            row += 2;
        }
    }

    private JComponent getHeadline(Object source) {
        JComponent headline;
        if (source == null) {
            return new JLabel();
        }
        if (source instanceof Player) {
            Player player = (Player)source;
            headline = new JLabel(Messages.message("playerNation", "%player%", player.getName(), "%nation%", player.getNationAsString()));
        } else if (source instanceof Europe) {
            Europe europe = (Europe)source;
            JButton button = new JButton(europe.getName());
            button.addActionListener(this);
            button.setActionCommand(europe.getId());
            headline = button;
        } else if (source instanceof Market) {
            JButton button = new JButton(Messages.message("model.message.marketPrices", new String[0]));
            button.addActionListener(this);
            button.setActionCommand(this.getCanvas().getClient().getMyPlayer().getEurope().getId());
            headline = button;
        } else if (source instanceof Colony) {
            Colony colony = (Colony)source;
            JButton button = new JButton(colony.getName());
            button.addActionListener(this);
            button.setActionCommand(colony.getId());
            headline = button;
        } else if (source instanceof Unit) {
            Unit unit = (Unit)source;
            JButton button = new JButton(unit.getName());
            button.addActionListener(this);
            button.setActionCommand(unit.getLocation().getId());
            headline = button;
        } else {
            headline = source instanceof Nameable ? new JLabel(((Nameable)source).getName()) : new JLabel(source.toString());
        }
        headline.setFont(smallHeaderFont);
        headline.setOpaque(false);
        headline.setForeground(LINK_COLOR);
        headline.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        return headline;
    }

    private void insertMessage(StyledDocument document, ModelMessage message, Player player) {
        try {
            int end;
            String input = Messages.message(message.getId(), new String[0]);
            int start = input.indexOf(37);
            if (start == -1) {
                this.insertText(document, input.substring(0));
                return;
            }
            if (start > 0) {
                this.insertText(document, input.substring(0, start));
            }
            while ((end = input.indexOf(37, start + 1)) >= 0) {
                String var = input.substring(start, end + 1);
                String[] item = this.findReplacementData(message, var);
                if (item != null && var.equals(item[0])) {
                    if (var.equals("%colony%")) {
                        Colony colony = player.getColony(item[1]);
                        if (colony != null) {
                            this.insertLinkButton(document, colony, item[1]);
                        } else if (message.getSource() instanceof Tile) {
                            this.insertLinkButton(document, message.getSource(), item[1]);
                        } else {
                            this.insertText(document, item[1]);
                        }
                    } else if (var.equals("%europe%")) {
                        this.insertLinkButton(document, player.getEurope(), player.getEurope().getName());
                    } else if (var.equals("%unit%") || var.equals("%newName%")) {
                        Tile tile = null;
                        if (message.getSource() instanceof Unit) {
                            tile = ((Unit)message.getSource()).getTile();
                        } else if (message.getSource() instanceof Tile) {
                            tile = (Tile)message.getSource();
                        }
                        if (tile != null) {
                            this.insertLinkButton(document, tile, item[1]);
                        } else {
                            this.insertText(document, item[1]);
                        }
                    } else {
                        this.insertText(document, item[1]);
                    }
                    start = end + 1;
                    continue;
                }
                this.insertText(document, input.substring(start, end));
                start = end;
            }
            if (start < input.length()) {
                this.insertText(document, input.substring(start));
            }
        }
        catch (Exception e) {
            logger.warning(e.toString());
        }
    }

    private String[] findReplacementData(ModelMessage message, String variable) {
        String[] data = message.getData();
        if (data == null) {
            return null;
        }
        if (data.length % 2 == 0) {
            for (int index = 0; index < data.length; index += 2) {
                if (!variable.equals(data[index])) continue;
                return new String[]{variable, data[index + 1]};
            }
        } else {
            logger.warning("Data has a wrong format for message: " + message);
        }
        return null;
    }

    private void insertText(StyledDocument document, String text) throws Exception {
        document.insertString(document.getLength(), text, document.getStyle("regular"));
    }

    private void insertLinkButton(StyledDocument document, FreeColGameObject object, String name) throws Exception {
        JButton button = ReportTurnPanel.getLinkButton(name, null, object.getId());
        button.addActionListener(this);
        StyleConstants.setComponent(document.getStyle("button"), button);
        document.insertString(document.getLength(), " ", document.getStyle("button"));
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals(String.valueOf(-1))) {
            super.actionPerformed(event);
        } else {
            FreeColGameObject object = this.getCanvas().getClient().getGame().getFreeColGameObject(command);
            if (object instanceof Europe) {
                this.getCanvas().showEuropePanel();
            } else if (object instanceof Tile) {
                this.getCanvas().getGUI().setFocus(((Tile)object).getPosition());
            } else if (object instanceof Colony) {
                this.getCanvas().showColonyPanel((Colony)object);
            }
        }
    }
}

