/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.GoodsLabel;
import net.sf.freecol.client.gui.panel.ReportPanel;
import net.sf.freecol.client.gui.panel.UnitLabel;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReportUnitPanel
extends JPanel
implements ActionListener {
    private static final int labelColumn = 1;
    private static final int unitColumn = 3;
    private static final int extraRows = 2;
    private static final int separator = 12;
    private static final int militaryColumns = 9;
    private static final int carrierColumns = 7;
    private ReportType reportType;
    private boolean ignoreEmptyLocations;
    private int detailPanelRow;
    private HashMap<String, ArrayList<Unit>> locations;
    private static final HIGConstraints higConst = new HIGConstraints();
    private Canvas parent;
    private List<Colony> colonies;
    private ArrayList<String> colonyNames;
    private ArrayList<String> otherNames;
    private final ReportPanel reportPanel;
    private final JPanel detailPanel = new JPanel();
    private final Player player;
    private HashMap<UnitType, Integer> soldiers = new HashMap();
    private HashMap<UnitType, Integer> dragoons = new HashMap();
    private HashMap<UnitType, Integer> others = new HashMap();
    private static final UnitType defaultType = FreeCol.getSpecification().getUnitType("model.unit.freeColonist");
    int capacity = 0;
    private JButton detailButton;

    public ReportUnitPanel(ReportType type, boolean ignoreEmptyLocations, Canvas parent, ReportPanel reportPanel) {
        this.reportType = type;
        this.ignoreEmptyLocations = ignoreEmptyLocations;
        this.parent = parent;
        this.reportPanel = reportPanel;
        this.player = parent.getClient().getMyPlayer();
        this.setOpaque(false);
        this.detailPanel.setOpaque(false);
    }

    public void initialize() {
        this.gatherData();
        int rowsREF = this.reportType == ReportType.CARGO ? 0 : 1;
        int[] widths = new int[]{0};
        int[] heights = new int[3 + rowsREF];
        heights[1 + rowsREF] = 12;
        this.setLayout(new HIGLayout(widths, heights));
        int row = 1;
        if (this.reportType != ReportType.CARGO) {
            this.add((Component)this.createREFPanel(), higConst.rc(row, 1));
            ++row;
        }
        this.add((Component)this.createUnitPanel(), higConst.rc(row, 1));
        this.detailButton = new JButton(Messages.message("details", new String[0]));
        this.detailButton.setActionCommand("details");
        this.detailButton.addActionListener(this);
        this.detailPanelRow = row += 2;
        this.add((Component)this.detailButton, higConst.rc(row, 1, "tl"));
    }

    private void showDetails() {
        this.remove(this.detailButton);
        this.detailPanel.removeAll();
        int rows = 0;
        ArrayList<String> allNames = new ArrayList<String>();
        allNames.addAll(this.colonyNames);
        allNames.addAll(this.otherNames);
        for (String name : allNames) {
            ArrayList<Unit> units = this.locations.get(name);
            if (units == null || units.isEmpty()) {
                if (this.ignoreEmptyLocations) continue;
                ++rows;
                continue;
            }
            if (this.reportType == ReportType.MILITARY) {
                rows += units.size() / 9;
                if (units.size() % 9 == 0) continue;
                ++rows;
                continue;
            }
            int cargoColumns = 6;
            for (Unit unit : units) {
                int cargo = unit.getGoodsCount() + unit.getUnitCount();
                if (cargo == 0) {
                    ++rows;
                    continue;
                }
                rows += cargo / cargoColumns;
                if (cargo % cargoColumns == 0) continue;
                ++rows;
            }
        }
        int[] widths = new int[2 + (this.reportType == ReportType.MILITARY ? 9 : 7)];
        int[] heights = new int[rows];
        widths[1] = 12;
        this.detailPanel.setLayout(new HIGLayout(widths, heights));
        int row = 1;
        for (String locationName : this.colonyNames) {
            row = this.handleLocation(locationName, true, row);
        }
        if (this.player.getEurope() != null) {
            String europeName = this.player.getEurope().getLocationName();
            row = this.handleLocation(europeName, true, row);
            this.otherNames.remove(europeName);
        }
        Collections.sort(this.otherNames);
        for (String locationName : this.otherNames) {
            row = this.handleLocation(locationName, false, row);
        }
        this.add((Component)this.detailPanel, higConst.rc(this.detailPanelRow, 1));
        this.revalidate();
    }

    private int getCount(HashMap<UnitType, Integer> hash, UnitType unitType) {
        Integer count = hash.get(unitType);
        if (count != null) {
            return count;
        }
        return 0;
    }

    private void incrementCount(HashMap<UnitType, Integer> hash, UnitType unitType) {
        Integer count = hash.get(unitType);
        if (count == null) {
            hash.put(unitType, new Integer(1));
        } else {
            hash.put(unitType, new Integer(count + 1));
        }
    }

    private void gatherData() {
        this.locations = new HashMap();
        this.colonies = this.player.getColonies();
        Collections.sort(this.colonies, this.parent.getClient().getClientOptions().getColonyComparator());
        this.colonyNames = new ArrayList();
        for (Colony colony : this.colonies) {
            this.colonyNames.add(colony.getName());
        }
        this.otherNames = new ArrayList();
        if (this.player.getEurope() != null) {
            this.otherNames.add(this.player.getEurope().getLocationName());
        }
        block10: for (Unit unit : this.player.getUnits()) {
            block0 : switch (this.reportType) {
                case CARGO: {
                    if (!unit.isCarrier()) continue block10;
                    this.incrementCount(this.others, unit.getType());
                    this.capacity += unit.getType().getSpace();
                    break;
                }
                case NAVAL: {
                    if (!unit.isNaval()) continue block10;
                    this.incrementCount(this.others, unit.getType());
                    break;
                }
                case MILITARY: {
                    if (!unit.isOffensiveUnit() || unit.isNaval()) continue block10;
                    UnitType unitType = defaultType;
                    if (unit.getType().getOffence() > 0 || unit.hasAbility("model.ability.expertSoldier")) {
                        unitType = unit.getType();
                    }
                    switch (unit.getRole()) {
                        case DRAGOON: {
                            this.incrementCount(this.dragoons, unitType);
                            break block0;
                        }
                        case SOLDIER: {
                            this.incrementCount(this.soldiers, unitType);
                            break block0;
                        }
                    }
                    this.incrementCount(this.others, unitType);
                }
            }
            String locationName = unit.getLocation().getLocationName();
            if (unit.getState() == Unit.UnitState.TO_AMERICA) {
                locationName = Messages.message("goingToAmerica", new String[0]);
            } else if (unit.getState() == Unit.UnitState.TO_EUROPE) {
                locationName = Messages.message("goingToEurope", new String[0]);
            }
            ArrayList<Unit> unitList = this.locations.get(locationName);
            if (unitList == null) {
                unitList = new ArrayList();
                this.locations.put(locationName, unitList);
            }
            unitList.add(unit);
            if (this.colonyNames.contains(locationName) || this.otherNames.contains(locationName)) continue;
            this.otherNames.add(locationName);
        }
    }

    private JPanel createREFPanel() {
        Element refUnits = this.parent.getClient().getInGameController().getREFUnits();
        ArrayList<AbstractUnit> navalUnits = new ArrayList<AbstractUnit>();
        ArrayList<AbstractUnit> landUnits = new ArrayList<AbstractUnit>();
        if (refUnits != null) {
            NodeList childElements = refUnits.getChildNodes();
            for (int index = 0; index < childElements.getLength(); ++index) {
                AbstractUnit unit = new AbstractUnit();
                unit.readFromXMLElement((Element)childElements.item(index));
                if (unit.getUnitType().hasAbility("model.ability.navalUnit")) {
                    navalUnits.add(unit);
                    continue;
                }
                landUnits.add(unit);
            }
        }
        JComponent refPanel = null;
        if (this.reportType == ReportType.NAVAL) {
            refPanel = new JPanel(new GridLayout(1, navalUnits.size()));
            for (AbstractUnit unit : navalUnits) {
                refPanel.add(this.createUnitTypeLabel(unit.getUnitType(), Unit.Role.DEFAULT, unit.getNumber()));
            }
        } else if (this.reportType == ReportType.MILITARY) {
            refPanel = new JPanel(new GridLayout(1, landUnits.size()));
            for (AbstractUnit unit : landUnits) {
                refPanel.add(this.createUnitTypeLabel(unit.getUnitType(), unit.getRole(), unit.getNumber()));
            }
        }
        if (refPanel != null) {
            refPanel.setOpaque(false);
            String refName = Messages.message(this.player.getNation().getRefId() + ".name", new String[0]);
            refPanel.setBorder(BorderFactory.createTitledBorder(refName));
        }
        return refPanel;
    }

    private JPanel createUnitPanel() {
        JPanel unitPanel = new JPanel();
        ArrayList<AbstractUnit> units = new ArrayList<AbstractUnit>();
        switch (this.reportType) {
            case CARGO: {
                for (UnitType unitType : FreeCol.getSpecification().getUnitTypeList()) {
                    if (!unitType.isAvailableTo(this.player) || !unitType.canCarryUnits() && !unitType.canCarryGoods()) continue;
                    units.add(new AbstractUnit(unitType, Unit.Role.DEFAULT, this.getCount(this.others, unitType)));
                }
                break;
            }
            case NAVAL: {
                for (UnitType unitType : FreeCol.getSpecification().getUnitTypeList()) {
                    if (!unitType.isAvailableTo(this.player) || !unitType.hasAbility("model.ability.navalUnit")) continue;
                    units.add(new AbstractUnit(unitType, Unit.Role.DEFAULT, this.getCount(this.others, unitType)));
                }
                break;
            }
            case MILITARY: {
                ArrayList<AbstractUnit> dragoonUnits = new ArrayList<AbstractUnit>();
                ArrayList<AbstractUnit> soldierUnits = new ArrayList<AbstractUnit>();
                for (UnitType unitType : FreeCol.getSpecification().getUnitTypeList()) {
                    if (!unitType.isAvailableTo(this.player) || unitType.hasAbility("model.ability.navalUnit") || !unitType.hasAbility("model.ability.expertSoldier") && unitType.getOffence() <= 0) continue;
                    if (unitType.hasAbility("model.ability.canBeEquipped")) {
                        dragoonUnits.add(new AbstractUnit(unitType, Unit.Role.DRAGOON, this.getCount(this.dragoons, unitType)));
                        soldierUnits.add(new AbstractUnit(unitType, Unit.Role.SOLDIER, this.getCount(this.soldiers, unitType)));
                        continue;
                    }
                    units.add(new AbstractUnit(unitType, Unit.Role.DEFAULT, this.getCount(this.others, unitType)));
                }
                dragoonUnits.add(new AbstractUnit(defaultType, Unit.Role.DRAGOON, this.getCount(this.dragoons, defaultType)));
                soldierUnits.add(new AbstractUnit(defaultType, Unit.Role.SOLDIER, this.getCount(this.soldiers, defaultType)));
                units.addAll(dragoonUnits);
                units.addAll(soldierUnits);
            }
        }
        unitPanel.setOpaque(false);
        unitPanel.setBorder(BorderFactory.createTitledBorder(this.player.getNationAsString()));
        unitPanel.setLayout(new GridLayout(1, units.size()));
        for (AbstractUnit unit : units) {
            unitPanel.add(this.createUnitTypeLabel(unit));
        }
        return unitPanel;
    }

    private int handleLocation(String location, boolean makeButton, int row) {
        block17: {
            List unitList = this.locations.get(location);
            if ((unitList == null || unitList.isEmpty()) && this.ignoreEmptyLocations) {
                return row;
            }
            if (makeButton) {
                JButton locationButton = FreeColPanel.getLinkButton(location, null, location);
                locationButton.addActionListener(this);
                this.detailPanel.add((Component)locationButton, higConst.rc(row, 1, "lt"));
            } else {
                JLabel locationLabel = new JLabel(location);
                this.detailPanel.add((Component)locationLabel, higConst.rc(row, 1));
            }
            if (unitList == null) break block17;
            Collections.sort(unitList, this.reportPanel.getUnitTypeComparator());
            if (this.reportType == ReportType.MILITARY) {
                int column = 2;
                for (Unit unit : unitList) {
                    UnitLabel unitLabel = new UnitLabel(unit, this.parent, true);
                    if (unit.getDestination() != null) {
                        String destination = unit.getDestination().getLocationName();
                        unitLabel.setToolTipText("<html>" + unitLabel.getToolTipText() + "<br>" + Messages.message("goingTo", "%location%", destination) + "</html>");
                    }
                    if (column == 11) {
                        column = 3;
                        ++row;
                    } else {
                        ++column;
                    }
                    this.detailPanel.add((Component)unitLabel, higConst.rc(row, column));
                }
            } else {
                int column = 3;
                for (Unit unit : unitList) {
                    UnitLabel unitLabel = new UnitLabel(unit, this.parent, true);
                    if (unit.getDestination() != null) {
                        String messageID = unit.isNaval() ? "sailingTo" : "goingTo";
                        String destination = unit.getDestination().getLocationName();
                        unitLabel.setToolTipText("<html>" + unitLabel.getToolTipText() + "<br>" + Messages.message(messageID, "%location%", destination) + "</html>");
                    }
                    unitLabel.setSelected(true);
                    this.detailPanel.add((Component)unitLabel, higConst.rc(row, 3));
                    for (Goods goods : unit.getGoodsList()) {
                        GoodsLabel goodsLabel = new GoodsLabel(goods, this.reportPanel.getCanvas());
                        if (column == 9) {
                            column = 4;
                            ++row;
                        } else {
                            ++column;
                        }
                        this.detailPanel.add((Component)goodsLabel, higConst.rc(row, column));
                    }
                    for (Unit unitLoaded : unit.getUnitList()) {
                        UnitLabel unitLoadedLabel = new UnitLabel(unitLoaded, this.reportPanel.getCanvas(), true);
                        if (column == 9) {
                            column = 4;
                            ++row;
                        } else {
                            ++column;
                        }
                        this.detailPanel.add((Component)unitLoadedLabel, higConst.rc(row, column));
                    }
                }
            }
        }
        return row + 1;
    }

    private JLabel createUnitTypeLabel(AbstractUnit unit) {
        return this.createUnitTypeLabel(unit.getUnitType(), unit.getRole(), unit.getNumber());
    }

    private JLabel createUnitTypeLabel(UnitType unitType, Unit.Role role, int count) {
        ImageIcon unitIcon = this.reportPanel.getLibrary().getUnitImageIcon(unitType, role, count == 0);
        JLabel unitLabel = new JLabel(this.reportPanel.getLibrary().getScaledImageIcon(unitIcon, 0.66f));
        unitLabel.setText(String.valueOf(count));
        if (count == 0) {
            unitLabel.setForeground(Color.GRAY);
        }
        unitLabel.setToolTipText(Unit.getName(unitType, role));
        return unitLabel;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals("-1")) {
            this.reportPanel.actionPerformed(event);
        } else if (command.equals("details")) {
            this.showDetails();
        } else if (command.equals(this.player.getEurope().getName())) {
            this.parent.showEuropePanel();
        } else if (this.player.getColony(command) != null) {
            this.parent.showColonyPanel(this.player.getColony(command));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ReportType {
        MILITARY,
        NAVAL,
        CARGO;

    }
}

