/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JPanel;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColDialog;

public final class RiverStylePanel
extends FreeColDialog
implements ActionListener {
    private static final Logger logger = Logger.getLogger(RiverStylePanel.class.getName());
    private static final int CANCEL = -1;
    private static final int DELETE = 0;

    public RiverStylePanel(Canvas parent) {
        super(parent);
        this.setLayout(new BorderLayout());
        ImageLibrary library = parent.getGUI().getImageLibrary();
        JPanel stylesPanel = new JPanel(new GridLayout(9, 9));
        JButton deleteButton = new JButton(library.getScaledImageIcon(library.getMiscImageIcon("delete.image"), 0.5f));
        deleteButton.setActionCommand(String.valueOf(0));
        deleteButton.addActionListener(this);
        stylesPanel.add(deleteButton);
        for (int index = 1; index < 81; ++index) {
            JButton riverButton = new JButton(library.getScaledImageIcon(library.getRiverImage(index), 0.5f));
            riverButton.setActionCommand(String.valueOf(index));
            riverButton.addActionListener(this);
            stylesPanel.add(riverButton);
        }
        this.add((Component)stylesPanel, "Center");
        JButton cancelButton = new JButton(Messages.message("cancel", new String[0]));
        cancelButton.setActionCommand(String.valueOf(-1));
        cancelButton.addActionListener(this);
        cancelButton.setMnemonic('C');
        this.add((Component)cancelButton, "South");
        this.setSize(this.getPreferredSize());
    }

    public void actionPerformed(ActionEvent event) {
        int style = Integer.parseInt(event.getActionCommand());
        this.setResponse(new Integer(style));
    }
}

