/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import cz.autel.dmi.HIGLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.InGameController;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.common.model.GoodsType;

public final class SelectAmountDialog
extends FreeColDialog
implements ActionListener {
    private static Logger logger = Logger.getLogger(SelectAmountDialog.class.getName());
    private static final int SELECT_CANCEL = -1;
    private final JButton cancel;
    private final JButton ok;
    private final JPanel buttonPanel;
    private final JTextArea question;
    private final JComboBox comboBox;
    private final FreeColClient freeColClient;
    private final InGameController inGameController;

    public SelectAmountDialog(Canvas parent, GoodsType goodsType, int available, boolean needToPay) {
        super(parent);
        this.freeColClient = parent.getClient();
        this.inGameController = this.freeColClient.getInGameController();
        this.setFocusCycleRoot(true);
        this.question = SelectAmountDialog.getDefaultTextArea(Messages.message("goodsTransfer.text", new String[0]));
        if (needToPay) {
            int gold = parent.getClient().getMyPlayer().getGold();
            int price = parent.getClient().getMyPlayer().getMarket().costToBuy(goodsType);
            available = Math.min(available, gold / price);
        }
        int[] amounts = new int[]{20, 40, 50, 60, 80, 100};
        Vector<Integer> values = new Vector<Integer>();
        for (int index = 0; index < amounts.length; ++index) {
            if (amounts[index] >= available) {
                values.add(available);
                break;
            }
            values.add(amounts[index]);
        }
        this.comboBox = new JComboBox(values);
        this.comboBox.setEditable(true);
        this.comboBox.addActionListener(this);
        this.ok = new JButton(Messages.message("ok", new String[0]));
        SelectAmountDialog.enterPressesWhenFocused(this.ok);
        this.ok.addActionListener(this);
        this.cancel = new JButton(Messages.message("cancel", new String[0]));
        SelectAmountDialog.enterPressesWhenFocused(this.cancel);
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                SelectAmountDialog.this.setResponse(new Integer(-1));
            }
        });
        this.setCancelComponent(this.cancel);
        this.buttonPanel = new JPanel();
        this.buttonPanel.add(this.ok);
        this.buttonPanel.add(this.cancel);
        this.initialize();
    }

    public void requestFocus() {
        this.cancel.requestFocus();
    }

    public void initialize() {
        int[] widths = new int[]{0};
        int[] heights = new int[5];
        for (int index = 1; index < heights.length; index += 2) {
            heights[index] = 3;
        }
        this.setLayout(new HIGLayout(widths, heights));
        int row = 1;
        int column = 1;
        this.add((Component)this.question, higConst.rc(row, column));
        this.add((Component)this.comboBox, higConst.rc(row += 2, column));
        this.add((Component)this.buttonPanel, higConst.rc(row += 2, column));
        this.setSize(this.getPreferredSize());
    }

    public void actionPerformed(ActionEvent event) {
        Object item = this.comboBox.getSelectedItem();
        if (item instanceof Integer) {
            this.setResponse(item);
        } else if (item instanceof String) {
            try {
                this.setResponse(Integer.valueOf((String)item));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

