/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import cz.autel.dmi.HIGLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.ConnectController;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.NewPanel;
import net.sf.freecol.client.gui.panel.ServerListTableModel;
import net.sf.freecol.common.ServerInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServerListPanel
extends FreeColPanel
implements ActionListener {
    private static final Logger logger = Logger.getLogger(ServerListPanel.class.getName());
    private static final int CONNECT = 0;
    private static final int CANCEL = 1;
    private final Canvas parent;
    private final FreeColClient freeColClient;
    private final ConnectController connectController;
    private final JTable table;
    private final ServerListTableModel tableModel;
    private String username;
    private JButton connect;

    public ServerListPanel(Canvas parent, FreeColClient freeColClient, ConnectController connectController) {
        this.parent = parent;
        this.freeColClient = freeColClient;
        this.connectController = connectController;
        JButton cancel = new JButton("Cancel");
        this.setCancelComponent(cancel);
        this.connect = new JButton(Messages.message("connect", new String[0]));
        this.tableModel = new ServerListTableModel(new ArrayList<ServerInfo>());
        this.table = new JTable(this.tableModel);
        DefaultTableCellRenderer dtcr = new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable t, Object o, boolean isSelected, boolean hasFocus, int row, int column) {
                this.setOpaque(isSelected);
                return super.getTableCellRendererComponent(t, o, isSelected, hasFocus, row, column);
            }
        };
        for (int i = 0; i < this.table.getColumnModel().getColumnCount(); ++i) {
            this.table.getColumnModel().getColumn(i).setCellRenderer(dtcr);
        }
        this.table.setRowHeight(22);
        this.table.setCellSelectionEnabled(false);
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSelectionAllowed(false);
        this.table.setSelectionMode(0);
        JScrollPane tableScroll = new JScrollPane(this.table);
        this.table.addNotify();
        tableScroll.getViewport().setOpaque(false);
        tableScroll.getColumnHeader().setOpaque(false);
        HIGLayout layout = new HIGLayout(new int[]{200, 200}, new int[]{350, 12, 0});
        layout.setRowWeight(1, 1);
        layout.setColumnWeight(1, 1);
        layout.setColumnWeight(2, 1);
        this.setLayout(layout);
        this.add((Component)tableScroll, higConst.rcwh(1, 1, 2, 1));
        this.add((Component)this.connect, higConst.rc(3, 1, "l"));
        this.add((Component)cancel, higConst.rc(3, 2, "r"));
        this.connect.setActionCommand(String.valueOf(0));
        cancel.setActionCommand(String.valueOf(1));
        this.connect.addActionListener(this);
        cancel.addActionListener(this);
        this.setSize(this.getPreferredSize());
    }

    @Override
    public void requestFocus() {
        this.connect.requestFocus();
    }

    public void initialize(String username, ArrayList<ServerInfo> arrayList) {
        this.username = username;
        Iterator<ServerInfo> it = arrayList.iterator();
        while (it.hasNext()) {
            ServerInfo si = it.next();
            if (si.getVersion().equals(FreeCol.getVersion())) continue;
            it.remove();
        }
        this.tableModel.setItems(arrayList);
        this.setEnabled(true);
        if (arrayList.size() == 0) {
            this.connect.setEnabled(false);
        } else {
            this.table.setRowSelectionInterval(0, 0);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        Component[] components = this.getComponents();
        for (int i = 0; i < components.length; ++i) {
            components[i].setEnabled(enabled);
        }
        this.table.setEnabled(enabled);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        try {
            switch (Integer.valueOf(command)) {
                case 0: {
                    ServerInfo si = this.tableModel.getItem(this.table.getSelectedRow());
                    this.connectController.joinMultiplayerGame(this.username, si.getAddress(), si.getPort());
                    break;
                }
                case 1: {
                    this.parent.remove(this);
                    this.parent.showPanel(new NewPanel(this.parent));
                    break;
                }
                default: {
                    logger.warning("Invalid Actioncommand: invalid number.");
                    break;
                }
            }
        }
        catch (NumberFormatException e) {
            logger.warning("Invalid Actioncommand: not a number.");
        }
    }

    public void refreshTable() {
        this.tableModel.fireTableDataChanged();
    }
}

