/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.util.List;
import javax.swing.table.AbstractTableModel;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.common.ServerInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ServerListTableModel
extends AbstractTableModel {
    private static final String[] columnNames = new String[]{Messages.message("name", new String[0]), Messages.message("host", new String[0]), Messages.message("port", new String[0]), Messages.message("players", new String[0]), Messages.message("gameState", new String[0])};
    private List<ServerInfo> items;

    public ServerListTableModel(List<ServerInfo> items) {
        this.items = items;
    }

    public void setItems(List<ServerInfo> items) {
        this.items = items;
    }

    public ServerInfo getItem(int row) {
        return this.items.get(row);
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public String getColumnName(int column) {
        return columnNames[column];
    }

    @Override
    public int getRowCount() {
        return this.items.size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (row < this.getRowCount() && column < this.getColumnCount() && row >= 0 && column >= 0) {
            ServerInfo si = this.items.get(row);
            switch (column) {
                case 0: {
                    return si.getName();
                }
                case 1: {
                    return si.getAddress();
                }
                case 2: {
                    return Integer.toString(si.getPort());
                }
                case 3: {
                    return Integer.toString(si.getCurrentlyPlaying()) + "/" + Integer.toString(si.getCurrentlyPlaying() + si.getSlotsAvailable());
                }
                case 4: {
                    return Messages.message("gameState." + Integer.toString(si.getGameState()), new String[0]);
                }
            }
            return null;
        }
        return null;
    }
}

