/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import cz.autel.dmi.HIGLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.logging.Logger;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.AdvantageCellEditor;
import net.sf.freecol.client.gui.panel.AdvantageCellRenderer;
import net.sf.freecol.client.gui.panel.ColopediaPanel;
import net.sf.freecol.client.gui.panel.ColorCellEditor;
import net.sf.freecol.client.gui.panel.ColorCellRenderer;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.NationCellRenderer;
import net.sf.freecol.client.gui.panel.NewPanel;
import net.sf.freecol.client.gui.panel.PlayersTableModel;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.Player;

public final class StartGamePanel
extends FreeColPanel
implements ActionListener {
    private static final Logger logger = Logger.getLogger(StartGamePanel.class.getName());
    private static final int START = 0;
    private static final int CANCEL = 1;
    private static final int READY = 3;
    private static final int CHAT = 4;
    private static final int GAME_OPTIONS = 5;
    private static final int MAP_GENERATOR_OPTIONS = 6;
    public static final int NAME_COLUMN = 0;
    public static final int NATION_COLUMN = 1;
    public static final int ADVANTAGE_COLUMN = 2;
    public static final int COLOR_COLUMN = 3;
    private final Canvas parent;
    private final FreeColClient freeColClient;
    private Game game;
    private Player thisPlayer;
    private boolean singlePlayerGame;
    private final JCheckBox readyBox;
    private final JTextField chat;
    private final JTextArea chatArea;
    private final JTable table;
    private final PlayersTableModel tableModel;
    private JButton start;
    private JButton gameOptions;
    private JButton mapGeneratorOptions;
    private int advantages;

    public StartGamePanel(Canvas parent, FreeColClient freeColClient) {
        this.parent = parent;
        this.freeColClient = freeColClient;
        JButton cancel = new JButton(Messages.message("cancel", new String[0]));
        this.setCancelComponent(cancel);
        this.start = new JButton(Messages.message("startGame", new String[0]));
        this.gameOptions = new JButton(Messages.message("gameOptions", new String[0]));
        this.mapGeneratorOptions = new JButton(Messages.message("mapGeneratorOptions", new String[0]));
        this.readyBox = new JCheckBox(Messages.message("iAmReady", new String[0]));
        this.chat = new JTextField();
        this.chatArea = new JTextArea();
        JScrollPane chatScroll = new JScrollPane(this.chatArea, 22, 31);
        this.tableModel = new PlayersTableModel(freeColClient, freeColClient.getPreGameController());
        this.table = new JTable(this.tableModel);
        TableColumn nameColumn = this.table.getColumnModel().getColumn(0);
        TableColumn advantageColumn = this.table.getColumnModel().getColumn(2);
        TableColumn colorsColumn = this.table.getColumnModel().getColumn(3);
        DefaultTableCellRenderer dtcr = new DefaultTableCellRenderer();
        dtcr.setOpaque(false);
        nameColumn.setCellRenderer(dtcr);
        colorsColumn.setCellEditor(new ColorCellEditor(parent, this));
        colorsColumn.setCellRenderer(new ColorCellRenderer(true));
        this.table.setRowHeight(22);
        this.table.setCellSelectionEnabled(false);
        JScrollPane tableScroll = new JScrollPane(this.table);
        this.table.addNotify();
        tableScroll.getViewport().setOpaque(false);
        tableScroll.getColumnHeader().setOpaque(false);
        int[] widths = new int[]{400, 3, 300};
        int[] heights = new int[]{200, 3, 0, 3, 0, 3, 0, 3, 0};
        this.setLayout(new HIGLayout(widths, heights));
        int row = 1;
        int leftColumn = 1;
        int rightColumn = 3;
        this.add((Component)tableScroll, higConst.rc(row, leftColumn));
        this.add((Component)chatScroll, higConst.rcwh(row, rightColumn, 1, 3));
        this.add((Component)this.mapGeneratorOptions, higConst.rc(row += 2, leftColumn));
        this.add((Component)this.gameOptions, higConst.rc(row += 2, leftColumn));
        this.add((Component)this.chat, higConst.rc(row, rightColumn));
        this.add((Component)this.readyBox, higConst.rc(row += 2, leftColumn));
        this.add((Component)this.start, higConst.rc(row += 2, leftColumn, "r"));
        this.add((Component)cancel, higConst.rc(row, rightColumn, "l"));
        this.start.setActionCommand(String.valueOf(0));
        cancel.setActionCommand(String.valueOf(1));
        this.readyBox.setActionCommand(String.valueOf(3));
        this.gameOptions.setActionCommand(String.valueOf(5));
        this.mapGeneratorOptions.setActionCommand(String.valueOf(6));
        this.chat.setActionCommand(String.valueOf(4));
        StartGamePanel.enterPressesWhenFocused(this.start);
        StartGamePanel.enterPressesWhenFocused(cancel);
        this.start.addActionListener(this);
        cancel.addActionListener(this);
        this.readyBox.addActionListener(this);
        this.chat.addActionListener(this);
        this.gameOptions.addActionListener(this);
        this.mapGeneratorOptions.addActionListener(this);
        this.chatArea.setEditable(false);
        this.chatArea.setLineWrap(true);
        this.chatArea.setWrapStyleWord(true);
        this.setSize(this.getPreferredSize());
    }

    public void requestFocus() {
        this.start.requestFocus();
    }

    public void initialize(boolean singlePlayerGame, boolean additionalNations, int advantages) {
        this.singlePlayerGame = singlePlayerGame;
        this.game = this.freeColClient.getGame();
        this.thisPlayer = this.freeColClient.getMyPlayer();
        this.advantages = advantages;
        Nation[] nations = additionalNations ? FreeCol.getSpecification().getEuropeanNations().toArray(new Nation[0]) : FreeCol.getSpecification().getClassicNations().toArray(new Nation[0]);
        this.tableModel.setData(this.game.getPlayers(), this.thisPlayer, advantages);
        JLabel playerLabel = new JLabel(Messages.message("player", new String[0]));
        JButton nationButton = new JButton(Messages.message("nation", new String[0]));
        JButton advantageButton = new JButton(Messages.message("advantage", new String[0]));
        JLabel colorLabel = new JLabel(Messages.message("color", new String[0]));
        nationButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                StartGamePanel.this.parent.showColopediaPanel(ColopediaPanel.PanelType.NATIONS);
            }
        });
        advantageButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                StartGamePanel.this.parent.showColopediaPanel(ColopediaPanel.PanelType.NATION_TYPES);
            }
        });
        HeaderRenderer renderer = new HeaderRenderer(playerLabel, nationButton, advantageButton, colorLabel);
        JTableHeader header = this.table.getTableHeader();
        header.addMouseListener(new HeaderListener(header, renderer));
        TableColumn nationsColumn = this.table.getColumnModel().getColumn(1);
        nationsColumn.setCellEditor(new DefaultCellEditor(new JComboBox<Nation>(nations)));
        nationsColumn.setCellRenderer(new NationCellRenderer(nations));
        ((NationCellRenderer)this.table.getColumnModel().getColumn(1).getCellRenderer()).setData(this.game.getPlayers(), this.thisPlayer);
        nationsColumn.setHeaderRenderer(renderer);
        TableColumn advantagesColumn = this.table.getColumnModel().getColumn(2);
        if (advantages == 2) {
            advantagesColumn.setCellEditor(new AdvantageCellEditor());
        }
        advantagesColumn.setCellRenderer(new AdvantageCellRenderer());
        ((AdvantageCellRenderer)this.table.getColumnModel().getColumn(2).getCellRenderer()).setData(this.game.getPlayers(), this.thisPlayer, advantages);
        advantagesColumn.setHeaderRenderer(renderer);
        ((ColorCellEditor)this.table.getColumnModel().getColumn(3).getCellEditor()).setData(this.game.getPlayers(), this.thisPlayer);
        if (singlePlayerGame) {
            this.thisPlayer.setReady(false);
            this.readyBox.setSelected(true);
        } else {
            this.readyBox.setSelected(this.thisPlayer.isReady());
        }
        this.chatArea.setText("");
        this.setEnabled(true);
    }

    public void updateMapGeneratorOptions() {
        this.freeColClient.getPreGameController().getMapGeneratorOptions().getObject("model.option.mapSize");
    }

    public void updateGameOptions() {
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        Component[] components = this.getComponents();
        for (int i = 0; i < components.length; ++i) {
            components[i].setEnabled(enabled);
        }
        if (this.singlePlayerGame && enabled) {
            this.readyBox.setEnabled(false);
        }
        this.table.setEnabled(enabled);
        if (enabled) {
            this.start.setEnabled(this.freeColClient.isAdmin());
        }
        this.gameOptions.setEnabled(enabled);
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        try {
            switch (Integer.valueOf(command)) {
                case 0: {
                    if (this.singlePlayerGame) {
                        this.thisPlayer.setReady(true);
                    }
                    this.freeColClient.getPreGameController().requestLaunch();
                    break;
                }
                case 1: {
                    this.freeColClient.getConnectController().quitGame(true);
                    this.parent.remove(this);
                    this.parent.showPanel(new NewPanel(this.parent));
                    break;
                }
                case 3: {
                    this.freeColClient.getPreGameController().setReady(this.readyBox.isSelected());
                    this.refreshPlayersTable();
                    break;
                }
                case 4: {
                    if (this.chat.getText().trim().length() > 0) {
                        this.freeColClient.getPreGameController().chat(this.chat.getText());
                        this.displayChat(this.freeColClient.getMyPlayer().getName(), this.chat.getText(), false);
                        this.chat.setText("");
                    }
                    break;
                }
                case 5: {
                    this.parent.showGameOptionsDialog(this.freeColClient.isAdmin());
                    break;
                }
                case 6: {
                    this.parent.showMapGeneratorOptionsDialog(this.freeColClient.isAdmin());
                    break;
                }
                default: {
                    logger.warning("Invalid Actioncommand: invalid number.");
                    break;
                }
            }
        }
        catch (NumberFormatException e) {
            logger.warning("Invalid Actioncommand: not a number.");
        }
    }

    public void displayChat(String senderName, String message, boolean privateChat) {
        if (privateChat) {
            this.chatArea.append(senderName + " (private): " + message + '\n');
        } else {
            this.chatArea.append(senderName + ": " + message + '\n');
        }
    }

    public void refreshPlayersTable() {
        this.tableModel.fireTableDataChanged();
    }

    private class HeaderListener
    extends MouseAdapter {
        JTableHeader header;
        HeaderRenderer renderer;

        HeaderListener(JTableHeader header, HeaderRenderer renderer) {
            this.header = header;
            this.renderer = renderer;
        }

        public void mousePressed(MouseEvent e) {
            int col = this.header.columnAtPoint(e.getPoint());
            this.renderer.setPressedColumn(col);
            this.header.repaint();
        }

        public void mouseReleased(MouseEvent e) {
            this.renderer.setPressedColumn(-1);
            this.header.repaint();
        }
    }

    private class HeaderRenderer
    implements TableCellRenderer {
        private static final int NO_COLUMN = -1;
        private int pressedColumn = -1;
        private Component[] components;

        public HeaderRenderer(Component ... components) {
            this.components = components;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (this.components[column] instanceof JButton) {
                boolean isPressed = column == this.pressedColumn;
                ((JButton)this.components[column]).getModel().setPressed(isPressed);
                ((JButton)this.components[column]).getModel().setArmed(isPressed);
            }
            return this.components[column];
        }

        public void setPressedColumn(int column) {
            this.pressedColumn = column;
        }
    }
}

