/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.common.networking.StatisticsMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StatisticsPanel
extends FreeColPanel
implements ActionListener {
    private static final Logger logger = Logger.getLogger(StatisticsPanel.class.getName());
    private static final int CLOSE = 0;
    private final Canvas parent;
    private JButton exitButton;

    public StatisticsPanel(Canvas parent, FreeColClient freeColClient) {
        this.parent = parent;
        this.setLayout(new BorderLayout());
        StatisticsMessage serverStatistics = freeColClient.getInGameController().getServerStatistics();
        StatisticsMessage clientStatistics = new StatisticsMessage(freeColClient.getGame(), null);
        JPanel header = new JPanel();
        this.add((Component)header, "North");
        header.add((Component)new JLabel("Statistics"), Float.valueOf(0.5f));
        JPanel statsPanel = new JPanel(new GridLayout(1, 2));
        this.add((Component)statsPanel, "Center");
        statsPanel.add(this.displayStatsMessage("Client", clientStatistics));
        statsPanel.add(this.displayStatsMessage("Server", serverStatistics));
        this.exitButton = new JButton(Messages.message("close", new String[0]));
        this.exitButton.addActionListener(this);
        StatisticsPanel.enterPressesWhenFocused(this.exitButton);
        this.setCancelComponent(this.exitButton);
        this.exitButton.setActionCommand(String.valueOf(0));
        this.add((Component)this.exitButton, "South");
        this.exitButton.setFocusable(true);
        this.setSize(this.getPreferredSize());
    }

    private JPanel displayStatsMessage(String title, StatisticsMessage statistics) {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder(title));
        Box b = new Box(1);
        panel.add(b);
        b.add(this.createStatsTable("Memory", statistics.getMemoryStatistics()));
        b.add(this.createStatsTable("Game", statistics.getGameStatistics()));
        if (statistics.getAIStatistics() != null) {
            b.add(this.createStatsTable("AI", statistics.getAIStatistics()));
        } else {
            b.add(new JLabel());
        }
        return panel;
    }

    private JPanel createStatsTable(String title, HashMap<String, Long> data) {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)new JLabel(title), "North");
        StatisticsModel model = new StatisticsModel();
        model.setData(data);
        JTable table = new JTable(model);
        table.setAutoCreateColumnsFromModel(true);
        table.setAutoResizeMode(4);
        JScrollPane scrollPane = new JScrollPane(table);
        table.addNotify();
        scrollPane.getViewport().setOpaque(false);
        scrollPane.getColumnHeader().setOpaque(false);
        panel.add((Component)scrollPane, "Center");
        panel.setPreferredSize(new Dimension(300, (data.size() + 2) * 17));
        return panel;
    }

    private String serializeStats(String title, HashMap<String, Long> stats) {
        String message = title + "\n";
        long total = 0L;
        for (String s : stats.keySet()) {
            Long value = stats.get(s);
            message = message + s + ": " + value.toString() + "\n";
            total += value.longValue();
        }
        message = message + "Total: " + total + "\n";
        return message;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        try {
            switch (Integer.valueOf(command)) {
                case 0: {
                    this.parent.remove(this);
                    break;
                }
                default: {
                    logger.warning("Invalid Actioncommand: invalid number.");
                    break;
                }
            }
        }
        catch (NumberFormatException e) {
            logger.warning("Invalid Actioncommand: not a number.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class StatisticsModel
    extends AbstractTableModel {
        private static final int NAME_COLUMN = 0;
        private static final int VALUE_COLUMN = 1;
        private final String[] columnNames = new String[]{"Name", "Value"};
        private Object[][] data = null;

        public void setData(HashMap<String, Long> statsData) {
            this.data = new Object[2][statsData.size()];
            int i = 0;
            for (String s : statsData.keySet()) {
                this.data[0][i] = s;
                this.data[1][i] = statsData.get(s);
                ++i;
            }
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        @Override
        public int getRowCount() {
            return this.data[0].length;
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (row < this.getRowCount() && column < this.getColumnCount() && row >= 0 && column >= 0) {
                switch (column) {
                    case 0: {
                        return this.data[0][row];
                    }
                    case 1: {
                        return this.data[1][row];
                    }
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public Class<?> getColumnClass(int column) {
            return this.getValueAt(0, column).getClass();
        }
    }
}

