/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.ComponentInputMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.ColopediaPanel;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileType;

public final class TilePanel
extends FreeColDialog
implements ActionListener {
    private static final Logger logger = Logger.getLogger(TilePanel.class.getName());
    private static final int OK = 0;
    private static final int COLOPEDIA = 1;
    private final Canvas canvas;
    private final GoodsType[] goodsTypes;
    private final int number;
    private final JPanel goodsPanel;
    private final JLabel tileNameLabel;
    private final JLabel ownerLabel;
    private final JLabel regionLabel;
    private final JButton okButton;
    private final JButton colopediaButton;
    private TileType tileType;

    public TilePanel(Canvas parent) {
        this.canvas = parent;
        this.setLayout(new BoxLayout(this, 3));
        this.tileNameLabel = new JLabel("", 0);
        this.tileNameLabel.setAlignmentX(0.5f);
        this.add(this.tileNameLabel);
        this.regionLabel = new JLabel("", 0);
        this.regionLabel.setAlignmentX(0.5f);
        this.add(this.regionLabel);
        this.ownerLabel = new JLabel("", 0);
        this.ownerLabel.setAlignmentX(0.5f);
        this.add(this.ownerLabel);
        List<GoodsType> farmedGoods = FreeCol.getSpecification().getFarmedGoodsTypeList();
        this.number = farmedGoods.size();
        this.goodsPanel = new JPanel();
        this.goodsPanel.setLayout(new FlowLayout());
        this.goodsTypes = new GoodsType[this.number];
        JLabel[] labels = new JLabel[this.number];
        for (int k = 0; k < this.number; ++k) {
            this.goodsTypes[k] = farmedGoods.get(k);
            labels[k] = new JLabel(this.canvas.getGUI().getImageLibrary().getGoodsImageIcon(this.goodsTypes[k]));
        }
        this.goodsPanel.setSize(this.goodsPanel.getPreferredSize());
        this.add(this.goodsPanel);
        this.colopediaButton = new JButton(Messages.message("menuBar.colopedia", new String[0]));
        this.colopediaButton.setActionCommand(String.valueOf(1));
        this.colopediaButton.addActionListener(this);
        TilePanel.enterPressesWhenFocused(this.colopediaButton);
        this.okButton = new JButton(Messages.message("ok", new String[0]));
        this.okButton.setActionCommand(String.valueOf(0));
        this.okButton.addActionListener(this);
        this.okButton.setAlignmentX(0.5f);
        TilePanel.enterPressesWhenFocused(this.okButton);
        ComponentInputMap inputMap = new ComponentInputMap(this.okButton);
        ((InputMap)inputMap).put(KeyStroke.getKeyStroke(27, 0, false), "pressed");
        ((InputMap)inputMap).put(KeyStroke.getKeyStroke(27, 0, true), "released");
        SwingUtilities.replaceUIInputMap(this.okButton, 2, inputMap);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.colopediaButton);
        buttonPanel.add(this.okButton);
        this.add(buttonPanel);
    }

    public void requestFocus() {
        this.okButton.requestFocus();
    }

    public void initialize(Tile tile) {
        this.tileType = tile.getType();
        String name = tile.getLabel() + " (" + tile.getX() + ", " + tile.getY() + ")";
        this.tileNameLabel.setText(name);
        if (tile.getRegion() != null) {
            this.regionLabel.setText(tile.getRegion().getDisplayName());
        }
        if (tile.getOwner() == null) {
            this.ownerLabel.setText("");
        } else {
            String ownerName = tile.getOwner().getNationAsString();
            if (ownerName == null) {
                this.ownerLabel.setText("");
            } else {
                this.ownerLabel.setText(ownerName);
            }
        }
        this.goodsPanel.removeAll();
        if (this.tileType == null) {
            this.colopediaButton.setEnabled(false);
        } else {
            List<AbstractGoods> production = this.tileType.getProduction();
            for (AbstractGoods goods : production) {
                JLabel label = new JLabel(this.canvas.getGUI().getImageLibrary().getGoodsImageIcon(goods.getType()));
                label.setText(String.valueOf(tile.potential(goods.getType(), null)));
                this.goodsPanel.add(label);
            }
        }
        this.setSize(this.getPreferredSize());
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        try {
            switch (Integer.valueOf(command)) {
                case 0: {
                    this.setResponse(new Boolean(true));
                    break;
                }
                case 1: {
                    this.setResponse(new Boolean(true));
                    this.canvas.showColopediaPanel(ColopediaPanel.PanelType.TERRAIN, this.tileType);
                    break;
                }
                default: {
                    logger.warning("Invalid Actioncommand: invalid number.");
                    break;
                }
            }
        }
        catch (NumberFormatException e) {
            logger.warning("Invalid Actioncommand: not a number.");
        }
    }
}

