/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import cz.autel.dmi.HIGLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.TradeRoute;

public final class TradeRouteDialog
extends FreeColDialog
implements ActionListener {
    private static final Logger logger = Logger.getLogger(TradeRouteDialog.class.getName());
    private final JButton ok = new JButton(Messages.message("ok", new String[0]));
    private final JButton cancel = new JButton(Messages.message("cancel", new String[0]));
    private final JButton editRouteButton = new JButton(Messages.message("traderouteDialog.editRoute", new String[0]));
    private final JButton newRouteButton = new JButton(Messages.message("traderouteDialog.newRoute", new String[0]));
    private final JButton removeRouteButton = new JButton(Messages.message("traderouteDialog.removeRoute", new String[0]));
    private final JButton deassignRouteButton = new JButton(Messages.message("traderouteDialog.deassignRoute", new String[0]));
    private final JPanel tradeRoutePanel = new JPanel();
    private final JPanel buttonPanel = new JPanel();
    private final DefaultListModel listModel = new DefaultListModel();
    private final JList tradeRoutes = new JList(this.listModel);
    private final JScrollPane tradeRouteView = new JScrollPane(this.tradeRoutes);

    public TradeRouteDialog(final Canvas parent) {
        super(parent);
        this.tradeRoutePanel.setOpaque(false);
        this.ok.setActionCommand(Action.OK.toString());
        this.cancel.setActionCommand(Action.CANCEL.toString());
        this.deassignRouteButton.setActionCommand(Action.DEASSIGN.toString());
        this.ok.addActionListener(this);
        this.cancel.addActionListener(this);
        this.deassignRouteButton.addActionListener(this);
        this.ok.setMnemonic('y');
        this.cancel.setMnemonic('n');
        this.deassignRouteButton.setToolTipText(Messages.message("traderouteDialog.deassign.tooltip", new String[0]));
        FreeColPanel.enterPressesWhenFocused(this.cancel);
        FreeColPanel.enterPressesWhenFocused(this.ok);
        FreeColPanel.enterPressesWhenFocused(this.deassignRouteButton);
        this.setCancelComponent(this.cancel);
        this.tradeRoutes.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                TradeRouteDialog.this.updateButtons();
            }
        });
        this.newRouteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Player player = parent.getClient().getMyPlayer();
                TradeRoute newRoute = parent.getClient().getModelController().getNewTradeRoute(player);
                newRoute.setName(Messages.message("traderouteDialog.newRoute", new String[0]));
                if (parent.showTradeRouteInputDialog(newRoute)) {
                    TradeRouteDialog.this.listModel.addElement(newRoute);
                }
            }
        });
        this.editRouteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                parent.showTradeRouteInputDialog((TradeRoute)TradeRouteDialog.this.tradeRoutes.getSelectedValue());
            }
        });
        this.removeRouteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TradeRouteDialog.this.listModel.removeElementAt(TradeRouteDialog.this.tradeRoutes.getSelectedIndex());
            }
        });
        int[] widths = new int[]{0};
        int[] heights = new int[]{0, 3, 0, 3, 0};
        this.setLayout(new HIGLayout(widths, heights));
        this.buttonPanel.add(this.ok);
        this.buttonPanel.add(this.cancel);
        this.buttonPanel.add(this.deassignRouteButton);
        this.buttonPanel.setOpaque(false);
        this.add((Component)TradeRouteDialog.getDefaultHeader(Messages.message("traderouteDialog.name", new String[0])), higConst.rc(1, 1));
        this.add((Component)this.tradeRoutePanel, higConst.rc(3, 1));
        this.add((Component)this.buttonPanel, higConst.rc(5, 1));
    }

    public void initialize() {
        Player player = this.getCanvas().getClient().getMyPlayer();
        this.tradeRoutePanel.removeAll();
        this.listModel.removeAllElements();
        for (TradeRoute route : player.getTradeRoutes()) {
            this.listModel.addElement(route);
        }
        this.updateButtons();
        int[] widths = new int[]{240, 3, 0};
        int[] heights = new int[]{120, 0, 3, 0, 3, 0, 120};
        int listColumn = 1;
        int buttonColumn = 3;
        this.tradeRoutePanel.setLayout(new HIGLayout(widths, heights));
        int row = 1;
        this.tradeRoutePanel.add((Component)this.tradeRouteView, higConst.rcwh(row, listColumn, 1, heights.length));
        this.tradeRoutePanel.add((Component)this.newRouteButton, higConst.rc(++row, buttonColumn));
        this.tradeRoutePanel.add((Component)this.editRouteButton, higConst.rc(row += 2, buttonColumn));
        this.tradeRoutePanel.add((Component)this.removeRouteButton, higConst.rc(row += 2, buttonColumn));
        this.setSize(this.getPreferredSize());
    }

    public void setSelectedRoute(TradeRoute selectedRoute) {
        this.tradeRoutes.setSelectedValue(selectedRoute, true);
    }

    public void requestFocus() {
        this.ok.requestFocus();
    }

    public void updateButtons() {
        if (this.tradeRoutes.getSelectedIndex() == -1) {
            this.editRouteButton.setEnabled(false);
            this.removeRouteButton.setEnabled(false);
        } else {
            this.editRouteButton.setEnabled(true);
            this.removeRouteButton.setEnabled(true);
        }
    }

    public void actionPerformed(ActionEvent event) {
        Action action = Enum.valueOf(Action.class, event.getActionCommand());
        try {
            switch (action) {
                case OK: {
                    this.getCanvas().remove(this);
                    ArrayList<TradeRoute> routes = new ArrayList<TradeRoute>();
                    for (int index = 0; index < this.listModel.getSize(); ++index) {
                        routes.add((TradeRoute)this.listModel.getElementAt(index));
                    }
                    this.getCanvas().getClient().getInGameController().setTradeRoutes(routes);
                    this.setResponse(this.tradeRoutes.getSelectedValue());
                    break;
                }
                case CANCEL: {
                    this.getCanvas().remove(this);
                    this.setResponse(null);
                    break;
                }
                case DEASSIGN: {
                    this.getCanvas().remove(this);
                    this.setResponse(TradeRoute.NO_TRADE_ROUTE);
                    break;
                }
                default: {
                    logger.warning("Invalid ActionCommand: invalid number.");
                    break;
                }
            }
        }
        catch (NumberFormatException e) {
            logger.warning("Invalid Actioncommand: not a number.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Action {
        OK,
        CANCEL,
        DEASSIGN;

    }
}

