/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import cz.autel.dmi.HIGLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.DefaultTransferHandler;
import net.sf.freecol.client.gui.panel.DragListener;
import net.sf.freecol.client.gui.panel.DropListener;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.ImageSelection;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.TradeRoute;

public final class TradeRouteInputDialog
extends FreeColDialog
implements ActionListener {
    private static final Logger logger = Logger.getLogger(TradeRouteInputDialog.class.getName());
    private static final int OK = 0;
    private static final int CANCEL = 1;
    private TradeRoute originalRoute;
    private final JButton ok = new JButton(Messages.message("ok", new String[0]));
    private final JButton cancel = new JButton(Messages.message("cancel", new String[0]));
    private final JButton addStopButton = new JButton(Messages.message("traderouteDialog.addStop", new String[0]));
    private final JButton removeStopButton = new JButton(Messages.message("traderouteDialog.removeStop", new String[0]));
    private final JPanel tradeRoutePanel = new JPanel();
    private final JPanel buttonPanel = new JPanel();
    private final CargoHandler cargoHandler = new CargoHandler();
    private final MouseListener dragListener = new DragListener(this);
    private final MouseListener dropListener = new DropListener();
    private final GoodsPanel goodsPanel;
    private final CargoPanel cargoPanel;
    private final JComboBox destinationSelector = new JComboBox();
    private final JTextField tradeRouteName = new JTextField(Messages.message("traderouteDialog.newRoute", new String[0]));
    private final DefaultListModel listModel = new DefaultListModel();
    private final JList stopList = new JList(this.listModel);
    private final JScrollPane tradeRouteView = new JScrollPane(this.stopList);
    private final JLabel nameLabel = new JLabel(Messages.message("traderouteDialog.nameLabel", new String[0]));
    private final JLabel destinationLabel = new JLabel(Messages.message("traderouteDialog.destinationLabel", new String[0]));

    public TradeRouteInputDialog(Canvas parent) {
        super(parent);
        this.tradeRoutePanel.setOpaque(false);
        this.ok.setActionCommand(String.valueOf(0));
        this.cancel.setActionCommand(String.valueOf(1));
        this.ok.addActionListener(this);
        this.cancel.addActionListener(this);
        this.ok.setMnemonic('y');
        this.cancel.setMnemonic('n');
        FreeColPanel.enterPressesWhenFocused(this.cancel);
        FreeColPanel.enterPressesWhenFocused(this.ok);
        this.setCancelComponent(this.cancel);
        this.goodsPanel = new GoodsPanel();
        this.goodsPanel.setTransferHandler(this.cargoHandler);
        this.cargoPanel = new CargoPanel();
        this.cargoPanel.setTransferHandler(this.cargoHandler);
        this.stopList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                TradeRouteInputDialog.this.updateButtons();
            }
        });
        this.addStopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int startIndex = -1;
                int endIndex = -1;
                if (TradeRouteInputDialog.this.destinationSelector.getSelectedIndex() == 0) {
                    startIndex = 1;
                    endIndex = TradeRouteInputDialog.this.destinationSelector.getItemCount() - 1;
                } else {
                    endIndex = startIndex = TradeRouteInputDialog.this.destinationSelector.getSelectedIndex();
                }
                for (int i = startIndex; i <= endIndex; ++i) {
                    TradeRoute tradeRoute = TradeRouteInputDialog.this.originalRoute;
                    tradeRoute.getClass();
                    TradeRoute.Stop stop = new TradeRoute.Stop(tradeRoute, (Location)TradeRouteInputDialog.this.destinationSelector.getItemAt(i));
                    for (Component comp : TradeRouteInputDialog.this.cargoPanel.getComponents()) {
                        CargoLabel label = (CargoLabel)comp;
                        stop.addCargo(label.getType());
                    }
                    if (TradeRouteInputDialog.this.stopList.getSelectedIndex() == -1) {
                        TradeRouteInputDialog.this.listModel.addElement(stop);
                        continue;
                    }
                    TradeRouteInputDialog.this.listModel.add(TradeRouteInputDialog.this.stopList.getSelectedIndex() + 1, stop);
                }
            }
        });
        this.removeStopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TradeRouteInputDialog.this.listModel.removeElement(TradeRouteInputDialog.this.stopList.getSelectedValue());
            }
        });
        this.stopList.setSelectionMode(0);
        this.stopList.setDragEnabled(true);
        this.stopList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                TradeRouteInputDialog.this.cargoPanel.initialize((TradeRoute.Stop)TradeRouteInputDialog.this.stopList.getSelectedValue());
            }
        });
        int[] widths = new int[]{0};
        int[] heights = new int[]{0, 3, 0, 3, 0};
        this.setLayout(new HIGLayout(widths, heights));
        this.buttonPanel.add(this.ok);
        this.buttonPanel.add(this.cancel);
        this.buttonPanel.setOpaque(false);
        this.add((Component)TradeRouteInputDialog.getDefaultHeader(Messages.message("traderouteDialog.editRoute", new String[0])), higConst.rc(1, 1));
        this.add((Component)this.tradeRoutePanel, higConst.rc(3, 1));
        this.add((Component)this.buttonPanel, higConst.rc(5, 1));
    }

    public void initialize(TradeRoute newRoute) {
        this.originalRoute = newRoute;
        TradeRoute tradeRoute = newRoute.clone();
        Player player = this.getCanvas().getClient().getMyPlayer();
        this.destinationSelector.removeAllItems();
        this.tradeRoutePanel.removeAll();
        this.cargoPanel.removeAll();
        this.listModel.removeAllElements();
        this.destinationSelector.addItem(Messages.message("report.allColonies", "%number%", ""));
        if (player.getEurope() != null) {
            this.destinationSelector.addItem(player.getEurope());
        }
        for (Settlement settlement : player.getSettlements()) {
            this.destinationSelector.addItem(settlement);
        }
        for (TradeRoute.Stop stop : tradeRoute.getStops()) {
            this.listModel.addElement(stop);
        }
        if (this.listModel.getSize() > 0) {
            this.stopList.setSelectedIndex(0);
            TradeRoute.Stop selectedStop = (TradeRoute.Stop)this.listModel.firstElement();
            this.cargoPanel.initialize(selectedStop);
        }
        this.updateButtons();
        this.tradeRouteName.setText(tradeRoute.getName());
        int[] widths = new int[]{240, 9, 0, 3, 0};
        int[] heights = new int[]{0, 9, 0, 3, 0, 3, 80, 3, 0};
        int listColumn = 1;
        int labelColumn = 3;
        int valueColumn = 5;
        this.tradeRoutePanel.setLayout(new HIGLayout(widths, heights));
        int row = 1;
        this.tradeRoutePanel.add((Component)this.tradeRouteView, higConst.rcwh(row, listColumn, 1, heights.length));
        this.tradeRoutePanel.add((Component)this.nameLabel, higConst.rc(row, labelColumn));
        this.tradeRoutePanel.add((Component)this.tradeRouteName, higConst.rc(row, valueColumn));
        this.tradeRoutePanel.add((Component)this.destinationLabel, higConst.rc(row += 2, labelColumn));
        this.tradeRoutePanel.add((Component)this.destinationSelector, higConst.rc(row, valueColumn));
        this.tradeRoutePanel.add((Component)this.goodsPanel, higConst.rcwh(row += 2, labelColumn, 3, 1));
        this.tradeRoutePanel.add((Component)this.cargoPanel, higConst.rcwh(row += 2, labelColumn, 3, 1));
        this.tradeRoutePanel.add((Component)this.addStopButton, higConst.rc(row += 2, labelColumn));
        this.tradeRoutePanel.add((Component)this.removeStopButton, higConst.rc(row, valueColumn));
        row += 2;
        this.setSize(this.getPreferredSize());
    }

    public void updateButtons() {
        if (this.stopList.getSelectedIndex() == -1) {
            this.removeStopButton.setEnabled(false);
        } else {
            this.removeStopButton.setEnabled(true);
        }
    }

    public void requestFocus() {
        this.ok.requestFocus();
    }

    private boolean verifyNewTradeRoute() {
        if (this.listModel.getSize() < 2) {
            this.getCanvas().errorMessage("traderouteDialog.notEnoughStops");
            return false;
        }
        Player player = this.getCanvas().getClient().getMyPlayer();
        for (int index = 0; index < this.listModel.getSize(); ++index) {
            TradeRoute.Stop stop = (TradeRoute.Stop)this.listModel.getElementAt(index);
            if (TradeRoute.isStopValid(player, stop)) continue;
            return false;
        }
        return true;
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        try {
            switch (Integer.valueOf(command)) {
                case 0: {
                    if (!this.verifyNewTradeRoute()) break;
                    this.getCanvas().remove(this);
                    this.originalRoute.setName(this.tradeRouteName.getText());
                    ArrayList<TradeRoute.Stop> stops = new ArrayList<TradeRoute.Stop>();
                    for (int index = 0; index < this.listModel.getSize(); ++index) {
                        stops.add((TradeRoute.Stop)this.listModel.getElementAt(index));
                    }
                    this.originalRoute.setStops(stops);
                    this.getCanvas().getClient().getInGameController().updateTradeRoute(this.originalRoute);
                    this.setResponse(new Boolean(true));
                    break;
                }
                case 1: {
                    this.getCanvas().remove(this);
                    this.setResponse(new Boolean(false));
                    break;
                }
                default: {
                    logger.warning("Invalid ActionCommand: invalid number.");
                }
            }
        }
        catch (NumberFormatException e) {
            logger.warning("Invalid Actioncommand: not a number.");
        }
    }

    public class CargoHandler
    extends TransferHandler {
        protected Transferable createTransferable(JComponent c) {
            return new ImageSelection((CargoLabel)c);
        }

        public int getSourceActions(JComponent c) {
            return 3;
        }

        public boolean importData(JComponent target, Transferable data) {
            if (this.canImport(target, data.getTransferDataFlavors())) {
                try {
                    CargoLabel label = (CargoLabel)data.getTransferData(DefaultTransferHandler.flavor);
                    if (target instanceof CargoPanel) {
                        CargoLabel newLabel = new CargoLabel(label.getType());
                        TradeRouteInputDialog.this.cargoPanel.add(newLabel);
                        TradeRouteInputDialog.this.cargoPanel.revalidate();
                        TradeRoute.Stop stop = (TradeRoute.Stop)TradeRouteInputDialog.this.stopList.getSelectedValue();
                        if (stop != null) {
                            stop.addCargo(label.getType());
                            stop.setModified(true);
                        }
                    }
                    return true;
                }
                catch (UnsupportedFlavorException ufe) {
                    logger.warning(ufe.toString());
                }
                catch (IOException ioe) {
                    logger.warning(ioe.toString());
                }
            }
            return false;
        }

        protected void exportDone(JComponent source, Transferable data, int action) {
            try {
                CargoLabel label = (CargoLabel)data.getTransferData(DefaultTransferHandler.flavor);
                if (source.getParent() instanceof CargoPanel) {
                    TradeRouteInputDialog.this.cargoPanel.remove(label);
                    TradeRoute.Stop stop = (TradeRoute.Stop)TradeRouteInputDialog.this.stopList.getSelectedValue();
                    if (stop != null) {
                        ArrayList<GoodsType> cargo = stop.getCargo();
                        for (int index = 0; index < cargo.size(); ++index) {
                            if (cargo.get(index) != label.getType()) continue;
                            cargo.remove(index);
                            stop.setModified(true);
                            break;
                        }
                        stop.setCargo(cargo);
                    }
                    TradeRouteInputDialog.this.cargoPanel.revalidate();
                    TradeRouteInputDialog.this.cargoPanel.repaint();
                }
            }
            catch (UnsupportedFlavorException ufe) {
                logger.warning(ufe.toString());
            }
            catch (IOException ioe) {
                logger.warning(ioe.toString());
            }
        }

        public boolean canImport(JComponent c, DataFlavor[] flavors) {
            for (int i = 0; i < flavors.length; ++i) {
                if (!flavors[i].equals(DefaultTransferHandler.flavor)) continue;
                return true;
            }
            return false;
        }
    }

    public class CargoPanel
    extends JPanel {
        public CargoPanel() {
            this.setOpaque(false);
            this.setBorder(BorderFactory.createTitledBorder(Messages.message("cargoOnCarrier", new String[0])));
            this.addMouseListener(TradeRouteInputDialog.this.dropListener);
        }

        public void initialize(TradeRoute.Stop newStop) {
            this.removeAll();
            if (newStop != null) {
                for (GoodsType goodsType : newStop.getCargo()) {
                    this.add(new CargoLabel(goodsType));
                }
            }
            this.revalidate();
            this.repaint();
        }
    }

    public class GoodsPanel
    extends JPanel {
        public GoodsPanel() {
            super(new GridLayout(5, 5, 3, 3));
            for (GoodsType goodsType : FreeCol.getSpecification().getGoodsTypeList()) {
                if (!goodsType.isStorable()) continue;
                CargoLabel label = new CargoLabel(goodsType);
                this.add(label);
            }
            this.setOpaque(false);
            this.setBorder(BorderFactory.createTitledBorder(Messages.message("goods", new String[0])));
            this.addMouseListener(TradeRouteInputDialog.this.dropListener);
        }
    }

    public class CargoLabel
    extends JLabel {
        private final GoodsType goodsType;

        public CargoLabel(GoodsType type) {
            super(TradeRouteInputDialog.this.getCanvas().getGUI().getImageLibrary().getGoodsImageIcon(type));
            this.setTransferHandler(TradeRouteInputDialog.this.cargoHandler);
            this.addMouseListener(TradeRouteInputDialog.this.dragListener);
            this.goodsType = type;
        }

        public GoodsType getType() {
            return this.goodsType;
        }
    }
}

