/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import cz.autel.dmi.HIGLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.InGameController;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.EuropePanel;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.UnitType;

public final class TrainDialog
extends FreeColDialog
implements ActionListener {
    private static final Logger logger = Logger.getLogger(TrainDialog.class.getName());
    private static final int NUMBER_OF_COLUMNS = 2;
    private static final String TRAIN_DONE = "DONE";
    private final Canvas parent;
    private final FreeColClient freeColClient;
    private final InGameController inGameController;
    private final JButton done = new JButton(Messages.message("trainDialog.done", new String[0]));
    private final JPanel trainPanel = new JPanel(new GridLayout(0, 2));
    private final List<UnitType> trainableUnits = new ArrayList<UnitType>();
    private final Comparator<UnitType> unitPriceComparator;
    private final int[] buttonWidths = new int[]{0, 6, 0};
    private final int[] buttonHeights;
    private final HIGLayout buttonLayout;

    public TrainDialog(Canvas parent, EuropePanel.EuropeAction europeAction) {
        JLabel question;
        this.parent = parent;
        this.freeColClient = parent.getClient();
        this.inGameController = this.freeColClient.getInGameController();
        this.setFocusCycleRoot(true);
        final Europe europe = this.freeColClient.getMyPlayer().getEurope();
        this.unitPriceComparator = new Comparator<UnitType>(){

            @Override
            public int compare(UnitType type1, UnitType type2) {
                return europe.getUnitPrice(type1) - europe.getUnitPrice(type2);
            }
        };
        switch (europeAction) {
            case TRAIN: {
                this.trainableUnits.addAll(FreeCol.getSpecification().getUnitTypesTrainedInEurope());
                this.buttonHeights = new int[]{22, 22};
                question = new JLabel(Messages.message("trainDialog.clickOn", new String[0]));
                break;
            }
            default: {
                this.trainableUnits.addAll(FreeCol.getSpecification().getUnitTypesPurchasedInEurope());
                this.buttonHeights = new int[]{30, 30};
                question = new JLabel(Messages.message("purchaseDialog.clickOn", new String[0]));
            }
        }
        this.buttonLayout = new HIGLayout(this.buttonWidths, this.buttonHeights);
        this.setLayout(new HIGLayout(new int[]{0}, new int[]{0, 9, 0, 9, 0}));
        this.done.setActionCommand(String.valueOf(TRAIN_DONE));
        this.done.addActionListener(this);
        TrainDialog.enterPressesWhenFocused(this.done);
        this.add((Component)question, higConst.rc(1, 1, ""));
        this.add((Component)this.trainPanel, higConst.rc(3, 1));
        this.add((Component)this.done, higConst.rc(5, 1, ""));
    }

    public void requestFocus() {
        this.done.requestFocus();
    }

    public void initialize() {
        this.trainPanel.removeAll();
        Player player = this.freeColClient.getMyPlayer();
        Europe europe = player.getEurope();
        ImageLibrary library = this.parent.getGUI().getImageLibrary();
        Collections.sort(this.trainableUnits, this.unitPriceComparator);
        for (UnitType unitType : this.trainableUnits) {
            int price = europe.getUnitPrice(unitType);
            JButton newButton = new JButton();
            newButton.setLayout(this.buttonLayout);
            ImageIcon unitIcon = library.getUnitImageIcon(unitType, price > player.getGold());
            JLabel unitName = new JLabel(unitType.getName());
            JLabel unitPrice = new JLabel(Messages.message("goldAmount", "%amount%", String.valueOf(price)));
            if (price > player.getGold()) {
                unitName.setEnabled(false);
                unitPrice.setEnabled(false);
                newButton.setEnabled(false);
            }
            newButton.add((Component)new JLabel(library.getScaledImageIcon(unitIcon, 0.66f)), higConst.rcwh(1, 1, 1, 2, ""));
            newButton.add((Component)unitName, higConst.rc(1, 3));
            newButton.add((Component)unitPrice, higConst.rc(2, 3));
            newButton.setActionCommand(unitType.getId());
            newButton.addActionListener(this);
            TrainDialog.enterPressesWhenFocused(newButton);
            this.trainPanel.add(newButton);
        }
        this.trainPanel.setSize(this.trainPanel.getPreferredSize());
        this.setSize(this.getPreferredSize());
        this.revalidate();
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (TRAIN_DONE.equals(command)) {
            this.setResponse(new Integer(-1));
        } else {
            UnitType unitType = FreeCol.getSpecification().getUnitType(command);
            this.inGameController.trainUnitInEurope(unitType);
            this.parent.getEuropePanel().refreshDocks();
            this.parent.getEuropePanel().refreshInPort();
            this.parent.getEuropePanel().revalidate();
            this.initialize();
        }
    }
}

